/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.logging.LogLevel;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.util.Clock;

public class BuildResultLogger
extends BuildAdapter {
    private final StyledTextOutputFactory textOutputFactory;
    private final Clock buildTimeClock;

    public BuildResultLogger(StyledTextOutputFactory textOutputFactory, Clock buildTimeClock) {
        this.textOutputFactory = textOutputFactory;
        this.buildTimeClock = buildTimeClock;
    }

    public void buildFinished(BuildResult result) {
        StyledTextOutput textOutput = this.textOutputFactory.create(BuildResultLogger.class, LogLevel.LIFECYCLE);
        textOutput.println();
        if (result.getFailure() == null) {
            textOutput.withStyle(StyledTextOutput.Style.Success).text("BUILD SUCCESSFUL");
        } else {
            textOutput.withStyle(StyledTextOutput.Style.Failure).text("BUILD FAILED");
        }
        textOutput.println();
        textOutput.println();
        textOutput.formatln("Total time: %s", this.buildTimeClock.getTime());
    }
}

