/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ParamInfo;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DClassElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DItemElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class DynamicDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(DynamicDialog.class);
    private JComboBox myClassComboBox;
    private JPanel myPanel;
    private JComboBox myTypeComboBox;
    private JLabel myTypeLabel;
    protected JBTable myParametersTable;
    private JCheckBox myStaticCheckBox;
    private JPanel myTablePane;
    private final DynamicManager myDynamicManager;
    protected final Project myProject;
    private final PsiElement myContext;
    private final DynamicElementSettings mySettings;

    public DynamicDialog(PsiElement context, DynamicElementSettings settings, TypeConstraint[] typeConstraints, boolean isTableVisible) {
        super(context.getProject(), true);
        this.$$$setupUI$$$();
        this.myProject = context.getProject();
        this.mySettings = settings;
        this.myContext = context;
        this.myDynamicManager = DynamicManager.getInstance(this.myProject);
        if (isTableVisible) {
            this.myTablePane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)GroovyBundle.message("dynamic.properties.table.name", new Object[0]), (boolean)false));
        } else {
            this.myTablePane.setVisible(false);
        }
        this.setTitle(GroovyInspectionBundle.message("dynamic.element", new Object[0]));
        this.setUpTypeComboBox(typeConstraints);
        this.setUpContainingClassComboBox();
        this.setUpStaticComboBox();
        this.init();
    }

    private void setUpStaticComboBox() {
        this.myStaticCheckBox.setSelected(this.mySettings.isStatic());
    }

    public DynamicElementSettings getSettings() {
        return this.mySettings;
    }

    protected ValidationInfo doValidate() {
        GrTypeElement typeElement = this.getEnteredTypeName();
        if (typeElement == null) {
            return new ValidationInfo(GroovyInspectionBundle.message("no.type.specified", new Object[0]), (JComponent)this.myTypeComboBox);
        }
        PsiType type = typeElement.getType();
        if (type instanceof PsiClassType && ((PsiClassType)type).resolve() == null) {
            return new ValidationInfo(GroovyInspectionBundle.message("unresolved.type.status", type.getPresentableText()), (JComponent)this.myTypeComboBox);
        }
        return null;
    }

    private void setUpContainingClassComboBox() {
        String containingClassName = this.mySettings.getContainingClassName();
        PsiClass targetClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(containingClassName, GlobalSearchScope.allScope((Project)this.myProject));
        if (targetClass == null || targetClass instanceof SyntheticElement) {
            if (!containingClassName.isEmpty()) {
                this.myClassComboBox.addItem(containingClassName);
            }
            if (!containingClassName.equals("java.lang.Object")) {
                this.myClassComboBox.addItem("java.lang.Object");
            }
            return;
        }
        for (PsiClass aClass : PsiUtil.iterateSupers(targetClass, true)) {
            this.myClassComboBox.addItem(aClass.getQualifiedName());
        }
    }

    @Nullable
    private Document createDocument(String text) {
        GroovyCodeFragment fragment = new GroovyCodeFragment(this.myProject, text);
        fragment.setContext(this.myContext);
        return PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)fragment);
    }

    private void setUpTypeComboBox(TypeConstraint[] typeConstraints) {
        EditorComboBoxEditor comboEditor = new EditorComboBoxEditor(this.myProject, (FileType)GroovyFileType.GROOVY_FILE_TYPE);
        Document document = this.createDocument("");
        LOG.assertTrue(document != null);
        comboEditor.setItem((Object)document);
        this.myTypeComboBox.setEditor((ComboBoxEditor)comboEditor);
        this.myTypeComboBox.setEditable(true);
        this.myTypeComboBox.grabFocus();
        PsiClassType type = typeConstraints.length == 1 ? typeConstraints[0].getDefaultType() : TypesUtil.getJavaLangObject(this.myContext);
        this.myTypeComboBox.getEditor().setItem(this.createDocument(type.getCanonicalText()));
    }

    @Nullable
    public GrTypeElement getEnteredTypeName() {
        Document typeEditorDocument = this.getTypeEditorDocument();
        if (typeEditorDocument == null) {
            return null;
        }
        try {
            return GroovyPsiElementFactory.getInstance(this.myProject).createTypeElement(typeEditorDocument.getText());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    public Document getTypeEditorDocument() {
        Object item = this.myTypeComboBox.getEditor().getItem();
        return item instanceof Document ? (Document)item : null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        super.doOKAction();
        this.mySettings.setContainingClassName((String)this.myClassComboBox.getSelectedItem());
        this.mySettings.setStatic(this.myStaticCheckBox.isSelected());
        GrTypeElement typeElement = this.getEnteredTypeName();
        if (typeElement == null) {
            this.mySettings.setType("java.lang.Object");
        } else {
            String typeQualifiedName;
            PsiType type = typeElement.getType();
            if (type instanceof PsiPrimitiveType) {
                type = TypesUtil.boxPrimitiveType(type, typeElement.getManager(), ProjectScope.getAllScope((Project)this.myProject));
            }
            if ((typeQualifiedName = type.getCanonicalText()) != null) {
                this.mySettings.setType(typeQualifiedName);
            } else {
                this.mySettings.setType(type.getPresentableText());
            }
        }
        final Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myContext.getContainingFile());
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                UndoManager.getInstance((Project)DynamicDialog.this.myProject).undoableActionPerformed((UndoableAction)new GlobalUndoableAction(new Document[]{document}){

                    public void undo() throws UnexpectedUndoException {
                        DItemElement itemElement;
                        if (DynamicDialog.this.mySettings.isMethod()) {
                            List<ParamInfo> myPairList = DynamicDialog.this.mySettings.getParams();
                            String[] argumentsTypes = QuickfixUtil.getArgumentsTypes(myPairList);
                            itemElement = DynamicDialog.this.myDynamicManager.findConcreteDynamicMethod(DynamicDialog.this.mySettings.getContainingClassName(), DynamicDialog.this.mySettings.getName(), argumentsTypes);
                        } else {
                            itemElement = DynamicDialog.this.myDynamicManager.findConcreteDynamicProperty(DynamicDialog.this.mySettings.getContainingClassName(), DynamicDialog.this.mySettings.getName());
                        }
                        if (itemElement == null) {
                            Messages.showWarningDialog((Project)DynamicDialog.this.myProject, (String)GroovyInspectionBundle.message("Cannot.perform.undo.operation", new Object[0]), (String)GroovyInspectionBundle.message("Undo.disable", new Object[0]));
                            return;
                        }
                        DClassElement classElement = DynamicDialog.this.myDynamicManager.getClassElementByItem(itemElement);
                        if (classElement == null) {
                            Messages.showWarningDialog((Project)DynamicDialog.this.myProject, (String)GroovyInspectionBundle.message("Cannot.perform.undo.operation", new Object[0]), (String)GroovyInspectionBundle.message("Undo.disable", new Object[0]));
                            return;
                        }
                        DynamicDialog.this.removeElement(itemElement);
                        if (classElement.getMethods().isEmpty() && classElement.getProperties().isEmpty()) {
                            DynamicDialog.this.myDynamicManager.removeClassElement(classElement);
                        }
                    }

                    public void redo() throws UnexpectedUndoException {
                        DynamicDialog.this.addElement(DynamicDialog.this.mySettings);
                    }
                });
                DynamicDialog.this.addElement(DynamicDialog.this.mySettings);
            }
        }, "Add dynamic element", null);
    }

    private void removeElement(DItemElement itemElement) {
        this.myDynamicManager.removeItemElement(itemElement);
        this.myDynamicManager.fireChange();
    }

    public void addElement(DynamicElementSettings settings) {
        if (settings.isMethod()) {
            this.myDynamicManager.addMethod(settings);
        } else {
            this.myDynamicManager.addProperty(settings);
        }
        this.myDynamicManager.fireChange();
    }

    public void doCancelAction() {
        super.doCancelAction();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTypeComboBox;
    }

    protected void setUpTypeLabel(String typeLabelText) {
        this.myTypeLabel.setText(typeLabelText);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JLabel jLabel;
        JComboBox jComboBox2;
        JBTable jBTable;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myStaticCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Static");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTablePane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myParametersTable = jBTable = new JBTable();
        jBTable.setAutoResizeMode(4);
        jBTable.setShowVerticalLines(true);
        jBTable.setEnabled(true);
        jBTable.setBackground(UIManager.getColor("ArrowButton.background"));
        jBTable.setPreferredScrollableViewportSize(new Dimension(450, 50));
        jBTable.setShowHorizontalLines(true);
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/plugins/groovy/intentions/GroovyIntentionsBundle").getString("dynamic.property.dialog.class"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClassComboBox = jComboBox2 = new JComboBox();
        jPanel3.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myTypeLabel = jLabel = new JLabel();
        jLabel.setText("Type:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTypeComboBox = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox2);
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

