/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.openapi.compiler.options.ExcludedEntriesConfigurable;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;

public class GroovyCompilerConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JTextField myHeapSize;
    private JPanel myMainPanel;
    private JPanel myExcludesPanel;
    private JBCheckBox myInvokeDynamicSupportCB;
    private final ExcludedEntriesConfigurable myExcludes;
    private final GroovyCompilerConfiguration myConfig;

    public GroovyCompilerConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myConfig = GroovyCompilerConfiguration.getInstance(project);
        this.myExcludes = this.createExcludedConfigurable(project);
    }

    public ExcludedEntriesConfigurable getExcludes() {
        return this.myExcludes;
    }

    private ExcludedEntriesConfigurable createExcludedConfigurable(Project project) {
        ExcludesConfiguration configuration = this.myConfig.getExcludeFromStubGeneration();
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && !index.isExcluded(file);
            }
        };
        descriptor.setRoots(ContainerUtil.concat((Iterable)ContainerUtil.map((Object[])ModuleManager.getInstance((Project)project).getModules(), (Function)new Function<Module, List<VirtualFile>>(){

            public List<VirtualFile> fun(Module module) {
                return ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            }
        })));
        return new ExcludedEntriesConfigurable(project, descriptor, configuration);
    }

    @NotNull
    public String getId() {
        if ("Groovy compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/compiler/GroovyCompilerConfigurable", "getId"));
        }
        return "Groovy compiler";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Groovy Compiler";
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.groovy";
    }

    public JComponent createComponent() {
        this.myExcludesPanel.add(this.myExcludes.createComponent());
        return this.myMainPanel;
    }

    public boolean isModified() {
        return !Comparing.equal((String)this.myConfig.getHeapSize(), (String)this.myHeapSize.getText()) || this.myInvokeDynamicSupportCB.isSelected() != this.myConfig.isInvokeDynamic() || this.myExcludes.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myExcludes.apply();
        this.myConfig.setHeapSize(this.myHeapSize.getText());
        this.myConfig.setInvokeDynamic(this.myInvokeDynamicSupportCB.isSelected());
    }

    public void reset() {
        this.myHeapSize.setText(this.myConfig.getHeapSize());
        this.myInvokeDynamicSupportCB.setSelected(this.myConfig.isInvokeDynamic());
        this.myExcludes.reset();
    }

    public void disposeUIResources() {
        this.myExcludes.disposeUIResources();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Groovyc settings (alternatively, you can specify Groovy-Eclipse compiler at Java Compiler page)", (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        ((Component)jLabel).setVisible(false);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CompilerBundle").getString("javac.option.max.heap.size"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeapSize = jTextField = new JTextField();
        ((Component)jTextField).setVisible(false);
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myInvokeDynamicSupportCB = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Invoke dynamic support");
        jBCheckBox.setMnemonic('D');
        jBCheckBox.setDisplayedMnemonicIndex(7);
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myExcludesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Exclude from stub generation", (int)0, (int)0, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

