/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dgm.GdkMethodHolder;
import org.jetbrains.plugins.groovy.dgm.GroovyExtensionProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;

public class DGMMemberContributor
extends NonCodeMembersContributor {
    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor", "processDynamicElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor", "processDynamicElements"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor", "processDynamicElements"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor", "processDynamicElements"));
        }
        Project project = place.getProject();
        GlobalSearchScope resolveScope = place.getResolveScope();
        GroovyPsiManager groovyPsiManager = GroovyPsiManager.getInstance(project);
        Couple<List<String>> extensions = GroovyExtensionProvider.getInstance(project).collectExtensions(resolveScope);
        List instanceCategories = (List)extensions.getFirst();
        List staticCategories = (List)extensions.getSecond();
        if (!DGMMemberContributor.processCategories(qualifierType, processor, state, project, resolveScope, groovyPsiManager, instanceCategories, false)) {
            return;
        }
        if (!DGMMemberContributor.processCategories(qualifierType, processor, state, project, resolveScope, groovyPsiManager, staticCategories, true)) {
            return;
        }
    }

    private static boolean processCategories(PsiType qualifierType, PsiScopeProcessor processor, @NotNull ResolveState state, Project project, GlobalSearchScope resolveScope, GroovyPsiManager groovyPsiManager, List<String> instanceCategories, boolean isStatic) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor", "processCategories"));
        }
        for (String category : instanceCategories) {
            PsiClass clazz = groovyPsiManager.findClassWithCache(category, resolveScope);
            if (clazz == null || GdkMethodHolder.getHolderForClass(clazz, isStatic, resolveScope).processMethods(processor, state, qualifierType, project)) continue;
            return false;
        }
        return true;
    }
}

