/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrTraitUtil {
    private static final Logger LOG = Logger.getInstance(GrTraitUtil.class);

    @Contract(value="null -> false")
    public static boolean isInterface(@Nullable PsiClass aClass) {
        return aClass != null && aClass.isInterface() && !GrTraitUtil.isTrait(aClass);
    }

    public static boolean isMethodAbstract(PsiMethod method) {
        if (method.getModifierList().hasExplicitModifier("abstract")) {
            return true;
        }
        PsiClass aClass = method.getContainingClass();
        return GrTraitUtil.isInterface(aClass);
    }

    @NotNull
    public static String getTraitFieldPrefix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/psi/util/GrTraitUtil", "getTraitFieldPrefix"));
        }
        String qname = aClass.getQualifiedName();
        LOG.assertTrue(qname != null, aClass.getClass());
        String[] idents = qname.split("\\.");
        StringBuilder buffer = new StringBuilder();
        for (String ident : idents) {
            buffer.append(ident).append("_");
        }
        buffer.append("_");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrTraitUtil", "getTraitFieldPrefix"));
        }
        return string;
    }

    @Contract(value="null -> false")
    public static boolean isTrait(@Nullable PsiClass containingClass) {
        return containingClass instanceof GrTypeDefinition && ((GrTypeDefinition)containingClass).isTrait();
    }
}

