/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.ModifiablePanel;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProvider;
import com.intellij.util.ThreeState;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.treeConflict.TreeConflictRefreshablePanel;

public class SvnTreeConflictDiffRequestProvider
implements ChangeDiffRequestProvider {
    @NotNull
    public ThreeState isEquals(@NotNull Change change1, @NotNull Change change2) {
        if (change1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change1", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider", "isEquals"));
        }
        if (change2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change2", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider", "isEquals"));
        }
        if (change1 instanceof ConflictedSvnChange && change2 instanceof ConflictedSvnChange) {
            TreeConflictDescription description2;
            if (!change1.isTreeConflict() && !change2.isTreeConflict()) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider", "isEquals"));
                }
                return threeState;
            }
            if (!change1.isTreeConflict() || !change2.isTreeConflict()) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider", "isEquals"));
                }
                return threeState;
            }
            TreeConflictDescription description1 = ((ConflictedSvnChange)change1).getBeforeDescription();
            ThreeState threeState = TreeConflictRefreshablePanel.descriptionsEqual(description1, description2 = ((ConflictedSvnChange)change2).getBeforeDescription()) ? ThreeState.YES : ThreeState.NO;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider", "isEquals"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider", "isEquals"));
        }
        return threeState;
    }

    public boolean canCreate(@Nullable Project project, @NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider", "canCreate"));
        }
        return change instanceof ConflictedSvnChange && ((ConflictedSvnChange)change).getConflictState().isTree();
    }

    @NotNull
    public DiffRequest process(@NotNull ChangeDiffRequestProducer presentable, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        if (presentable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentable", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider", "process"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider", "process"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider", "process"));
        }
        SvnTreeConflictDiffRequest svnTreeConflictDiffRequest = new SvnTreeConflictDiffRequest((ConflictedSvnChange)presentable.getChange());
        if (svnTreeConflictDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider", "process"));
        }
        return svnTreeConflictDiffRequest;
    }

    private static class SvnTreeConflictDiffViewer
    implements FrameDiffTool.DiffViewer {
        @NotNull
        private final DiffContext myContext;
        @NotNull
        private final SvnTreeConflictDiffRequest myRequest;
        @NotNull
        private final ModifiablePanel myPanel;
        @NotNull
        private final BackgroundTaskQueue myQueue;
        @NotNull
        private final TreeConflictRefreshablePanel myDelegate;

        public SvnTreeConflictDiffViewer(@NotNull DiffContext context, @NotNull SvnTreeConflictDiffRequest request) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffViewer", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffViewer", "<init>"));
            }
            this.myPanel = new ModifiablePanel();
            this.myContext = context;
            this.myRequest = request;
            this.myQueue = new BackgroundTaskQueue(this.myContext.getProject(), "Loading change details");
            this.myDelegate = new TreeConflictRefreshablePanel(this.myContext.getProject(), "Loading tree conflict details", this.myQueue, this.myRequest.getChange());
            this.myDelegate.refresh();
            this.myPanel.setContent((JComponent)this.myDelegate.getPanel());
        }

        @NotNull
        public JComponent getComponent() {
            ModifiablePanel modifiablePanel = this.myPanel;
            if (modifiablePanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffViewer", "getComponent"));
            }
            return modifiablePanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPanel;
        }

        @NotNull
        public FrameDiffTool.ToolbarComponents init() {
            FrameDiffTool.ToolbarComponents toolbarComponents = new FrameDiffTool.ToolbarComponents();
            if (toolbarComponents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffViewer", "init"));
            }
            return toolbarComponents;
        }

        public void dispose() {
            this.myQueue.clear();
        }
    }

    public static class SvnTreeConflictDiffTool
    implements FrameDiffTool {
        @NotNull
        public String getName() {
            if ("SVN tree conflict viewer" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffTool", "getName"));
            }
            return "SVN tree conflict viewer";
        }

        public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffTool", "canShow"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffTool", "canShow"));
            }
            return request instanceof SvnTreeConflictDiffRequest;
        }

        @NotNull
        public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffTool", "createComponent"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffTool", "createComponent"));
            }
            SvnTreeConflictDiffViewer svnTreeConflictDiffViewer = new SvnTreeConflictDiffViewer(context, (SvnTreeConflictDiffRequest)request);
            if (svnTreeConflictDiffViewer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffTool", "createComponent"));
            }
            return svnTreeConflictDiffViewer;
        }
    }

    public static class SvnTreeConflictDiffRequest
    extends DiffRequest {
        @NotNull
        private final ConflictedSvnChange myChange;

        public SvnTreeConflictDiffRequest(@NotNull ConflictedSvnChange change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffRequest", "<init>"));
            }
            this.myChange = change;
        }

        @NotNull
        public ConflictedSvnChange getChange() {
            ConflictedSvnChange conflictedSvnChange = this.myChange;
            if (conflictedSvnChange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/SvnTreeConflictDiffRequestProvider$SvnTreeConflictDiffRequest", "getChange"));
            }
            return conflictedSvnChange;
        }

        @Nullable
        public String getTitle() {
            return ChangeDiffRequestProducer.getRequestTitle((Change)this.myChange);
        }
    }
}

