/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.NegationCountVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyMethodWithMoreThanThreeNegationsInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        if ("Method with more than three negations" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMethodWithMoreThanThreeNegationsInspection", "getDisplayName"));
        }
        return "Method with more than three negations";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Method Metrics" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMethodWithMoreThanThreeNegationsInspection", "getGroupDisplayName"));
        }
        return "Method Metrics";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' has too many negations (" + args[0] + " > 3)";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMethodWithMoreThanThreeNegationsInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(GrMethod grMethod) {
            super.visitMethod(grMethod);
            NegationCountVisitor visitor = new NegationCountVisitor();
            GrOpenBlock body = grMethod.getBlock();
            if (body == null) {
                return;
            }
            body.accept(visitor);
            int numNegations = visitor.getNegationCount();
            if (numNegations <= 3) {
                return;
            }
            this.registerMethodError(grMethod, numNegations);
        }
    }
}

