/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InheritorsHolder;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaGlobalMemberLookupElement;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.StaticMemberProcessor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.completion.CompleteReferencesWithSameQualifier;
import org.jetbrains.plugins.groovy.lang.completion.GrDummyIdentifierProvider;
import org.jetbrains.plugins.groovy.lang.completion.GroovyClassNameInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionData;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovySmartCompletionContributor;
import org.jetbrains.plugins.groovy.lang.completion.QualifiedMethodInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.StaticImportInsertHandler;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineMethodConflictSolver;

public class GrMainCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final ElementPattern<PsiElement> AFTER_AT = PlatformPatterns.psiElement().afterLeaf(new String[]{"@"});
    public static final ElementPattern<PsiElement> IN_CATCH_TYPE = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("(")).withParent(GrCatchClause.class));

    private static void addUnfinishedMethodTypeParameters(@NotNull PsiElement position, @NotNull CompletionResultSet result) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider", "addUnfinishedMethodTypeParameters"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider", "addUnfinishedMethodTypeParameters"));
        }
        GrTypeParameterList candidate = GrMainCompletionProvider.findTypeParameterListCandidate(position);
        if (candidate != null) {
            for (GrTypeParameter p : candidate.getTypeParameters()) {
                result.addElement((LookupElement)new JavaPsiClassReferenceElement((PsiClass)p));
            }
        }
    }

    private static void suggestVariableNames(PsiElement context, CompletionResultSet result) {
        GrVariable variable;
        PsiElement parent = context.getParent();
        if (GroovyCompletionUtil.isWildcardCompletion(context)) {
            return;
        }
        if (parent instanceof GrVariable && context.equals((variable = (GrVariable)parent).getNameIdentifierGroovy())) {
            GrExpression initializer;
            PsiType type = variable.getTypeGroovy();
            if (type != null) {
                String newName;
                String name;
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)context.getProject());
                VariableKind kind = variable instanceof GrParameter ? VariableKind.PARAMETER : (variable instanceof GrField ? VariableKind.FIELD : VariableKind.LOCAL_VARIABLE);
                SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(kind, null, null, type);
                String[] names = suggestedNameInfo.names;
                if (names.length > 0 && !(name = names[0]).equals(newName = InlineMethodConflictSolver.suggestNewName(name, null, parent, new String[0]))) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)newName));
                    return;
                }
                for (String name2 : names) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)name2));
                }
            }
            if ((initializer = variable.getInitializerGroovy()) != null) {
                for (String name : GroovyNameSuggestionUtil.suggestVariableNames(initializer, new DefaultGroovyVariableNameValidator(variable), variable.hasModifierProperty("static"))) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)name));
                }
            }
        }
    }

    @Nullable
    private static GrReferenceElement findGroovyReference(@NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider", "findGroovyReference"));
        }
        PsiElement parent = position.getParent();
        if (parent instanceof GrReferenceElement) {
            return (GrReferenceElement)parent;
        }
        if (GrMainCompletionProvider.couldContainReference(position)) {
            return GroovyPsiElementFactory.getInstance(position.getProject()).createReferenceElementFromText("Foo", position);
        }
        return null;
    }

    private static boolean couldContainReference(PsiElement position) {
        return IN_CATCH_TYPE.accepts((Object)position) || AFTER_AT.accepts((Object)position) || GroovyCompletionUtil.isFirstElementAfterPossibleModifiersInVariableDeclaration(position, true) || GroovyCompletionUtil.isTupleVarNameWithoutTypeDeclared(position);
    }

    @Nullable
    private static GrTypeParameterList findTypeParameterListCandidate(@NotNull PsiElement position) {
        PsiElement child;
        PsiElement errorElement;
        PsiElement pparent;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider", "findTypeParameterListCandidate"));
        }
        PsiElement parent = position.getParent();
        if (parent instanceof GrVariable && (pparent = parent.getParent()) instanceof GrVariableDeclaration && (errorElement = PsiUtil.skipWhitespacesAndComments(parent.getPrevSibling(), false)) instanceof PsiErrorElement && (child = errorElement.getFirstChild()) instanceof GrTypeParameterList) {
            return (GrTypeParameterList)child;
        }
        return null;
    }

    public static boolean isClassNamePossible(PsiElement position) {
        PsiElement parent = position.getParent();
        if (parent instanceof GrReferenceElement) {
            return ((GrReferenceElement)parent).getQualifier() == null;
        }
        return GrMainCompletionProvider.couldContainReference(position);
    }

    private static void addAllClasses(CompletionParameters parameters, final CompletionResultSet result, InheritorsHolder inheritors) {
        GrMainCompletionProvider.addAllClasses(parameters, new Consumer<LookupElement>(){

            public void consume(LookupElement element) {
                result.addElement(element);
            }
        }, inheritors, result.getPrefixMatcher());
    }

    public static void addAllClasses(CompletionParameters parameters, final Consumer<LookupElement> consumer, final InheritorsHolder inheritors, PrefixMatcher matcher) {
        PsiElement position = parameters.getPosition();
        final boolean afterNew = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)position);
        AllClassesGetter.processJavaClasses((CompletionParameters)parameters, (PrefixMatcher)matcher, (parameters.getInvocationCount() <= 1 ? 1 : 0) != 0, (Consumer)new Consumer<PsiClass>(){

            public void consume(PsiClass psiClass) {
                for (JavaPsiClassReferenceElement element : JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)psiClass, (boolean)afterNew, (InsertHandler)new GroovyClassNameInsertHandler(), (Condition)new Condition<PsiClass>(){

                    public boolean value(PsiClass psiClass) {
                        return !inheritors.alreadyProcessed(psiClass);
                    }
                })) {
                    consumer.consume((Object)element);
                }
            }
        });
    }

    @NotNull
    static Runnable completeReference(CompletionParameters parameters, final GrReferenceElement reference, final InheritorsHolder inheritorsHolder, PrefixMatcher matcher, final Consumer<LookupElement> _consumer) {
        PsiType qualifierType;
        Consumer<LookupElement> consumer = new Consumer<LookupElement>(){
            final Set<LookupElement> added = ContainerUtil.newHashSet();

            public void consume(LookupElement element) {
                if (this.added.add(element)) {
                    _consumer.consume((Object)element);
                }
            }
        };
        final HashMap staticMembers = ContainerUtil.newHashMap();
        PsiElement qualifier = reference.getQualifier();
        PsiType psiType = qualifierType = qualifier instanceof GrExpression ? ((GrExpression)qualifier).getType() : null;
        if (reference instanceof GrReferenceExpression && (qualifier instanceof GrExpression || qualifier == null)) {
            for (String string : CompleteReferencesWithSameQualifier.getVariantsWithSameQualifier((GrReferenceExpression)reference, matcher, (GrExpression)qualifier)) {
                consumer.consume((Object)LookupElementBuilder.create((String)string).withItemTextUnderlined(true));
            }
            if (!(parameters.getInvocationCount() >= 2 || qualifier == null || qualifierType != null || qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiPackage)) {
                if (parameters.getInvocationCount() == 1) {
                    GrMainCompletionProvider.showInfo();
                }
                Runnable runnable = EmptyRunnable.INSTANCE;
                if (runnable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider", "completeReference"));
                }
                return runnable;
            }
        }
        final ArrayList zeroPriority = ContainerUtil.newArrayList();
        GroovyCompletionUtil.processVariants(reference, matcher, parameters, new Consumer<LookupElement>((Consumer)consumer){
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            public void consume(LookupElement lookupElement) {
                PrioritizedLookupElement prio;
                Object object = lookupElement.getObject();
                if (object instanceof GroovyResolveResult) {
                    object = ((GroovyResolveResult)object).getElement();
                }
                if (GrMainCompletionProvider.isLightElementDeclaredDuringCompletion(object)) {
                    return;
                }
                if (!(lookupElement instanceof LookupElementBuilder) && inheritorsHolder.alreadyProcessed(lookupElement)) {
                    return;
                }
                if (object instanceof PsiMember && JavaCompletionUtil.isInExcludedPackage((PsiMember)((PsiMember)object), (boolean)true)) {
                    return;
                }
                if (!(object instanceof PsiClass)) {
                    int priority = GrMainCompletionProvider.assignPriority(lookupElement, qualifierType);
                    lookupElement = JavaCompletionUtil.highlightIfNeeded((PsiType)qualifierType, (LookupElement)PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)priority), (Object)object, (PsiElement)reference);
                }
                if ((object instanceof PsiMethod || object instanceof PsiField) && ((PsiModifierListOwner)object).hasModifierProperty("static") && lookupElement.getLookupString().equals(((PsiMember)object).getName())) {
                    staticMembers.put(CompletionUtil.getOriginalOrSelf((PsiElement)((PsiModifierListOwner)object)), lookupElement);
                }
                if ((prio = (PrioritizedLookupElement)lookupElement.as(PrioritizedLookupElement.CLASS_CONDITION_KEY)) == null || prio.getPriority() == 0.0) {
                    zeroPriority.add(lookupElement);
                } else {
                    this.val$consumer.consume((Object)lookupElement);
                }
            }
        });
        for (LookupElement element : zeroPriority) {
            consumer.consume((Object)element);
        }
        if (qualifier == null) {
            Runnable runnable = GrMainCompletionProvider.addStaticMembers(parameters, matcher, staticMembers, consumer);
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider", "completeReference"));
            }
            return runnable;
        }
        Runnable runnable = EmptyRunnable.INSTANCE;
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider", "completeReference"));
        }
        return runnable;
    }

    private static boolean isLightElementDeclaredDuringCompletion(Object object) {
        if (!(object instanceof LightElement) || !(object instanceof PsiNamedElement)) {
            return false;
        }
        String name = ((PsiNamedElement)object).getName();
        if (name == null) {
            return false;
        }
        return name.contains("IntellijIdeaRulezzz".trim()) || name.contains(GrDummyIdentifierProvider.DUMMY_IDENTIFIER_DECAPITALIZED.trim());
    }

    private static Runnable addStaticMembers(CompletionParameters parameters, final PrefixMatcher matcher, final Map<PsiModifierListOwner, LookupElement> staticMembers, final Consumer<LookupElement> consumer) {
        final StaticMemberProcessor processor = GrMainCompletionProvider.completeStaticMembers(parameters);
        processor.processMembersOfRegisteredClasses(matcher, (PairConsumer)new PairConsumer<PsiMember, PsiClass>(){

            public void consume(PsiMember member, PsiClass psiClass) {
                if (member instanceof GrAccessorMethod) {
                    member = ((GrAccessorMethod)member).getProperty();
                }
                if (staticMembers.containsKey(member = (PsiMember)CompletionUtil.getOriginalOrSelf((PsiElement)member))) {
                    return;
                }
                String name = member.getName();
                if (name == null || !matcher.prefixMatches(name)) {
                    staticMembers.remove(member);
                    return;
                }
                JavaGlobalMemberLookupElement element = GrMainCompletionProvider.createGlobalMemberElement(member, psiClass, true);
                staticMembers.put(member, element);
                consumer.consume((Object)element);
            }
        });
        if (parameters.getInvocationCount() >= 2 && StringUtil.isNotEmpty((String)matcher.getPrefix())) {
            return new Runnable(){

                @Override
                public void run() {
                    processor.processStaticMethodsGlobally(matcher, (Consumer)new Consumer<LookupElement>(){

                        public void consume(LookupElement element) {
                            PsiMember member = (PsiMember)element.getObject();
                            if (member instanceof GrAccessorMethod) {
                                member = ((GrAccessorMethod)member).getProperty();
                            }
                            if (staticMembers.containsKey(member = (PsiMember)CompletionUtil.getOriginalOrSelf((PsiElement)member))) {
                                return;
                            }
                            staticMembers.put(member, element);
                            consumer.consume((Object)element);
                        }
                    });
                }
            };
        }
        return EmptyRunnable.INSTANCE;
    }

    private static void showInfo() {
        CompletionService.getCompletionService().setAdvertisementText(GroovyBundle.message("invoke.completion.second.time.to.show.skipped.methods", new Object[0]));
    }

    private static boolean checkForIterator(PsiMethod method) {
        if (!"next".equals(method.getName())) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiClass iterator = JavaPsiFacade.getInstance((Project)method.getProject()).findClass("java.util.Iterator", method.getResolveScope());
        return InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)iterator, (boolean)true);
    }

    private static int assignPriority(LookupElement lookupElement, PsiType qualifierType) {
        Object object = lookupElement.getObject();
        PsiSubstitutor substitutor = null;
        GroovyResolveResult resolveResult = null;
        if (object instanceof GroovyResolveResult) {
            resolveResult = (GroovyResolveResult)object;
            substitutor = resolveResult.getSubstitutor();
            object = ((GroovyResolveResult)object).getElement();
        }
        if (object instanceof GrGdkMethod && GroovyCompletionUtil.skipDefGroovyMethod((GrGdkMethod)object, substitutor, qualifierType)) {
            return -1;
        }
        if (object instanceof PsiMethod && PsiUtil.OPERATOR_METHOD_NAMES.contains(((PsiMethod)object).getName()) && !GrMainCompletionProvider.checkForIterator((PsiMethod)object)) {
            return -3;
        }
        if (object instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertyAccessor((PsiMethod)object)) {
            return -1;
        }
        if (resolveResult != null && !resolveResult.isAccessible()) {
            return -2;
        }
        return 0;
    }

    static StaticMemberProcessor completeStaticMembers(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        final PsiElement originalPosition = parameters.getOriginalPosition();
        StaticMemberProcessor processor = new StaticMemberProcessor(position){

            @NotNull
            protected LookupElement createLookupElement(@NotNull PsiMember member, @NotNull PsiClass containingClass, boolean shouldImport) {
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider$7", "createLookupElement"));
                }
                if (containingClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider$7", "createLookupElement"));
                }
                JavaGlobalMemberLookupElement javaGlobalMemberLookupElement = GrMainCompletionProvider.createGlobalMemberElement(member, containingClass, shouldImport |= originalPosition != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)originalPosition, (boolean)false));
                if (javaGlobalMemberLookupElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider$7", "createLookupElement"));
                }
                return javaGlobalMemberLookupElement;
            }

            protected LookupElement createLookupElement(@NotNull List<PsiMethod> overloads, @NotNull PsiClass containingClass, boolean shouldImport) {
                if (overloads == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloads", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider$7", "createLookupElement"));
                }
                if (containingClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider$7", "createLookupElement"));
                }
                return new JavaGlobalMemberLookupElement(overloads, containingClass, QualifiedMethodInsertHandler.INSTANCE, StaticImportInsertHandler.INSTANCE, shouldImport |= originalPosition != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)originalPosition, (boolean)false));
            }

            protected boolean isAccessible(PsiMember member) {
                boolean result = super.isAccessible(member);
                if (!result && member instanceof GrField) {
                    GrAccessorMethod[] getters = ((GrField)member).getGetters();
                    return getters.length > 0 && super.isAccessible((PsiMember)getters[0]);
                }
                return result;
            }
        };
        PsiFile file = position.getContainingFile();
        if (file instanceof GroovyFile) {
            for (GrImportStatement statement : ((GroovyFile)file).getImportStatements()) {
                PsiElement target;
                GrCodeReferenceElement importReference;
                if (!statement.isStatic() || (importReference = statement.getImportReference()) == null) continue;
                if (!statement.isOnDemand()) {
                    importReference = (GrCodeReferenceElement)importReference.getQualifier();
                }
                if (importReference == null || !((target = importReference.resolve()) instanceof PsiClass)) continue;
                processor.importMembersOf((PsiClass)target);
            }
        }
        return processor;
    }

    static JavaGlobalMemberLookupElement createGlobalMemberElement(PsiMember member, PsiClass containingClass, boolean shouldImport) {
        return new JavaGlobalMemberLookupElement(member, containingClass, QualifiedMethodInsertHandler.INSTANCE, StaticImportInsertHandler.INSTANCE, shouldImport);
    }

    public static void register(CompletionContributor contributor) {
        contributor.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(PsiElement.class), (CompletionProvider)new GrMainCompletionProvider());
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, final @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider", "addCompletions"));
        }
        GroovyCompletionData.addGroovyDocKeywords(parameters, result);
        PsiElement position = parameters.getPosition();
        if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(false, (ElementPattern)PlatformPatterns.psiElement(PsiComment.class))).accepts((Object)position)) {
            return;
        }
        GroovyCompletionData.addGroovyKeywords(parameters, result);
        GrMainCompletionProvider.addUnfinishedMethodTypeParameters(position, result);
        GrMainCompletionProvider.suggestVariableNames(position, result);
        GrReferenceElement reference = GrMainCompletionProvider.findGroovyReference(position);
        if (reference == null) {
            if (parameters.getInvocationCount() >= 2) {
                result.stopHere();
                GrMainCompletionProvider.addAllClasses(parameters, result.withPrefixMatcher(CompletionUtil.findJavaIdentifierPrefix((CompletionParameters)parameters)), new InheritorsHolder(parameters.getPosition(), result));
            }
            return;
        }
        if (reference.getParent() instanceof GrImportStatement && reference.getQualifier() != null) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)"*"));
        }
        InheritorsHolder inheritors = new InheritorsHolder(position, result);
        if (GroovySmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            GroovySmartCompletionContributor.generateInheritorVariants(parameters, result.getPrefixMatcher(), (Consumer<LookupElement>)inheritors);
        }
        Runnable addSlowVariants = GrMainCompletionProvider.completeReference(parameters, reference, inheritors, result.getPrefixMatcher(), new Consumer<LookupElement>(){

            public void consume(LookupElement lookupElement) {
                result.addElement(lookupElement);
            }
        });
        if (reference.getQualifier() == null) {
            if (!GroovySmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
                GroovySmartCompletionContributor.addExpectedClassMembers(parameters, result);
            }
            if (GrMainCompletionProvider.isClassNamePossible(position) && JavaCompletionContributor.mayStartClassName((CompletionResultSet)result)) {
                result.stopHere();
                if (parameters.getInvocationCount() >= 2) {
                    GrMainCompletionProvider.addAllClasses(parameters, result, inheritors);
                } else {
                    JavaCompletionContributor.advertiseSecondCompletion((Project)position.getProject(), (CompletionResultSet)result);
                }
            }
        }
        addSlowVariants.run();
    }
}

