/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.arguments;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrArgumentLabelImpl
extends GroovyPsiElementImpl
implements GrArgumentLabel {
    public GrArgumentLabelImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitArgumentLabel(this);
    }

    public String toString() {
        return "Argument label";
    }

    @Nullable
    private PsiPolyVariantReference getReferenceFromNamedArgumentProviders() {
        PsiPolyVariantReference res;
        NamedArgumentDescriptor descr;
        PsiElement namedArgument = this.getParent();
        if (!(namedArgument instanceof GrNamedArgument)) {
            return null;
        }
        PsiElement nameElement = this.getNameElement();
        if (!(nameElement instanceof LeafPsiElement)) {
            return null;
        }
        IElementType elementType = ((LeafPsiElement)nameElement).getElementType();
        if (elementType != GroovyTokenTypes.mIDENT && !"java.lang.String".equals(TypesUtil.getBoxedTypeName(elementType))) {
            return null;
        }
        GrCall call = PsiUtil.getCallByNamedParameter((GrNamedArgument)namedArgument);
        if (call == null) {
            return null;
        }
        String labelName = this.getName();
        Map<String, NamedArgumentDescriptor> providers = GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders(call, labelName, false);
        if (providers != null && (descr = providers.get(labelName)) != null && (res = descr.createReference(this)) != null) {
            return res;
        }
        return null;
    }

    @NotNull
    private PsiPolyVariantReference getRealReference() {
        PsiReference[] otherReferences = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
        PsiPolyVariantReference reference = this.getReferenceFromNamedArgumentProviders();
        if (otherReferences.length == 0) {
            if (reference != null) {
                PsiPolyVariantReference psiPolyVariantReference = reference;
                if (psiPolyVariantReference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "getRealReference"));
                }
                return psiPolyVariantReference;
            }
            PsiPolyVariantReferenceBase<PsiElement> psiPolyVariantReferenceBase = new PsiPolyVariantReferenceBase<PsiElement>((PsiElement)this){

                @NotNull
                public Object[] getVariants() {
                    if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl$1", "getVariants"));
                    }
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }

                @NotNull
                public ResolveResult[] multiResolve(boolean incompleteCode) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl$1", "multiResolve"));
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
            };
            if (psiPolyVariantReferenceBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "getRealReference"));
            }
            return psiPolyVariantReferenceBase;
        }
        if (reference != null) {
            PsiReference[] refs = new PsiReference[otherReferences.length + 1];
            refs[0] = reference;
            for (int i = 0; i < otherReferences.length; ++i) {
                refs[i + 1] = otherReferences[i];
            }
            otherReferences = refs;
        }
        PsiMultiReference psiMultiReference = new PsiMultiReference(otherReferences, (PsiElement)this);
        if (psiMultiReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "getRealReference"));
        }
        return psiMultiReference;
    }

    public PsiReference getReference() {
        PsiElement name = this.getNameElement();
        return name instanceof GrLiteral || name instanceof LeafPsiElement ? this : null;
    }

    @Override
    @Nullable
    public String getName() {
        Object value;
        PsiElement element = this.getNameElement();
        if (element instanceof GrLiteral) {
            return GrArgumentLabelImpl.convertToString(((GrLiteral)element).getValue());
        }
        if (element instanceof GrExpression && (value = JavaPsiFacade.getInstance((Project)this.getProject()).getConstantEvaluationHelper().computeConstantExpression(element)) instanceof String) {
            return (String)value;
        }
        IElementType elemType = element.getNode().getElementType();
        if (GroovyTokenTypes.mIDENT == elemType || TokenSets.KEYWORDS.contains(elemType)) {
            return element.getText();
        }
        return GrArgumentLabelImpl.convertToString(GrLiteralImpl.getLiteralValue(element));
    }

    private static String convertToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return null;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        return this.advancedResolve().getElement();
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] results = this.getRealReference().multiResolve(incompleteCode);
        if (results instanceof GroovyResolveResult[]) {
            GroovyResolveResult[] groovyResolveResultArray = (GroovyResolveResult[])results;
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "multiResolve"));
            }
            return groovyResolveResultArray;
        }
        GroovyResolveResult[] results1 = new GroovyResolveResult[results.length];
        for (int i = 0; i < results.length; ++i) {
            ResolveResult result = results[i];
            PsiElement element = result.getElement();
            results1[i] = element == null ? GroovyResolveResult.EMPTY_RESULT : new GroovyResolveResultImpl(element, true);
        }
        if (results1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "multiResolve"));
        }
        return results1;
    }

    @Override
    @NotNull
    public GroovyResolveResult advancedResolve() {
        GroovyResolveResult groovyResolveResult = PsiImplUtil.extractUniqueResult(this.multiResolve(false));
        if (groovyResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "advancedResolve"));
        }
        return groovyResolveResult;
    }

    @NotNull
    public String getCanonicalText() {
        String qName;
        PsiClass clazz;
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiMember && resolved instanceof PsiNamedElement && (clazz = ((PsiMember)resolved).getContainingClass()) != null && (qName = clazz.getQualifiedName()) != null) {
            String string = qName + "." + ((PsiNamedElement)resolved).getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "getCanonicalText"));
            }
            return string;
        }
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.getRealReference().handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "bindToElement"));
        }
        return this.getRealReference().bindToElement(element);
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getRealReference().isReferenceTo(element);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement getNameElement() {
        PsiElement element = this.getFirstChild();
        assert (element != null);
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "getNameElement"));
        }
        return psiElement;
    }

    @Override
    public GrExpression getExpression() {
        PsiElement nameElement = this.getNameElement();
        if (nameElement instanceof GrParenthesizedExpression) {
            return ((GrParenthesizedExpression)nameElement).getOperand();
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType getExpectedArgumentType() {
        return null;
    }

    @Override
    public PsiType getLabelType() {
        PsiElement el = this.getNameElement();
        if (el instanceof GrParenthesizedExpression) {
            return ((GrParenthesizedExpression)el).getType();
        }
        ASTNode node = el.getNode();
        if (node == null) {
            return null;
        }
        PsiType nodeType = TypesUtil.getPsiType(el, node.getElementType());
        if (nodeType != null) {
            return nodeType;
        }
        return TypesUtil.createType("java.lang.String", this);
    }

    @Override
    public GrNamedArgument getNamedArgument() {
        PsiElement parent = this.getParent();
        assert (parent instanceof GrNamedArgument);
        return (GrNamedArgument)parent;
    }

    @Override
    public PsiElement setName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl", "setName"));
        }
        PsiImplUtil.setName(newName, this.getNameElement());
        return this;
    }
}

