/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.maven.model.impl.MavenIdBean;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;

public class MavenModuleResourceConfiguration {
    @Tag(value="id")
    @NotNull
    public MavenIdBean id;
    @Tag(value="parentId")
    @Nullable
    public MavenIdBean parentId;
    @Tag(value="directory")
    @NotNull
    public String directory;
    @Tag(value="manifest")
    @Nullable
    public String manifest;
    @Tag(value="delimiters-pattern")
    @NotNull
    public String delimitersPattern;
    @Tag(value="model-map")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
    public Map<String, String> modelMap = new HashMap<String, String>();
    @Tag(value="properties")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
    public Map<String, String> properties = new HashMap<String, String>();
    @Tag(value="filtering-excluded-extensions")
    @AbstractCollection(surroundWithTag=false, elementTag="extension")
    public Set<String> filteringExclusions = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
    @OptionTag
    public String escapeString = null;
    @OptionTag
    public boolean escapeWindowsPaths = true;
    @OptionTag
    public boolean overwrite;
    @OptionTag
    public String outputDirectory = null;
    @OptionTag
    public String testOutputDirectory = null;
    @Tag(value="resources")
    @AbstractCollection(surroundWithTag=false, elementTag="resource")
    public List<ResourceRootConfiguration> resources = new ArrayList<ResourceRootConfiguration>();
    @Tag(value="test-resources")
    @AbstractCollection(surroundWithTag=false, elementTag="resource")
    public List<ResourceRootConfiguration> testResources = new ArrayList<ResourceRootConfiguration>();

    public Set<String> getFilteringExcludedExtensions() {
        if (this.filteringExclusions.isEmpty()) {
            return MavenProjectConfiguration.DEFAULT_FILTERING_EXCLUDED_EXTENSIONS;
        }
        THashSet result = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        result.addAll(MavenProjectConfiguration.DEFAULT_FILTERING_EXCLUDED_EXTENSIONS);
        result.addAll(this.filteringExclusions);
        return Collections.unmodifiableSet(result);
    }

    public int computeConfigurationHash(boolean forTestResources) {
        int result = this.computeModuleConfigurationHash();
        List<ResourceRootConfiguration> _resources = forTestResources ? this.testResources : this.resources;
        result = 31 * result;
        for (ResourceRootConfiguration resource : _resources) {
            result += resource.computeConfigurationHash();
        }
        return result;
    }

    public int computeModuleConfigurationHash() {
        int result = this.id.hashCode();
        result = 31 * result + (this.parentId != null ? this.parentId.hashCode() : 0);
        result = 31 * result + this.directory.hashCode();
        result = 31 * result + (this.manifest != null ? this.manifest.hashCode() : 0);
        result = 31 * result + this.delimitersPattern.hashCode();
        result = 31 * result + ((Object)this.modelMap).hashCode();
        result = 31 * result + ((Object)this.properties).hashCode();
        result = 31 * result + ((Object)this.filteringExclusions).hashCode();
        result = 31 * result + (this.escapeString != null ? this.escapeString.hashCode() : 0);
        result = 31 * result + (this.outputDirectory != null ? this.outputDirectory.hashCode() : 0);
        result = 31 * result + (this.testOutputDirectory != null ? this.testOutputDirectory.hashCode() : 0);
        result = 31 * result + (this.escapeWindowsPaths ? 1 : 0);
        result = 31 * result + (this.overwrite ? 1 : 0);
        return result;
    }
}

