/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.DynamicWizardStepWithDescription;
import com.android.tools.idea.wizard.ImportUIUtil;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizardStepWithHeaderAndDescription
extends DynamicWizardStepWithDescription
implements Disposable {
    protected static final ScopedStateStore.Key<String> KEY_TITLE = ScopedStateStore.createKey(DynamicWizardStepWithHeaderAndDescription.class + ".title", ScopedStateStore.Scope.STEP, String.class);
    protected static final ScopedStateStore.Key<String> KEY_MESSAGE = ScopedStateStore.createKey(DynamicWizardStepWithHeaderAndDescription.class + ".message", ScopedStateStore.Scope.STEP, String.class);
    @NotNull
    private final String myTitle;
    @Nullable
    private final String myMessage;
    private JBLabel myTitleLabel;
    private JBLabel myMessageLabel;
    private JPanel myHeaderPane;

    @Deprecated
    public DynamicWizardStepWithHeaderAndDescription(@NotNull String title, @Nullable String message, @Nullable Icon icon, @Nullable Disposable parentDisposable) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "<init>"));
        }
        this(title, message, parentDisposable);
    }

    public DynamicWizardStepWithHeaderAndDescription(@NotNull String title, @Nullable String message, @Nullable Disposable parentDisposable) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "<init>"));
        }
        super(parentDisposable);
        this.myTitle = title;
        this.myMessage = message;
        this.$$$setupUI$$$();
        int fontHeight = this.myMessageLabel.getFont().getSize();
        this.myTitleLabel.setBorder(BorderFactory.createEmptyBorder(fontHeight, 0, fontHeight, 0));
        Insets topSegmentInsets = new Insets(18, 12, 0, 12);
        this.myHeaderPane.setBorder(new EmptyBorder(topSegmentInsets));
        Font font = this.myTitleLabel.getFont();
        if (font == null) {
            font = UIUtil.getLabelFont();
        }
        font = new Font(font.getName(), font.getStyle() | 1, font.getSize() + 4);
        this.myTitleLabel.setFont(font);
    }

    @NotNull
    protected String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "getTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    protected JPanel createStepBody() {
        JPanel body = super.createStepBody();
        body.add((Component)this.myHeaderPane, "North");
        JPanel jPanel = body;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "createStepBody"));
        }
        return jPanel;
    }

    @Override
    public void init() {
        super.init();
        this.myState.put(KEY_TITLE, this.myTitle);
        this.myState.put(KEY_MESSAGE, this.myMessage);
        this.register(KEY_TITLE, this.myTitleLabel, new ScopedDataBinder.ComponentBinding<String, JBLabel>(){

            @Override
            public void setValue(@Nullable String newValue, @NotNull JBLabel component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$1", "setValue"));
                }
                component.setText(newValue);
            }
        });
        this.register(KEY_MESSAGE, this.myMessageLabel, new ScopedDataBinder.ComponentBinding<String, JLabel>(){

            @Override
            public void setValue(@Nullable String newValue, @NotNull JLabel component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$2", "setValue"));
                }
                component.setVisible(!StringUtil.isEmpty((String)newValue));
                component.setText(ImportUIUtil.makeHtmlString(newValue));
            }
        });
    }

    @NotNull
    protected WizardStepHeaderSettings getStepHeader() {
        WizardStepHeaderSettings wizardStepHeaderSettings = WizardStepHeaderSettings.createProductHeader(this.myTitle);
        if (wizardStepHeaderSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "getStepHeader"));
        }
        return wizardStepHeaderSettings;
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        String string = this.getStepHeader().title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "getStepTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return this.getStepHeader().description;
    }

    @Override
    @NotNull
    protected Color getHeaderColor() {
        Color color = this.getStepHeader().color;
        Color color2 = color == null ? super.getHeaderColor() : color;
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "getHeaderColor"));
        }
        return color2;
    }

    @Override
    @Nullable
    protected Icon getStepIcon() {
        return this.getStepHeader().stepIcon;
    }

    @Deprecated
    @Nullable
    protected JComponent getHeader() {
        return null;
    }

    @Deprecated
    @Nullable
    protected JBColor getTitleTextColor() {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.myHeaderPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTitleLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Wizard Step Title");
        jBLabel2.setHorizontalAlignment(10);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myMessageLabel = jBLabel = new JBLabel();
        jBLabel.setText("Wizard step description message");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 6, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 3, 1, 1, 0, 1, 6, new Dimension(-1, 100), new Dimension(-1, 100), new Dimension(-1, 100)));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myHeaderPane;
    }

    public static final class WizardStepHeaderSettings {
        public static final String PRODUCT_DESCRIPTION = "Android Studio";
        @NotNull
        public final String title;
        @Nullable
        public final String description;
        @Nullable
        public final Icon stepIcon;
        @Nullable
        public final Color color;

        private WizardStepHeaderSettings(@NotNull String title, @Nullable String description, @Nullable Icon stepIcon, @Nullable Color color) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$WizardStepHeaderSettings", "<init>"));
            }
            this.title = title;
            this.description = description;
            this.stepIcon = stepIcon;
            this.color = color;
        }

        @NotNull
        public static WizardStepHeaderSettings createCustomColorHeader(@NotNull Color color, @NotNull String title) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$WizardStepHeaderSettings", "createCustomColorHeader"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$WizardStepHeaderSettings", "createCustomColorHeader"));
            }
            WizardStepHeaderSettings wizardStepHeaderSettings = new WizardStepHeaderSettings(title, PRODUCT_DESCRIPTION, null, color);
            if (wizardStepHeaderSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$WizardStepHeaderSettings", "createCustomColorHeader"));
            }
            return wizardStepHeaderSettings;
        }

        @NotNull
        public static WizardStepHeaderSettings createProductHeader(@NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$WizardStepHeaderSettings", "createProductHeader"));
            }
            WizardStepHeaderSettings wizardStepHeaderSettings = new WizardStepHeaderSettings(title, PRODUCT_DESCRIPTION, null, null);
            if (wizardStepHeaderSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$WizardStepHeaderSettings", "createProductHeader"));
            }
            return wizardStepHeaderSettings;
        }

        @NotNull
        public static WizardStepHeaderSettings createTitleOnlyHeader(@NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$WizardStepHeaderSettings", "createTitleOnlyHeader"));
            }
            WizardStepHeaderSettings wizardStepHeaderSettings = new WizardStepHeaderSettings(title, null, null, null);
            if (wizardStepHeaderSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$WizardStepHeaderSettings", "createTitleOnlyHeader"));
            }
            return wizardStepHeaderSettings;
        }

        @NotNull
        public static WizardStepHeaderSettings createTitleAndDescriptionHeader(@NotNull String title, @NotNull String description) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$WizardStepHeaderSettings", "createTitleAndDescriptionHeader"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$WizardStepHeaderSettings", "createTitleAndDescriptionHeader"));
            }
            WizardStepHeaderSettings wizardStepHeaderSettings = new WizardStepHeaderSettings(title, description, null, null);
            if (wizardStepHeaderSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$WizardStepHeaderSettings", "createTitleAndDescriptionHeader"));
            }
            return wizardStepHeaderSettings;
        }
    }
}

