/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.google.common.base.Splitter;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import lombok.ast.Annotation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationValue;
import lombok.ast.ArrayAccess;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayDimension;
import lombok.ast.ArrayInitializer;
import lombok.ast.Assert;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Block;
import lombok.ast.BooleanLiteral;
import lombok.ast.Break;
import lombok.ast.Case;
import lombok.ast.Cast;
import lombok.ast.Catch;
import lombok.ast.CharLiteral;
import lombok.ast.ClassDeclaration;
import lombok.ast.ClassLiteral;
import lombok.ast.CompilationUnit;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Continue;
import lombok.ast.DoWhile;
import lombok.ast.EmptyStatement;
import lombok.ast.EnumConstant;
import lombok.ast.EnumDeclaration;
import lombok.ast.EnumTypeBody;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.ImportDeclaration;
import lombok.ast.InlineIfExpression;
import lombok.ast.InstanceOf;
import lombok.ast.IntegralLiteral;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.KeywordModifier;
import lombok.ast.LabelledStatement;
import lombok.ast.Literal;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.NullLiteral;
import lombok.ast.PackageDeclaration;
import lombok.ast.Position;
import lombok.ast.PositionFactory;
import lombok.ast.Return;
import lombok.ast.Select;
import lombok.ast.Statement;
import lombok.ast.StaticInitializer;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.Super;
import lombok.ast.Switch;
import lombok.ast.Synchronized;
import lombok.ast.This;
import lombok.ast.Throw;
import lombok.ast.Try;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeMember;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.TypeVariable;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import lombok.ast.While;
import lombok.ast.WildcardKind;

public class LombokPsiConverter {
    private static final boolean EXPAND_TYPES = false;
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.').omitEmptyStrings();
    private static final PositionFactory POSITION_FACTORY = new PositionFactory(){

        @Nullable
        public Position getPosition(final @NonNull Node node) {
            Application application = ApplicationManager.getApplication();
            if (application.isReadAccessAllowed()) {
                return this.getPositionImmediate(node);
            }
            return (Position)application.runReadAction((Computable)new Computable<Position>(){

                @Nullable
                public Position compute() {
                    return this.getPositionImmediate(node);
                }
            });
        }

        @Nullable
        private Position getPositionImmediate(@NonNull Node node) {
            Object nativeNode = node.getNativeNode();
            if (nativeNode != null) {
                PsiElement element = (PsiElement)nativeNode;
                TextRange textRange = element.getTextRange();
                int start = textRange.getStartOffset();
                int end = textRange.getEndOffset();
                PsiElement curr = element;
                while (curr != null) {
                    PsiElement qualifier;
                    PsiQualifiedReference p;
                    if (curr instanceof PsiQualifiedReference) {
                        p = (PsiQualifiedReference)curr;
                        qualifier = p.getQualifier();
                        if (qualifier != null) {
                            start = Math.min(start, qualifier.getTextOffset());
                        }
                        curr = qualifier;
                        continue;
                    }
                    if (!(curr instanceof PsiQualifiedExpression)) break;
                    p = (PsiQualifiedExpression)curr;
                    qualifier = p.getQualifier();
                    if (qualifier != null) {
                        start = Math.min(start, qualifier.getTextOffset());
                    }
                    curr = qualifier;
                }
                return new Position(start, end);
            }
            for (Node n = node; n != null; n = n.getParent()) {
                int delta;
                nativeNode = n.getNativeNode();
                if (nativeNode == null) continue;
                PsiElement element = (PsiElement)nativeNode;
                TextRange textRange = element.getTextRange();
                int start = textRange.getStartOffset();
                int end = textRange.getEndOffset();
                String substring = node instanceof Identifier ? ((Identifier)node).astValue() : (node instanceof TypeReference ? ((TypeReference)node).getTypeName() : (node instanceof KeywordModifier ? ((KeywordModifier)node).astName() : (node instanceof TypeReferencePart ? ((TypeReferencePart)node).getTypeName() : node.toString())));
                if (substring != null && (delta = element.getText().indexOf(substring)) != -1) {
                    end = (start += delta) + substring.length();
                }
                return new Position(start, end);
            }
            return null;
        }
    };

    private LombokPsiConverter() {
    }

    @Nullable
    public static CompilationUnit convert(@NonNull PsiJavaFile javaFile) {
        try {
            return LombokPsiConverter.toCompilationUnit(javaFile);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Exception e) {
            String path = javaFile.getName();
            VirtualFile virtualFile = javaFile.getVirtualFile();
            if (virtualFile != null) {
                path = virtualFile.getPath();
            }
            throw new RuntimeException("Could not convert file " + path, e);
        }
    }

    public static Node toNode(@NonNull PsiElement element) {
        if (element instanceof PsiClass) {
            return LombokPsiConverter.toTypeDeclaration((PsiClass)element);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor()) {
                return LombokPsiConverter.toConstructorDeclaration(method);
            }
            return LombokPsiConverter.toMethodDeclaration(method);
        }
        if (element instanceof PsiField) {
            return LombokPsiConverter.toField((PsiVariable)((PsiField)element));
        }
        if (element instanceof PsiVariable) {
            return LombokPsiConverter.toVariableDeclaration((PsiVariable)element);
        }
        if (element instanceof PsiIdentifier) {
            return LombokPsiConverter.toIdentifier((PsiIdentifier)element);
        }
        if (element instanceof PsiType) {
            return LombokPsiConverter.toTypeReference((PsiType)element);
        }
        if (element instanceof PsiJavaFile) {
            return LombokPsiConverter.toCompilationUnit((PsiJavaFile)element);
        }
        throw new UnsupportedOperationException("Converting element of type " + element + " not yet supported");
    }

    private static void bind(@NonNull Node node, @Nullable PsiElement element) {
        if (element != null) {
            node.setNativeNode((Object)element);
        }
        node.setPositionFactory(POSITION_FACTORY);
    }

    @NonNull
    private static CompilationUnit toCompilationUnit(@NonNull PsiJavaFile psiJavaFile) {
        CompilationUnit unit = new CompilationUnit();
        LombokPsiConverter.bind((Node)unit, (PsiElement)psiJavaFile);
        PsiPackageStatement packageStatement = psiJavaFile.getPackageStatement();
        if (packageStatement != null) {
            PackageDeclaration packageDeclaration = new PackageDeclaration();
            LombokPsiConverter.bind((Node)packageDeclaration, (PsiElement)packageStatement);
            PsiModifierList annotationList = packageStatement.getAnnotationList();
            if (annotationList != null) {
                StrictListAccessor annotations = packageDeclaration.astAnnotations();
                PsiAnnotation[] arr$ = annotationList.getAnnotations();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    PsiAnnotation annotation = arr$[i$];
                    annotations.addToEnd((Node[])new Annotation[]{LombokPsiConverter.toAnnotation(annotation)});
                }
            }
            StrictListAccessor identifiers = packageDeclaration.astParts();
            String pkg = packageStatement.getPackageReference().getQualifiedName();
            for (String part : DOT_SPLITTER.split((CharSequence)pkg)) {
                Identifier identifier = Identifier.of((String)part);
                LombokPsiConverter.bind((Node)identifier, null);
                identifiers.addToEnd((Node[])new Identifier[]{identifier});
            }
            unit.astPackageDeclaration(packageDeclaration);
        }
        StrictListAccessor imports = unit.astImportDeclarations();
        PsiImportList importList = psiJavaFile.getImportList();
        if (importList != null) {
            for (PsiImportStatementBase importStatement : importList.getAllImportStatements()) {
                ImportDeclaration imp = new ImportDeclaration();
                StrictListAccessor importParts = imp.astParts();
                PsiJavaCodeReferenceElement importReference = importStatement.getImportReference();
                if (importReference != null) {
                    for (String part : DOT_SPLITTER.split((CharSequence)importReference.getQualifiedName())) {
                        Identifier identifier = Identifier.of((String)part);
                        LombokPsiConverter.bind((Node)identifier, null);
                        importParts.addToEnd((Node[])new Identifier[]{identifier});
                    }
                }
                imp.astStarImport(importStatement.isOnDemand());
                if (importStatement instanceof PsiImportStaticStatement) {
                    imp.astStaticImport(true);
                }
                LombokPsiConverter.bind((Node)imp, (PsiElement)importStatement);
                imports.addToEnd((Node[])new ImportDeclaration[]{imp});
            }
        }
        StrictListAccessor types = unit.astTypeDeclarations();
        for (PsiClass psiClass : psiJavaFile.getClasses()) {
            TypeDeclaration type = LombokPsiConverter.toTypeDeclaration(psiClass);
            types.addToEnd((Node[])new TypeDeclaration[]{type});
        }
        return unit;
    }

    @NonNull
    private static TypeDeclaration toTypeDeclaration(@NonNull PsiClass psiClass) {
        PsiJavaCodeReferenceElement[] referenceElements;
        PsiReferenceList extendsList;
        PsiReferenceList implementsList;
        PsiTypeParameterList typeParameterList;
        PsiIdentifier nameIdentifier;
        if (psiClass.isAnnotationType()) {
            PsiModifierList modifierList;
            AnnotationDeclaration declaration = new AnnotationDeclaration();
            LombokPsiConverter.bind((Node)declaration, (PsiElement)psiClass);
            PsiIdentifier nameIdentifier2 = psiClass.getNameIdentifier();
            if (nameIdentifier2 != null) {
                declaration.astName(LombokPsiConverter.toIdentifier(nameIdentifier2));
            }
            if ((modifierList = psiClass.getModifierList()) != null) {
                declaration.astModifiers(LombokPsiConverter.toModifiers(modifierList));
            }
            declaration.astBody(LombokPsiConverter.toTypeBody(psiClass));
            return declaration;
        }
        if (psiClass.isEnum()) {
            PsiReferenceList implementsList2;
            EnumDeclaration declaration = new EnumDeclaration();
            LombokPsiConverter.bind((Node)declaration, (PsiElement)psiClass);
            PsiIdentifier nameIdentifier3 = psiClass.getNameIdentifier();
            if (nameIdentifier3 != null) {
                declaration.astName(LombokPsiConverter.toIdentifier(nameIdentifier3));
            }
            declaration = declaration.astBody(LombokPsiConverter.toEnumTypeBody(psiClass));
            PsiModifierList modifierList = psiClass.getModifierList();
            if (modifierList != null) {
                declaration.astModifiers(LombokPsiConverter.toModifiers(modifierList));
            }
            if ((implementsList2 = psiClass.getImplementsList()) != null) {
                StrictListAccessor implementing = declaration.astImplementing();
                for (PsiJavaCodeReferenceElement ref : implementsList2.getReferenceElements()) {
                    TypeReference typeReference = LombokPsiConverter.toTypeReference(ref);
                    implementing.addToEnd((Node[])new TypeReference[]{typeReference});
                }
            }
            return declaration;
        }
        if (psiClass.isInterface()) {
            PsiTypeParameterList typeParameterList2;
            PsiReferenceList extendsList2;
            PsiModifierList modifierList;
            InterfaceDeclaration declaration = new InterfaceDeclaration();
            LombokPsiConverter.bind((Node)declaration, (PsiElement)psiClass);
            PsiIdentifier nameIdentifier4 = psiClass.getNameIdentifier();
            if (nameIdentifier4 != null) {
                declaration.astName(LombokPsiConverter.toIdentifier(nameIdentifier4));
            }
            if ((modifierList = psiClass.getModifierList()) != null) {
                declaration.astModifiers(LombokPsiConverter.toModifiers(modifierList));
            }
            if ((extendsList2 = psiClass.getExtendsList()) != null) {
                StrictListAccessor extending = declaration.astExtending();
                for (PsiJavaCodeReferenceElement ref : extendsList2.getReferenceElements()) {
                    TypeReference typeReference = LombokPsiConverter.toTypeReference(ref);
                    extending.addToEnd((Node[])new TypeReference[]{typeReference});
                }
            }
            if ((typeParameterList2 = psiClass.getTypeParameterList()) != null) {
                StrictListAccessor typeVariables = declaration.astTypeVariables();
                for (PsiTypeParameter parameter : typeParameterList2.getTypeParameters()) {
                    TypeVariable v = new TypeVariable();
                    v.astName(LombokPsiConverter.toIdentifier(parameter.getName()));
                    LombokPsiConverter.bind((Node)v, null);
                    typeVariables.addToEnd((Node[])new TypeVariable[]{v});
                }
            }
            declaration.astBody(LombokPsiConverter.toTypeBody(psiClass));
            return declaration;
        }
        ClassDeclaration declaration = new ClassDeclaration();
        LombokPsiConverter.bind((Node)declaration, (PsiElement)psiClass);
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList != null) {
            declaration.astModifiers(LombokPsiConverter.toModifiers(modifierList));
        }
        if ((nameIdentifier = psiClass.getNameIdentifier()) != null) {
            declaration.astName(LombokPsiConverter.toIdentifier(nameIdentifier));
        }
        if ((typeParameterList = psiClass.getTypeParameterList()) != null) {
            StrictListAccessor typeVariables = declaration.astTypeVariables();
            for (PsiTypeParameter parameter : typeParameterList.getTypeParameters()) {
                TypeVariable v = new TypeVariable();
                v.astName(LombokPsiConverter.toIdentifier(parameter.getName()));
                LombokPsiConverter.bind((Node)v, null);
                typeVariables.addToEnd((Node[])new TypeVariable[]{v});
            }
        }
        if ((implementsList = psiClass.getImplementsList()) != null) {
            StrictListAccessor implementing = declaration.astImplementing();
            for (PsiJavaCodeReferenceElement ref : implementsList.getReferenceElements()) {
                TypeReference typeReference = LombokPsiConverter.toTypeReference(ref);
                implementing.addToEnd((Node[])new TypeReference[]{typeReference});
            }
        }
        if ((extendsList = psiClass.getExtendsList()) != null && (referenceElements = extendsList.getReferenceElements()).length > 0) {
            TypeReference typeReference = LombokPsiConverter.toTypeReference(referenceElements[0]);
            declaration.astExtending(typeReference);
        }
        declaration.astBody(LombokPsiConverter.toTypeBody(psiClass));
        return declaration;
    }

    @NonNull
    private static NormalTypeBody toTypeBody(@NonNull PsiClass psiClass) {
        NormalTypeBody body = new NormalTypeBody();
        LombokPsiConverter.bind((Node)body, (PsiElement)psiClass);
        StrictListAccessor members = body.astMembers();
        for (PsiClassInitializer psiClassInitializer : psiClass.getInitializers()) {
            PsiCodeBlock codeBlock = psiClassInitializer.getBody();
            StaticInitializer s = new StaticInitializer();
            LombokPsiConverter.bind((Node)s, (PsiElement)codeBlock);
            s.astBody(LombokPsiConverter.toBlock(codeBlock));
            members.addToEnd((Node[])new TypeMember[]{s});
        }
        for (PsiClassInitializer psiClassInitializer : psiClass.getFields()) {
            members.addToEnd((Node[])new TypeMember[]{LombokPsiConverter.toField((PsiVariable)psiClassInitializer)});
        }
        for (PsiClassInitializer psiClassInitializer : psiClass.getMethods()) {
            if (psiClassInitializer.isConstructor()) {
                members.addToEnd((Node[])new TypeMember[]{LombokPsiConverter.toConstructorDeclaration((PsiMethod)psiClassInitializer)});
                continue;
            }
            members.addToEnd((Node[])new TypeMember[]{LombokPsiConverter.toMethodDeclaration((PsiMethod)psiClassInitializer)});
        }
        for (PsiClassInitializer psiClassInitializer : psiClass.getInnerClasses()) {
            TypeDeclaration typeDeclaration = LombokPsiConverter.toTypeDeclaration((PsiClass)psiClassInitializer);
            if (!(typeDeclaration instanceof TypeMember)) continue;
            members.addToEnd((Node[])new TypeMember[]{(TypeMember)typeDeclaration});
        }
        PsiElement lBrace = psiClass.getLBrace();
        PsiElement rBrace = psiClass.getRBrace();
        if (lBrace != null && rBrace != null) {
            int start = lBrace.getTextOffset();
            int n = rBrace.getTextOffset() + 1;
            body.setPosition(new Position(start, n));
        }
        return body;
    }

    private static EnumConstant toEnumConstant(@NonNull PsiEnumConstant enumConstant) {
        EnumConstant constant = new EnumConstant();
        LombokPsiConverter.bind((Node)constant, (PsiElement)enumConstant);
        constant.astName(LombokPsiConverter.toIdentifier(enumConstant.getNameIdentifier()));
        PsiExpressionList argumentList = enumConstant.getArgumentList();
        if (argumentList != null) {
            StrictListAccessor arguments = constant.astArguments();
            for (PsiExpression argument : argumentList.getExpressions()) {
                arguments.addToEnd((Node[])new Expression[]{LombokPsiConverter.toExpression(argument)});
            }
        }
        StrictListAccessor annotations = constant.astAnnotations();
        PsiModifierList modifierList = enumConstant.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                annotations.addToEnd((Node[])new Annotation[]{LombokPsiConverter.toAnnotation(annotation)});
            }
        }
        PsiEnumConstantInitializer initializer = enumConstant.getInitializingClass();
        return constant;
    }

    @NonNull
    private static EnumTypeBody toEnumTypeBody(@NonNull PsiClass psiClass) {
        EnumTypeBody body = new EnumTypeBody();
        LombokPsiConverter.bind((Node)body, null);
        StrictListAccessor members = body.astMembers();
        for (PsiClassInitializer psiClassInitializer : psiClass.getInitializers()) {
            PsiCodeBlock codeBlock = psiClassInitializer.getBody();
            StaticInitializer s = new StaticInitializer();
            LombokPsiConverter.bind((Node)s, (PsiElement)codeBlock);
            s.astBody(LombokPsiConverter.toBlock(codeBlock));
            members.addToEnd((Node[])new TypeMember[]{s});
        }
        for (PsiClassInitializer psiClassInitializer : psiClass.getFields()) {
            if (!(psiClassInitializer instanceof PsiEnumConstant)) continue;
            PsiEnumConstant pec = (PsiEnumConstant)psiClassInitializer;
            EnumConstant enumConstant = LombokPsiConverter.toEnumConstant(pec);
            body.astConstants().addToEnd((Node[])new EnumConstant[]{enumConstant});
        }
        for (PsiClassInitializer psiClassInitializer : psiClass.getMethods()) {
            if (psiClassInitializer.isConstructor()) {
                members.addToEnd((Node[])new TypeMember[]{LombokPsiConverter.toConstructorDeclaration((PsiMethod)psiClassInitializer)});
                continue;
            }
            members.addToEnd((Node[])new TypeMember[]{LombokPsiConverter.toMethodDeclaration((PsiMethod)psiClassInitializer)});
        }
        for (PsiClassInitializer psiClassInitializer : psiClass.getInnerClasses()) {
            TypeDeclaration typeDeclaration = LombokPsiConverter.toTypeDeclaration((PsiClass)psiClassInitializer);
            if (!(typeDeclaration instanceof TypeMember)) continue;
            members.addToEnd((Node[])new TypeMember[]{(TypeMember)typeDeclaration});
        }
        return body;
    }

    @Nullable
    private static Modifiers toModifiers(@NonNull PsiModifierList list) {
        Modifiers modifiers = new Modifiers();
        LombokPsiConverter.bind((Node)modifiers, (PsiElement)list);
        StrictListAccessor annotations = modifiers.astAnnotations();
        for (PsiAnnotation annotation : list.getAnnotations()) {
            annotations.addToEnd((Node[])new Annotation[]{LombokPsiConverter.toAnnotation(annotation)});
        }
        StrictListAccessor keywords = modifiers.astKeywords();
        if (list.hasExplicitModifier("public")) {
            KeywordModifier keyword = KeywordModifier.PUBLIC();
            LombokPsiConverter.bind((Node)keyword, null);
            keywords.addToEnd((Node[])new KeywordModifier[]{keyword});
        } else if (list.hasExplicitModifier("protected")) {
            KeywordModifier keyword = KeywordModifier.PROTECTED();
            LombokPsiConverter.bind((Node)keyword, null);
            keywords.addToEnd((Node[])new KeywordModifier[]{keyword});
        } else if (list.hasExplicitModifier("private")) {
            KeywordModifier keyword = KeywordModifier.PRIVATE();
            LombokPsiConverter.bind((Node)keyword, null);
            keywords.addToEnd((Node[])new KeywordModifier[]{keyword});
        }
        if (list.hasExplicitModifier("static")) {
            KeywordModifier keyword = KeywordModifier.STATIC();
            LombokPsiConverter.bind((Node)keyword, null);
            keywords.addToEnd((Node[])new KeywordModifier[]{keyword});
        }
        if (list.hasExplicitModifier("abstract")) {
            KeywordModifier keyword = new KeywordModifier().astName("abstract");
            LombokPsiConverter.bind((Node)keyword, null);
            keywords.addToEnd((Node[])new KeywordModifier[]{keyword});
        }
        if (list.hasExplicitModifier("final")) {
            KeywordModifier keyword = KeywordModifier.FINAL();
            LombokPsiConverter.bind((Node)keyword, null);
            keywords.addToEnd((Node[])new KeywordModifier[]{keyword});
        }
        return modifiers;
    }

    @Nullable
    private static AnnotationValue toAnnotationValue(@NonNull PsiAnnotationMemberValue value) {
        if (value instanceof PsiLiteral) {
            PsiLiteral literal = (PsiLiteral)value;
            Object v = literal.getValue();
            if (v instanceof String) {
                StringLiteral string = new StringLiteral();
                LombokPsiConverter.bind((Node)string, (PsiElement)value);
                string.astValue((String)v);
                return string;
            }
            if (v instanceof Integer) {
                IntegralLiteral number = new IntegralLiteral();
                LombokPsiConverter.bind((Node)number, (PsiElement)value);
                number.astIntValue(((Integer)v).intValue());
                return number;
            }
            if (v instanceof Long) {
                IntegralLiteral number = new IntegralLiteral();
                number.astLongValue(((Long)v).longValue());
                LombokPsiConverter.bind((Node)number, (PsiElement)value);
                return number;
            }
            if (v instanceof Float) {
                FloatingPointLiteral number = new FloatingPointLiteral();
                LombokPsiConverter.bind((Node)number, (PsiElement)value);
                number.astFloatValue(((Float)v).floatValue());
                return number;
            }
            if (v instanceof Double) {
                FloatingPointLiteral number = new FloatingPointLiteral();
                LombokPsiConverter.bind((Node)number, (PsiElement)value);
                number.astDoubleValue(((Double)v).doubleValue());
                return number;
            }
            if (v instanceof Character) {
                CharLiteral charLiteral = new CharLiteral();
                LombokPsiConverter.bind((Node)charLiteral, (PsiElement)value);
                charLiteral.astValue((Character)v);
                return charLiteral;
            }
        } else {
            if (value instanceof PsiArrayInitializerMemberValue) {
                PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)value;
                ArrayInitializer initializer = new ArrayInitializer();
                LombokPsiConverter.bind((Node)initializer, (PsiElement)value);
                StrictListAccessor expressions = initializer.astExpressions();
                for (PsiAnnotationMemberValue mmv : mv.getInitializers()) {
                    AnnotationValue annotationValue = LombokPsiConverter.toAnnotationValue(mmv);
                    if (!(annotationValue instanceof Expression)) continue;
                    expressions.addToEnd((Node[])new Expression[]{(Expression)annotationValue});
                }
                return initializer;
            }
            if (value instanceof PsiExpression) {
                return LombokPsiConverter.toExpression((PsiExpression)value);
            }
            if (value instanceof PsiAnnotation) {
                return LombokPsiConverter.toAnnotation((PsiAnnotation)value);
            }
        }
        return null;
    }

    @NonNull
    private static Annotation toAnnotation(@NonNull PsiAnnotation annotation) {
        PsiNameValuePair[] attributes;
        Annotation a = new Annotation();
        LombokPsiConverter.bind((Node)a, (PsiElement)annotation);
        TypeReference typeReference = null;
        PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
        if (referenceElement != null) {
            typeReference = LombokPsiConverter.toTypeReference(referenceElement);
        }
        if (typeReference != null) {
            a.astAnnotationTypeReference(typeReference);
        }
        StrictListAccessor elements = a.astElements();
        for (PsiNameValuePair pair : attributes = annotation.getParameterList().getAttributes()) {
            PsiAnnotationMemberValue value = pair.getValue();
            assert (value != null) : pair.getName();
            AnnotationValue v = LombokPsiConverter.toAnnotationValue(value);
            if (v == null) continue;
            AnnotationElement element = new AnnotationElement();
            LombokPsiConverter.bind((Node)element, (PsiElement)pair);
            PsiIdentifier nameIdentifier = pair.getNameIdentifier();
            if (nameIdentifier != null) {
                element.astName(LombokPsiConverter.toIdentifier(nameIdentifier));
            }
            element.astValue(v);
            elements.addToEnd((Node[])new AnnotationElement[]{element});
        }
        return a;
    }

    @NonNull
    public static TypeReference toTypeReference(@NonNull PsiType type) {
        String fqcn = type.getCanonicalText();
        if (fqcn.startsWith("java.lang.")) {
            fqcn = fqcn.substring(10);
        }
        return LombokPsiConverter.toTypeReference(fqcn);
    }

    @NonNull
    private static TypeReference toTypeReference(@NonNull PsiJavaCodeReferenceElement reference) {
        return LombokPsiConverter.toTypeReference(reference.getText(), (PsiElement)reference);
    }

    @NonNull
    private static TypeReference toTypeReference(@NonNull PsiTypeElement type) {
        return LombokPsiConverter.toTypeReference(type.getText(), (PsiElement)type);
    }

    @NonNull
    private static TypeReference toTypeReference(@NonNull String fqcn, @Nullable PsiElement element) {
        TypeReference reference = LombokPsiConverter.toTypeReference(fqcn);
        LombokPsiConverter.bind((Node)reference, element);
        return reference;
    }

    @NonNull
    private static TypeReference toTypeReference(@NonNull String type) {
        int index;
        TypeReference reference = new TypeReference();
        LombokPsiConverter.bind((Node)reference, null);
        StrictListAccessor parts = reference.astParts();
        TypeReferencePart part = null;
        int n = type.length();
        int segmentStart = 0;
        char c = '\u0000';
        for (index = 0; index < n && (c = type.charAt(index)) != '<' && c != '['; ++index) {
            if (c != '.') continue;
            part = new TypeReferencePart();
            LombokPsiConverter.bind((Node)part, null);
            part.astIdentifier(LombokPsiConverter.toIdentifier(type.substring(segmentStart, index)));
            parts.addToEnd((Node[])new TypeReferencePart[]{part});
            segmentStart = index + 1;
        }
        if (segmentStart < index) {
            part = new TypeReferencePart();
            LombokPsiConverter.bind((Node)part, null);
            String segment = segmentStart == 0 && index == n ? type : type.substring(segmentStart, index);
            part.astIdentifier(LombokPsiConverter.toIdentifier(segment));
            parts.addToEnd((Node[])new TypeReferencePart[]{part});
        }
        if (index != n && part != null) {
            if (c == '<') {
                int end = type.lastIndexOf(62);
                if (end != -1) {
                    StrictListAccessor typeArguments = part.astTypeArguments();
                    int typeArgStart = index + 1;
                    int balance = 0;
                    for (int i = typeArgStart; i < end; ++i) {
                        c = type.charAt(i);
                        if (c == '<') {
                            ++balance;
                            continue;
                        }
                        if (c == '>') {
                            --balance;
                            continue;
                        }
                        if (c != ',' || balance != 0) continue;
                        int typeArgEnd = i;
                        for (int j = i - 1; j >= typeArgStart && Character.isWhitespace(type.charAt(j)); --j) {
                            --typeArgEnd;
                        }
                        typeArguments.addToEnd((Node[])new TypeReference[]{LombokPsiConverter.toTypeReference(type.substring(typeArgStart, typeArgEnd))});
                        for (typeArgStart = i + 1; typeArgStart < end && Character.isWhitespace(type.charAt(typeArgStart)); ++typeArgStart) {
                        }
                    }
                    if (typeArgStart < end) {
                        if (end == typeArgStart + 1 && type.charAt(typeArgStart) == '?') {
                            TypeReference r = new TypeReference();
                            LombokPsiConverter.bind((Node)r, null);
                            r.astWildcard(WildcardKind.UNBOUND);
                            typeArguments.addToEnd((Node[])new TypeReference[]{r});
                        } else {
                            String substring = type.substring(typeArgStart, end);
                            typeArguments.addToEnd((Node[])new TypeReference[]{LombokPsiConverter.toTypeReference(substring)});
                        }
                    }
                }
                index = end;
            }
            int arrayDimensions = 0;
            for (int i = index; i < n; ++i) {
                if (type.charAt(i) != '[') continue;
                ++arrayDimensions;
            }
            if (arrayDimensions > 0) {
                reference.astArrayDimensions(arrayDimensions);
            }
        }
        return reference;
    }

    @Nullable
    private static Expression toExpression(@NonNull PsiExpression expression) {
        if (expression instanceof PsiLiteralExpression) {
            return (Expression)LombokPsiConverter.toLiteral((PsiLiteralExpression)expression);
        }
        if (expression instanceof PsiBinaryExpression) {
            IElementType operation;
            BinaryOperator operator;
            PsiBinaryExpression p = (PsiBinaryExpression)expression;
            BinaryExpression binary = new BinaryExpression();
            LombokPsiConverter.bind((Node)binary, (PsiElement)expression);
            binary.astLeft(LombokPsiConverter.toExpression(p.getLOperand()));
            PsiExpression rExpression = p.getROperand();
            if (rExpression != null) {
                binary.astRight(LombokPsiConverter.toExpression(rExpression));
            }
            if ((operator = LombokPsiConverter.convertOperation(operation = p.getOperationTokenType())) != null) {
                binary.astOperator(operator);
            } else assert (false) : operation;
            return binary;
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression p = (PsiAssignmentExpression)expression;
            BinaryExpression binary = new BinaryExpression();
            LombokPsiConverter.bind((Node)binary, (PsiElement)expression);
            BinaryOperator operator = BinaryOperator.ASSIGN;
            IElementType operation = p.getOperationTokenType();
            if (operation == JavaTokenType.PLUSEQ) {
                operator = BinaryOperator.PLUS_ASSIGN;
            } else if (operation == JavaTokenType.MINUSEQ) {
                operator = BinaryOperator.MINUS_ASSIGN;
            } else if (operation == JavaTokenType.ASTERISKEQ) {
                operator = BinaryOperator.MULTIPLY_ASSIGN;
            } else if (operation == JavaTokenType.DIVEQ) {
                operator = BinaryOperator.DIVIDE_ASSIGN;
            } else if (operation == JavaTokenType.PERCEQ) {
                operator = BinaryOperator.REMAINDER_ASSIGN;
            } else if (operation == JavaTokenType.ANDEQ) {
                operator = BinaryOperator.AND_ASSIGN;
            } else if (operation == JavaTokenType.XOREQ) {
                operator = BinaryOperator.XOR_ASSIGN;
            } else if (operation == JavaTokenType.OREQ) {
                operator = BinaryOperator.OR_ASSIGN;
            } else if (operation == JavaTokenType.LTLTEQ) {
                operator = BinaryOperator.SHIFT_LEFT_ASSIGN;
            } else if (operation == JavaTokenType.GTGTEQ) {
                operator = BinaryOperator.SHIFT_RIGHT_ASSIGN;
            } else if (operation == JavaTokenType.GTGTGTEQ) {
                operator = BinaryOperator.BITWISE_SHIFT_RIGHT_ASSIGN;
            }
            binary.astOperator(operator);
            binary.astLeft(LombokPsiConverter.toExpression(p.getLExpression()));
            PsiExpression rExpression = p.getRExpression();
            if (rExpression != null) {
                Expression right = LombokPsiConverter.toExpression(rExpression);
                if (right != null) {
                    binary.astRight(right);
                } else assert (false) : rExpression;
            }
            return binary;
        }
        if (expression instanceof PsiQualifiedExpression) {
            PsiQualifiedExpression p = (PsiQualifiedExpression)expression;
            PsiJavaCodeReferenceElement qualifier = p.getQualifier();
            if (qualifier != null) {
                Select operand = LombokPsiConverter.toSelect((PsiQualifiedReferenceElement)qualifier);
                Select select = new Select();
                LombokPsiConverter.bind((Node)select, (PsiElement)expression);
                select.astOperand((Expression)operand);
                PsiReference reference = p.getReference();
                if (reference != null) {
                    PsiElement referenceElement = reference.getElement();
                    Identifier identifier = LombokPsiConverter.toIdentifier(referenceElement.getText());
                    LombokPsiConverter.bind((Node)identifier, referenceElement);
                    select.astIdentifier(identifier);
                }
                return select;
            }
            PsiReference reference = p.getReference();
            if (reference != null) {
                return LombokPsiConverter.toVariableReference(reference);
            }
            if (p instanceof PsiSuperExpression) {
                Super superExpression = new Super();
                LombokPsiConverter.bind((Node)superExpression, (PsiElement)p);
                return superExpression;
            }
            return LombokPsiConverter.toVariableReference(p.getText(), (PsiElement)p);
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpression = (PsiReferenceExpression)expression;
            PsiElement qualifier = refExpression.getQualifier();
            if (qualifier == null) {
                assert (refExpression.getReferenceName() != null);
                PsiReference reference = refExpression.getReference();
                if (reference != null) {
                    return LombokPsiConverter.toVariableReference(reference);
                }
                return null;
            }
            return LombokPsiConverter.toSelect(refExpression);
        }
        if (expression instanceof PsiCallExpression) {
            return LombokPsiConverter.toMethodInvocation(expression);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression p = (PsiArrayAccessExpression)expression;
            ArrayAccess arrayAccess = new ArrayAccess();
            LombokPsiConverter.bind((Node)arrayAccess, (PsiElement)p);
            PsiExpression indexExpression = p.getIndexExpression();
            if (indexExpression != null) {
                arrayAccess.astIndexExpression(LombokPsiConverter.toExpression(indexExpression));
            }
            arrayAccess.astOperand(LombokPsiConverter.toExpression(p.getArrayExpression()));
            LombokPsiConverter.bind((Node)arrayAccess, (PsiElement)expression);
            return arrayAccess;
        }
        if (expression instanceof PsiArrayInitializerExpression) {
            return LombokPsiConverter.toArrayInitializer(expression);
        }
        if (expression instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression p = (PsiInstanceOfExpression)expression;
            InstanceOf instanceOf = new InstanceOf();
            LombokPsiConverter.bind((Node)instanceOf, (PsiElement)expression);
            PsiTypeElement checkType = p.getCheckType();
            if (checkType != null) {
                instanceOf.astTypeReference(LombokPsiConverter.toTypeReference(checkType));
            }
            instanceOf.astObjectReference(LombokPsiConverter.toExpression(p.getOperand()));
            return instanceOf;
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiExpression elseExpression;
            PsiConditionalExpression p = (PsiConditionalExpression)expression;
            InlineIfExpression inlineIf = new InlineIfExpression();
            LombokPsiConverter.bind((Node)inlineIf, (PsiElement)expression);
            inlineIf.astCondition(LombokPsiConverter.toExpression(p.getCondition()));
            PsiExpression thenExpression = p.getThenExpression();
            if (thenExpression != null) {
                inlineIf.astIfTrue(LombokPsiConverter.toExpression(thenExpression));
            }
            if ((elseExpression = p.getElseExpression()) != null) {
                inlineIf.astIfFalse(LombokPsiConverter.toExpression(elseExpression));
            }
            return inlineIf;
        }
        if (expression instanceof PsiClassObjectAccessExpression) {
            PsiClassObjectAccessExpression p = (PsiClassObjectAccessExpression)expression;
            ClassLiteral literal = new ClassLiteral();
            LombokPsiConverter.bind((Node)literal, (PsiElement)p);
            literal.astTypeReference(LombokPsiConverter.toTypeReference(p.getOperand()));
            return literal;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression p = (PsiParenthesizedExpression)expression;
            PsiExpression e = p.getExpression();
            if (e != null) {
                return LombokPsiConverter.toExpression(e);
            }
            return null;
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiExpression operand;
            PsiTypeCastExpression p = (PsiTypeCastExpression)expression;
            Cast cast = new Cast();
            LombokPsiConverter.bind((Node)cast, (PsiElement)expression);
            PsiTypeElement castType = p.getCastType();
            if (castType != null) {
                cast.astTypeReference(LombokPsiConverter.toTypeReference(castType));
            }
            if ((operand = p.getOperand()) != null) {
                cast.astOperand(LombokPsiConverter.toExpression(operand));
            }
            return cast;
        }
        if (expression instanceof PsiPostfixExpression) {
            PsiPostfixExpression p = (PsiPostfixExpression)expression;
            UnaryExpression unary = new UnaryExpression();
            LombokPsiConverter.bind((Node)unary, (PsiElement)expression);
            IElementType operation = p.getOperationTokenType();
            UnaryOperator operator = null;
            if (operation == JavaTokenType.MINUSMINUS) {
                operator = UnaryOperator.POSTFIX_DECREMENT;
            } else if (operation == JavaTokenType.PLUSPLUS) {
                operator = UnaryOperator.POSTFIX_INCREMENT;
            }
            if (operator != null) {
                unary.astOperator(operator);
            } else assert (false) : operation;
            unary.astOperand(LombokPsiConverter.toExpression(p.getOperand()));
            return unary;
        }
        if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression p = (PsiPrefixExpression)expression;
            UnaryExpression unary = new UnaryExpression();
            LombokPsiConverter.bind((Node)unary, (PsiElement)expression);
            IElementType operation = p.getOperationTokenType();
            UnaryOperator operator = null;
            if (operation == JavaTokenType.MINUSMINUS) {
                operator = UnaryOperator.PREFIX_DECREMENT;
            } else if (operation == JavaTokenType.PLUSPLUS) {
                operator = UnaryOperator.PREFIX_INCREMENT;
            } else if (operation == JavaTokenType.MINUS) {
                operator = UnaryOperator.UNARY_MINUS;
            } else if (operation == JavaTokenType.PLUS) {
                operator = UnaryOperator.UNARY_PLUS;
            } else if (operation == JavaTokenType.EXCL) {
                operator = UnaryOperator.LOGICAL_NOT;
            } else if (operation == JavaTokenType.TILDE) {
                operator = UnaryOperator.BINARY_NOT;
            }
            if (operator != null) {
                unary.astOperator(operator);
            } else assert (false) : operation;
            PsiExpression operand = p.getOperand();
            if (operand != null) {
                unary.astOperand(LombokPsiConverter.toExpression(operand));
            }
            return unary;
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression p = (PsiPolyadicExpression)expression;
            IElementType operation = p.getOperationTokenType();
            BinaryOperator operator = LombokPsiConverter.convertOperation(operation);
            if (operator == null) assert (false) : operation;
            PsiExpression[] operands = p.getOperands();
            assert (operands.length >= 1);
            Expression left = LombokPsiConverter.toExpression(operands[0]);
            int n = operands.length;
            for (int i = 1; i < n; ++i) {
                Expression right = LombokPsiConverter.toExpression(operands[i]);
                BinaryExpression binary = new BinaryExpression();
                LombokPsiConverter.bind((Node)binary, (PsiElement)expression);
                binary.astOperator(operator);
                binary.astLeft(left);
                binary.astRight(right);
                left = binary;
            }
            return left;
        }
        if (expression instanceof PsiLambdaExpression) {
            return null;
        }
        return null;
    }

    @Nullable
    private static BinaryOperator convertOperation(IElementType operation) {
        BinaryOperator operator = null;
        if (operation == JavaTokenType.EQEQ) {
            operator = BinaryOperator.EQUALS;
        } else if (operation == JavaTokenType.EQ) {
            operator = BinaryOperator.ASSIGN;
        } else if (operation == JavaTokenType.OROR) {
            operator = BinaryOperator.LOGICAL_OR;
        } else if (operation == JavaTokenType.ANDAND) {
            operator = BinaryOperator.LOGICAL_AND;
        } else if (operation == JavaTokenType.NE) {
            operator = BinaryOperator.NOT_EQUALS;
        } else if (operation == JavaTokenType.GT) {
            operator = BinaryOperator.GREATER;
        } else if (operation == JavaTokenType.GE) {
            operator = BinaryOperator.GREATER_OR_EQUAL;
        } else if (operation == JavaTokenType.LT) {
            operator = BinaryOperator.LESS;
        } else if (operation == JavaTokenType.LE) {
            operator = BinaryOperator.LESS_OR_EQUAL;
        } else if (operation == JavaTokenType.OR) {
            operator = BinaryOperator.BITWISE_OR;
        } else if (operation == JavaTokenType.AND) {
            operator = BinaryOperator.BITWISE_AND;
        } else if (operation == JavaTokenType.XOR) {
            operator = BinaryOperator.BITWISE_XOR;
        } else if (operation == JavaTokenType.LTLT) {
            operator = BinaryOperator.SHIFT_LEFT;
        } else if (operation == JavaTokenType.GTGT) {
            operator = BinaryOperator.SHIFT_RIGHT;
        } else if (operation == JavaTokenType.GTGTGT) {
            operator = BinaryOperator.BITWISE_SHIFT_RIGHT;
        } else if (operation == JavaTokenType.PLUS) {
            operator = BinaryOperator.PLUS;
        } else if (operation == JavaTokenType.MINUS) {
            operator = BinaryOperator.MINUS;
        } else if (operation == JavaTokenType.ASTERISK) {
            operator = BinaryOperator.MULTIPLY;
        } else if (operation == JavaTokenType.DIV) {
            operator = BinaryOperator.DIVIDE;
        } else if (operation == JavaTokenType.PERC) {
            operator = BinaryOperator.REMAINDER;
        }
        return operator;
    }

    @NonNull
    private static ArrayInitializer toArrayInitializer(@NonNull PsiExpression expression) {
        PsiArrayInitializerExpression p = (PsiArrayInitializerExpression)expression;
        ArrayInitializer arrayInitializer = new ArrayInitializer();
        LombokPsiConverter.bind((Node)arrayInitializer, (PsiElement)expression);
        StrictListAccessor expressions = arrayInitializer.astExpressions();
        for (PsiExpression psiExpression : p.getInitializers()) {
            expressions.addToEnd((Node[])new Expression[]{LombokPsiConverter.toExpression(psiExpression)});
        }
        LombokPsiConverter.bind((Node)arrayInitializer, (PsiElement)expression);
        return arrayInitializer;
    }

    @Nullable
    private static Expression toMethodInvocation(@NonNull PsiExpression expression) {
        if (expression instanceof PsiNewExpression) {
            PsiAnonymousClass anonymousClass;
            PsiNewExpression p = (PsiNewExpression)expression;
            PsiExpression[] arrayDimensions = p.getArrayDimensions();
            PsiArrayInitializerExpression arrayInitializer = p.getArrayInitializer();
            if (arrayDimensions.length > 0 || arrayInitializer != null) {
                ArrayCreation creation = new ArrayCreation();
                LombokPsiConverter.bind((Node)creation, (PsiElement)arrayInitializer);
                PsiType type = p.getType();
                if (type != null) {
                    TypeReference typeReference = LombokPsiConverter.toTypeReference(type);
                    LombokPsiConverter.bind((Node)typeReference, (PsiElement)p);
                    if (arrayDimensions.length != 0) {
                        typeReference.astArrayDimensions(0);
                    }
                    creation.astComponentTypeReference(typeReference);
                }
                if (arrayInitializer != null) {
                    creation.astInitializer(LombokPsiConverter.toArrayInitializer((PsiExpression)arrayInitializer));
                }
                StrictListAccessor dimensions = creation.astDimensions();
                for (PsiExpression dimension : arrayDimensions) {
                    ArrayDimension d = new ArrayDimension();
                    LombokPsiConverter.bind((Node)d, (PsiElement)dimension);
                    d.astDimension(LombokPsiConverter.toExpression(dimension));
                    dimensions.addToEnd((Node[])new ArrayDimension[]{d});
                }
                return creation;
            }
            ConstructorInvocation invocation = new ConstructorInvocation();
            LombokPsiConverter.bind((Node)invocation, (PsiElement)p);
            PsiJavaCodeReferenceElement classOrAnonymousClassReference = p.getClassOrAnonymousClassReference();
            if (classOrAnonymousClassReference != null) {
                invocation.astTypeReference(LombokPsiConverter.toTypeReference(classOrAnonymousClassReference));
            }
            StrictListAccessor arguments = invocation.astArguments();
            PsiExpressionList argumentList = p.getArgumentList();
            if (argumentList != null) {
                for (PsiExpression argument : argumentList.getExpressions()) {
                    arguments.addToEnd((Node[])new Expression[]{LombokPsiConverter.toExpression(argument)});
                }
            }
            if ((anonymousClass = p.getAnonymousClass()) != null) {
                NormalTypeBody body = LombokPsiConverter.toTypeBody((PsiClass)anonymousClass);
                invocation.astAnonymousClassBody(body);
            }
            LombokPsiConverter.bind((Node)invocation, (PsiElement)expression);
            return invocation;
        }
        if (expression instanceof PsiMethodCallExpression) {
            String referenceName;
            PsiMethodCallExpression p = (PsiMethodCallExpression)expression;
            MethodInvocation invocation = new MethodInvocation();
            LombokPsiConverter.bind((Node)invocation, (PsiElement)expression);
            StrictListAccessor types = invocation.astMethodTypeArguments();
            for (PsiTypeElement t : p.getTypeArgumentList().getTypeParameterElements()) {
                TypeReference typeReference = LombokPsiConverter.toTypeReference(t);
                types.addToEnd((Node[])new TypeReference[]{typeReference});
            }
            StrictListAccessor arguments = invocation.astArguments();
            PsiExpressionList argumentList = p.getArgumentList();
            for (PsiExpression argument : argumentList.getExpressions()) {
                arguments.addToEnd((Node[])new Expression[]{LombokPsiConverter.toExpression(argument)});
            }
            PsiReferenceExpression methodExpression = p.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null) {
                invocation.astOperand(LombokPsiConverter.toExpression(qualifierExpression));
            }
            if ((referenceName = methodExpression.getReferenceName()) != null) {
                Identifier name = LombokPsiConverter.toIdentifier(referenceName);
                PsiElement referenceNameElement = methodExpression.getReferenceNameElement();
                if (referenceNameElement != null) {
                    LombokPsiConverter.bind((Node)name, referenceNameElement);
                }
                invocation.astName(name);
            }
            return invocation;
        }
        return null;
    }

    @Nullable
    private static Statement toStatement(@NonNull PsiStatement statement) {
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement p = (PsiExpressionStatement)statement;
            ExpressionStatement s = new ExpressionStatement();
            LombokPsiConverter.bind((Node)s, (PsiElement)statement);
            s.astExpression(LombokPsiConverter.toExpression(p.getExpression()));
            return s;
        }
        if (statement instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement pds = (PsiDeclarationStatement)statement;
            return LombokPsiConverter.toVariableDeclaration(pds);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement p = (PsiBlockStatement)statement;
            return LombokPsiConverter.toBlock(p.getCodeBlock());
        }
        if (statement instanceof PsiIfStatement) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            PsiIfStatement p = (PsiIfStatement)statement;
            If ifStatement = new If();
            LombokPsiConverter.bind((Node)ifStatement, (PsiElement)statement);
            PsiExpression condition = p.getCondition();
            if (condition != null) {
                Expression ifCondition = LombokPsiConverter.toExpression(condition);
                assert (ifCondition != null);
                ifStatement.astCondition(ifCondition);
            }
            if ((thenBranch = p.getThenBranch()) != null) {
                ifStatement.astStatement(LombokPsiConverter.toStatement(thenBranch));
            }
            if ((elseBranch = p.getElseBranch()) != null) {
                ifStatement.astElseStatement(LombokPsiConverter.toStatement(elseBranch));
            }
            return ifStatement;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement p = (PsiReturnStatement)statement;
            Return r = new Return();
            LombokPsiConverter.bind((Node)r, (PsiElement)statement);
            PsiExpression returnValue = p.getReturnValue();
            if (returnValue != null) {
                r.astValue(LombokPsiConverter.toExpression(returnValue));
            }
            return r;
        }
        if (statement instanceof PsiLoopStatement) {
            if (statement instanceof PsiForStatement) {
                PsiStatement body;
                PsiStatement initialization;
                PsiStatement update;
                PsiForStatement p = (PsiForStatement)statement;
                For f = new For();
                LombokPsiConverter.bind((Node)f, (PsiElement)statement);
                PsiExpression condition = p.getCondition();
                if (condition != null) {
                    f.astCondition(LombokPsiConverter.toExpression(condition));
                }
                if ((update = p.getUpdate()) != null) {
                    StrictListAccessor updates = f.astUpdates();
                    if (update instanceof PsiExpressionListStatement) {
                        PsiExpressionListStatement pl = (PsiExpressionListStatement)update;
                        for (PsiExpression e : pl.getExpressionList().getExpressions()) {
                            updates.addToEnd((Node[])new Expression[]{LombokPsiConverter.toExpression(e)});
                        }
                    } else {
                        assert (update instanceof PsiExpressionStatement) : update;
                        PsiExpressionStatement ps = (PsiExpressionStatement)update;
                        updates.addToEnd((Node[])new Expression[]{LombokPsiConverter.toExpression(ps.getExpression())});
                    }
                }
                if ((initialization = p.getInitialization()) != null) {
                    if (initialization instanceof PsiDeclarationStatement) {
                        PsiDeclarationStatement pds = (PsiDeclarationStatement)initialization;
                        f.astVariableDeclaration(LombokPsiConverter.toVariableDefinition(pds));
                    } else if (initialization instanceof PsiExpressionStatement) {
                        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)initialization;
                        f.astExpressionInits().addToEnd((Node[])new Expression[]{LombokPsiConverter.toExpression(expressionStatement.getExpression())});
                    } else if (initialization instanceof PsiExpression) {
                        PsiExpression expression = (PsiExpression)initialization;
                        f.astExpressionInits().addToEnd((Node[])new Expression[]{LombokPsiConverter.toExpression(expression)});
                    } else if (initialization instanceof PsiExpressionListStatement) {
                        PsiExpressionList expressionList = ((PsiExpressionListStatement)initialization).getExpressionList();
                        if (expressionList != null) {
                            for (PsiExpression expression : expressionList.getExpressions()) {
                                f.astExpressionInits().addToEnd((Node[])new Expression[]{LombokPsiConverter.toExpression(expression)});
                            }
                        }
                    } else if (!(initialization instanceof PsiEmptyStatement)) assert (false) : initialization + " for code " + initialization.getText();
                }
                if ((body = p.getBody()) != null) {
                    f.astStatement(LombokPsiConverter.toStatement(body));
                }
                return f;
            }
            if (statement instanceof PsiForeachStatement) {
                PsiForeachStatement p = (PsiForeachStatement)statement;
                ForEach f = new ForEach();
                LombokPsiConverter.bind((Node)f, (PsiElement)statement);
                PsiExpression iteratedValue = p.getIteratedValue();
                if (iteratedValue != null) {
                    f.astIterable(LombokPsiConverter.toExpression(iteratedValue));
                }
                f.astVariable(LombokPsiConverter.toVariableDefinition((PsiVariable)p.getIterationParameter()));
                PsiStatement body = p.getBody();
                if (body != null) {
                    f.astStatement(LombokPsiConverter.toStatement(body));
                }
                return f;
            }
            if (statement instanceof PsiDoWhileStatement) {
                PsiStatement body;
                PsiDoWhileStatement p = (PsiDoWhileStatement)statement;
                DoWhile w = new DoWhile();
                LombokPsiConverter.bind((Node)w, (PsiElement)statement);
                PsiExpression condition = p.getCondition();
                if (condition != null) {
                    w.astCondition(LombokPsiConverter.toExpression(condition));
                }
                if ((body = p.getBody()) != null) {
                    w.astStatement(LombokPsiConverter.toStatement(body));
                }
                return w;
            }
            if (statement instanceof PsiWhileStatement) {
                PsiStatement body;
                PsiWhileStatement p = (PsiWhileStatement)statement;
                While w = new While();
                LombokPsiConverter.bind((Node)w, (PsiElement)statement);
                PsiExpression condition = p.getCondition();
                if (condition != null) {
                    w.astCondition(LombokPsiConverter.toExpression(condition));
                }
                if ((body = p.getBody()) != null) {
                    w.astStatement(LombokPsiConverter.toStatement(body));
                }
                return w;
            }
            assert (false) : statement;
            return null;
        }
        if (statement instanceof PsiSwitchStatement) {
            PsiCodeBlock body;
            PsiSwitchStatement p = (PsiSwitchStatement)statement;
            Switch s = new Switch();
            LombokPsiConverter.bind((Node)s, (PsiElement)statement);
            PsiExpression expression = p.getExpression();
            if (expression != null) {
                s.astCondition(LombokPsiConverter.toExpression(expression));
            }
            if ((body = p.getBody()) != null) {
                s.astBody(LombokPsiConverter.toBlock(body));
            }
            return s;
        }
        if (statement instanceof PsiBreakStatement) {
            PsiBreakStatement p = (PsiBreakStatement)statement;
            Break s = new Break();
            LombokPsiConverter.bind((Node)s, (PsiElement)p);
            PsiIdentifier labelIdentifier = p.getLabelIdentifier();
            if (labelIdentifier != null) {
                s.astLabel(LombokPsiConverter.toIdentifier(labelIdentifier));
            }
            return s;
        }
        if (statement instanceof PsiSwitchLabelStatement) {
            PsiSwitchLabelStatement p = (PsiSwitchLabelStatement)statement;
            Case c = new Case();
            LombokPsiConverter.bind((Node)c, (PsiElement)statement);
            PsiExpression caseValue = p.getCaseValue();
            if (caseValue != null) {
                c.astCondition(LombokPsiConverter.toExpression(caseValue));
            }
            return c;
        }
        if (statement instanceof PsiLabeledStatement) {
            PsiLabeledStatement p = (PsiLabeledStatement)statement;
            LabelledStatement l = new LabelledStatement();
            LombokPsiConverter.bind((Node)l, (PsiElement)statement);
            l.astLabel(LombokPsiConverter.toIdentifier(p.getLabelIdentifier()));
            PsiStatement s = p.getStatement();
            if (s != null) {
                l.astStatement(LombokPsiConverter.toStatement(s));
            }
            return l;
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiCodeBlock body;
            PsiSynchronizedStatement p = (PsiSynchronizedStatement)statement;
            Synchronized s = new Synchronized();
            LombokPsiConverter.bind((Node)s, (PsiElement)statement);
            PsiExpression lockExpression = p.getLockExpression();
            if (lockExpression != null) {
                s.astLock(LombokPsiConverter.toExpression(lockExpression));
            }
            if ((body = p.getBody()) != null) {
                s.astBody(LombokPsiConverter.toBlock(body));
            }
            return s;
        }
        if (statement instanceof PsiContinueStatement) {
            PsiContinueStatement p = (PsiContinueStatement)statement;
            Continue c = new Continue();
            LombokPsiConverter.bind((Node)c, (PsiElement)statement);
            PsiIdentifier labelIdentifier = p.getLabelIdentifier();
            if (labelIdentifier != null) {
                c.astLabel(LombokPsiConverter.toIdentifier(labelIdentifier));
            }
            return c;
        }
        if (statement instanceof PsiTryStatement) {
            PsiCodeBlock finallyBlock;
            PsiTryStatement p = (PsiTryStatement)statement;
            Try t = new Try();
            LombokPsiConverter.bind((Node)t, (PsiElement)statement);
            StrictListAccessor catches = t.astCatches();
            for (PsiCatchSection catchSection : p.getCatchSections()) {
                PsiCodeBlock catchBlock;
                Catch c = new Catch();
                LombokPsiConverter.bind((Node)c, (PsiElement)catchSection);
                PsiParameter parameter = catchSection.getParameter();
                if (parameter != null) {
                    c.astExceptionDeclaration(LombokPsiConverter.toVariableDefinition((PsiVariable)parameter));
                }
                if ((catchBlock = catchSection.getCatchBlock()) != null) {
                    c.astBody(LombokPsiConverter.toBlock(catchBlock));
                }
                catches.addToEnd((Node[])new Catch[]{c});
            }
            PsiCodeBlock tryBlock = p.getTryBlock();
            if (tryBlock != null) {
                t.astBody(LombokPsiConverter.toBlock(tryBlock));
            }
            if ((finallyBlock = p.getFinallyBlock()) != null) {
                t.astFinally(LombokPsiConverter.toBlock(finallyBlock));
            }
            return t;
        }
        if (statement instanceof PsiEmptyStatement) {
            EmptyStatement emptyStatement = new EmptyStatement();
            LombokPsiConverter.bind((Node)emptyStatement, (PsiElement)statement);
            return emptyStatement;
        }
        if (statement instanceof PsiAssertStatement) {
            PsiExpression assertDescription;
            PsiAssertStatement p = (PsiAssertStatement)statement;
            Assert a = new Assert();
            LombokPsiConverter.bind((Node)a, (PsiElement)statement);
            PsiExpression assertCondition = p.getAssertCondition();
            if (assertCondition != null) {
                a.astAssertion(LombokPsiConverter.toExpression(assertCondition));
            }
            if ((assertDescription = p.getAssertDescription()) != null) {
                a.astMessage(LombokPsiConverter.toExpression(assertDescription));
            }
            return a;
        }
        if (statement instanceof PsiThrowStatement) {
            PsiThrowStatement p = (PsiThrowStatement)statement;
            Throw t = new Throw();
            LombokPsiConverter.bind((Node)t, (PsiElement)statement);
            PsiExpression exception = p.getException();
            if (exception != null) {
                t.astThrowable(LombokPsiConverter.toExpression(exception));
            }
            return t;
        }
        if (statement instanceof PsiExpressionListStatement) {
            assert (false);
            return null;
        }
        if (statement instanceof PsiClassLevelDeclarationStatement) {
            return null;
        }
        throw new UnsupportedOperationException("Unknown statement type for " + statement);
    }

    @NonNull
    private static Block toBlock(@NonNull PsiCodeBlock block) {
        Block b = new Block();
        LombokPsiConverter.bind((Node)b, (PsiElement)block);
        StrictListAccessor statements = b.astContents();
        for (PsiStatement statement : block.getStatements()) {
            Statement s = LombokPsiConverter.toStatement(statement);
            if (s == null) continue;
            statements.addToEnd((Node[])new Statement[]{s});
        }
        return b;
    }

    @NonNull
    private static Identifier toIdentifier(@NonNull String identifierText) {
        assert (identifierText.indexOf(46) == -1) : identifierText;
        Identifier identifier = Identifier.of((String)identifierText);
        LombokPsiConverter.bind((Node)identifier, null);
        return identifier;
    }

    @NonNull
    private static Identifier toIdentifier(@NonNull PsiIdentifier element) {
        Identifier identifier = Identifier.of((String)element.getText());
        LombokPsiConverter.bind((Node)identifier, (PsiElement)element);
        return identifier;
    }

    @Nullable
    private static Literal toLiteral(@NonNull PsiLiteralExpression expression) {
        NullLiteral literal = null;
        PsiType type = expression.getType();
        if (type == PsiType.NULL) {
            literal = new NullLiteral();
            LombokPsiConverter.bind((Node)literal, (PsiElement)expression);
        } else if (type == PsiType.INT || type == PsiType.LONG || type == PsiType.SHORT || type == PsiType.BYTE) {
            literal = new IntegralLiteral().rawValue(expression.getText());
            LombokPsiConverter.bind((Node)literal, (PsiElement)expression);
        } else if (type == PsiType.BOOLEAN) {
            literal = new BooleanLiteral().rawValue(expression.getText());
            LombokPsiConverter.bind((Node)literal, (PsiElement)expression);
        } else if (type == PsiType.DOUBLE || type == PsiType.FLOAT) {
            literal = new FloatingPointLiteral().rawValue(expression.getText());
            LombokPsiConverter.bind((Node)literal, (PsiElement)expression);
        } else if (type == PsiType.CHAR) {
            literal = new CharLiteral().rawValue(expression.getText());
            LombokPsiConverter.bind((Node)literal, (PsiElement)expression);
        } else if (type != null && type.getCanonicalText().equals("java.lang.String")) {
            StringLiteral stringLiteral = new StringLiteral();
            literal = stringLiteral.rawValue(expression.getText());
            LombokPsiConverter.bind((Node)literal, (PsiElement)expression);
            if (stringLiteral.astValue() == null) {
                Object value = expression.getValue();
                String string = value instanceof String ? (String)value : expression.getText();
                stringLiteral.astValue(string);
            }
        }
        return literal;
    }

    @NonNull
    private static VariableReference toVariableReference(@NonNull PsiIdentifier identifier) {
        VariableReference variableReference = new VariableReference();
        LombokPsiConverter.bind((Node)variableReference, (PsiElement)identifier);
        variableReference.astIdentifier(LombokPsiConverter.toIdentifier(identifier));
        return variableReference;
    }

    @NonNull
    private static VariableReference toVariableReference(@NonNull PsiReference reference) {
        PsiElement element = reference.getElement();
        VariableReference variableReference = new VariableReference();
        LombokPsiConverter.bind((Node)variableReference, element);
        Identifier identifier = LombokPsiConverter.toIdentifier(reference.getElement().getText());
        LombokPsiConverter.bind((Node)identifier, element);
        variableReference.astIdentifier(identifier);
        return variableReference;
    }

    @NonNull
    private static VariableReference toVariableReference(@NonNull String identifier, @Nullable PsiElement element) {
        VariableReference variableReference = new VariableReference();
        LombokPsiConverter.bind((Node)variableReference, element);
        Identifier name = LombokPsiConverter.toIdentifier(identifier);
        variableReference.astIdentifier(name);
        return variableReference;
    }

    @NonNull
    private static VariableDefinitionEntry toVariableDefinitionEntry(@NonNull PsiVariable variable) {
        PsiExpression initializer;
        VariableDefinitionEntry entry = new VariableDefinitionEntry();
        LombokPsiConverter.bind((Node)entry, (PsiElement)variable);
        PsiIdentifier nameIdentifier = variable.getNameIdentifier();
        if (nameIdentifier != null) {
            entry.astName(LombokPsiConverter.toIdentifier(nameIdentifier));
        }
        if ((initializer = variable.getInitializer()) != null) {
            entry.astInitializer(LombokPsiConverter.toExpression(initializer));
        }
        return entry;
    }

    @NonNull
    static VariableDefinition toVariableDefinition(@NonNull PsiVariable variable) {
        TypeReference typeReference;
        int arrayDimensions;
        PsiTypeElement type;
        VariableDefinition definition = new VariableDefinition();
        LombokPsiConverter.bind((Node)definition, (PsiElement)variable);
        PsiModifierList modifierList = variable.getModifierList();
        if (modifierList != null) {
            definition.astModifiers(LombokPsiConverter.toModifiers(modifierList));
        }
        if ((type = variable.getTypeElement()) != null) {
            definition.astTypeReference(LombokPsiConverter.toTypeReference(type));
        }
        if ((arrayDimensions = variable.getType().getArrayDimensions()) != 0 && (typeReference = definition.astTypeReference()) != null) {
            typeReference.astArrayDimensions(arrayDimensions);
        }
        VariableDefinitionEntry entry = LombokPsiConverter.toVariableDefinitionEntry(variable);
        definition.astVariables().addToEnd((Node[])new VariableDefinitionEntry[]{entry});
        return definition;
    }

    private static void setOperand(@NonNull Select select, @NonNull PsiElement qualifier) {
        if (qualifier instanceof PsiIdentifier) {
            select.astOperand((Expression)LombokPsiConverter.toVariableReference((PsiIdentifier)qualifier));
        } else if (qualifier instanceof PsiSuperExpression) {
            Super operand = new Super();
            LombokPsiConverter.bind((Node)operand, qualifier);
            select.astOperand((Expression)operand);
        } else if (qualifier instanceof PsiThisExpression) {
            This operand = new This();
            LombokPsiConverter.bind((Node)operand, qualifier);
            select.astOperand((Expression)operand);
        } else if (qualifier instanceof PsiReferenceExpression) {
            select.astOperand(LombokPsiConverter.toSelect((PsiReferenceExpression)qualifier));
        } else if (qualifier instanceof PsiCallExpression) {
            select.astOperand(LombokPsiConverter.toMethodInvocation((PsiExpression)((PsiCallExpression)qualifier)));
        } else if (qualifier instanceof PsiExpression) {
            select.astOperand(LombokPsiConverter.toExpression((PsiExpression)qualifier));
        } else {
            throw new UnsupportedOperationException("Unknown select qualifier type: " + qualifier);
        }
    }

    @NonNull
    private static Select toSelect(@NonNull PsiQualifiedReferenceElement reference) {
        Select select = new Select();
        LombokPsiConverter.bind((Node)select, (PsiElement)reference);
        Identifier nameIdentifier = Identifier.of((String)reference.getReferenceName());
        LombokPsiConverter.bind((Node)nameIdentifier, null);
        select.astIdentifier(nameIdentifier);
        PsiElement qualifier = reference.getQualifier();
        if (qualifier != null) {
            LombokPsiConverter.setOperand(select, qualifier);
        }
        return select;
    }

    @Nullable
    private static Expression toSelect(@NonNull PsiReferenceExpression reference) {
        PsiExpression qualifier = reference.getQualifierExpression();
        String referenceName = reference.getReferenceName();
        if (qualifier != null && referenceName != null) {
            Select select = new Select();
            LombokPsiConverter.bind((Node)select, (PsiElement)reference);
            Identifier nameIdentifier = Identifier.of((String)referenceName);
            LombokPsiConverter.bind((Node)nameIdentifier, null);
            select.astIdentifier(nameIdentifier);
            LombokPsiConverter.setOperand(select, (PsiElement)qualifier);
            return select;
        }
        if (qualifier != null) {
            return LombokPsiConverter.toExpression(qualifier);
        }
        if (referenceName != null) {
            return LombokPsiConverter.toVariableReference(referenceName, (PsiElement)qualifier);
        }
        return null;
    }

    @NonNull
    private static Expression toSelect(@NonNull String fqcn, @Nullable PsiElement element) {
        Select select = null;
        Iterator iterator = DOT_SPLITTER.split((CharSequence)fqcn).iterator();
        String first = (String)iterator.next();
        VariableReference operand = LombokPsiConverter.toVariableReference(first, null);
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            select = new Select();
            LombokPsiConverter.bind((Node)select, null);
            Identifier identifier = Identifier.of((String)name);
            LombokPsiConverter.bind((Node)identifier, null);
            select.astIdentifier(identifier);
            select.astOperand((Expression)operand);
            select.astIdentifier(identifier);
            operand = select;
        }
        if (select != null) {
            LombokPsiConverter.bind(select, element);
            assert (select.toString().equals(fqcn)) : fqcn;
        } else {
            return operand;
        }
        return select;
    }

    @NonNull
    private static VariableDeclaration toField(@NonNull PsiVariable field) {
        return LombokPsiConverter.toVariableDeclaration(field);
    }

    @NonNull
    private static VariableDeclaration toVariableDeclaration(@NonNull PsiDeclarationStatement statement) {
        VariableDeclaration declaration = new VariableDeclaration();
        LombokPsiConverter.bind((Node)declaration, (PsiElement)statement);
        VariableDefinition definition = LombokPsiConverter.toVariableDefinition(statement);
        declaration.astDefinition(definition);
        return declaration;
    }

    @NonNull
    private static VariableDefinition toVariableDefinition(@NonNull PsiDeclarationStatement statement) {
        VariableDefinition definition = new VariableDefinition();
        LombokPsiConverter.bind((Node)definition, (PsiElement)statement);
        Modifiers modifiers = null;
        for (PsiElement element : statement.getDeclaredElements()) {
            PsiVariable variable;
            if (element instanceof PsiVariable) {
                PsiTypeElement typeElement;
                PsiModifierList modifierList;
                variable = (PsiVariable)element;
                if (modifiers == null && (modifierList = variable.getModifierList()) != null) {
                    modifiers = LombokPsiConverter.toModifiers(modifierList);
                }
                if ((typeElement = variable.getTypeElement()) != null) {
                    definition.astTypeReference(LombokPsiConverter.toTypeReference(typeElement));
                }
            } else {
                throw new UnsupportedOperationException("Not yet supporting variable declarations for " + element);
            }
            VariableDefinitionEntry entry = LombokPsiConverter.toVariableDefinitionEntry(variable);
            definition.astVariables().addToEnd((Node[])new VariableDefinitionEntry[]{entry});
        }
        if (modifiers != null) {
            definition.astModifiers(modifiers);
        }
        return definition;
    }

    @NonNull
    private static VariableDeclaration toVariableDeclaration(@NonNull PsiVariable variable) {
        VariableDeclaration declaration = new VariableDeclaration();
        LombokPsiConverter.bind((Node)declaration, (PsiElement)variable);
        VariableDefinition definition = LombokPsiConverter.toVariableDefinition(variable);
        LombokPsiConverter.bind((Node)definition, (PsiElement)variable);
        declaration.astDefinition(definition);
        return declaration;
    }

    @NonNull
    private static ConstructorDeclaration toConstructorDeclaration(@NonNull PsiMethod method) {
        assert (method.isConstructor());
        ConstructorDeclaration m = new ConstructorDeclaration();
        LombokPsiConverter.bind((Node)m, (PsiElement)method);
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (nameIdentifier != null) {
            m.astTypeName(LombokPsiConverter.toIdentifier(nameIdentifier));
        }
        m.astModifiers(LombokPsiConverter.toModifiers(method.getModifierList()));
        for (PsiJavaCodeReferenceElement reference : method.getThrowsList().getReferenceElements()) {
            m.astThrownTypeReferences().addToEnd((Node[])new TypeReference[]{LombokPsiConverter.toTypeReference(reference)});
        }
        StrictListAccessor parameters = m.astParameters();
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            VariableDefinition definition = LombokPsiConverter.toVariableDefinition((PsiVariable)parameter);
            parameters.addToEnd((Node[])new VariableDefinition[]{definition});
        }
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            m.astBody(LombokPsiConverter.toBlock(body));
        }
        return m;
    }

    @NonNull
    private static MethodDeclaration toMethodDeclaration(@NonNull PsiMethod method) {
        assert (!method.isConstructor());
        MethodDeclaration m = new MethodDeclaration();
        LombokPsiConverter.bind((Node)m, (PsiElement)method);
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (nameIdentifier != null) {
            m.astMethodName(LombokPsiConverter.toIdentifier(nameIdentifier));
        }
        m.astModifiers(LombokPsiConverter.toModifiers(method.getModifierList()));
        PsiTypeElement returnTypeElement = method.getReturnTypeElement();
        if (returnTypeElement != null) {
            m.astReturnTypeReference(LombokPsiConverter.toTypeReference(returnTypeElement));
        }
        for (PsiJavaCodeReferenceElement reference : method.getThrowsList().getReferenceElements()) {
            m.astThrownTypeReferences().addToEnd((Node[])new TypeReference[]{LombokPsiConverter.toTypeReference(reference)});
        }
        StrictListAccessor parameters = m.astParameters();
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            VariableDefinition definition = LombokPsiConverter.toVariableDefinition((PsiVariable)parameter);
            parameters.addToEnd((Node[])new VariableDefinition[]{definition});
        }
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            m.astBody(LombokPsiConverter.toBlock(body));
        }
        return m;
    }
}

