/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.wizard.ExternalModuleSettingsStep;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathField;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleModuleBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.SelectExternalProjectDialog;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleModuleWizardStep
extends ModuleWizardStep {
    private static final Icon WIZARD_ICON = null;
    private static final String INHERIT_GROUP_ID_KEY = "GradleModuleWizard.inheritGroupId";
    private static final String INHERIT_VERSION_KEY = "GradleModuleWizard.inheritVersion";
    private static final String EMPTY_PARENT = "<none>";
    private static final String DEFAULT_VERSION = "1.0-SNAPSHOT";
    @Nullable
    private final Project myProjectOrNull;
    @NotNull
    private final GradleModuleBuilder myBuilder;
    @NotNull
    private final WizardContext myContext;
    @Nullable
    private ProjectData myParent;
    private String myInheritedGroupId;
    private String myInheritedVersion;
    private JPanel myMainPanel;
    private EditorTextField myParentPathField;
    private JButton mySelectParent;
    private JTextField myGroupIdField;
    private JCheckBox myInheritGroupIdCheckBox;
    private JTextField myArtifactIdField;
    private JTextField myVersionField;
    private JCheckBox myInheritVersionCheckBox;
    private JPanel myAddToPanel;

    public GradleModuleWizardStep(@NotNull GradleModuleBuilder builder, @NotNull WizardContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myProjectOrNull = context.getProject();
        this.myBuilder = builder;
        this.myContext = context;
        this.initComponents();
        this.loadSettings();
    }

    private void initComponents() {
        this.mySelectParent.setIcon(AllIcons.Actions.Module);
        this.mySelectParent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GradleModuleWizardStep.this.myParent = GradleModuleWizardStep.this.doSelectProject(GradleModuleWizardStep.this.myParent);
                GradleModuleWizardStep.this.updateComponents();
            }
        });
        ActionListener updatingListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GradleModuleWizardStep.this.updateComponents();
            }
        };
        this.myInheritGroupIdCheckBox.addActionListener(updatingListener);
        this.myInheritVersionCheckBox.addActionListener(updatingListener);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGroupIdField;
    }

    private ProjectData doSelectProject(ProjectData current) {
        assert (this.myProjectOrNull != null) : "must not be called when creating a new project";
        SelectExternalProjectDialog d = new SelectExternalProjectDialog(this.myProjectOrNull, current);
        if (!d.showAndGet()) {
            return current;
        }
        return d.getResult();
    }

    public void onStepLeaving() {
        this.saveSettings();
    }

    private void loadSettings() {
        this.myBuilder.setInheritGroupId(GradleModuleWizardStep.getSavedValue(INHERIT_GROUP_ID_KEY, true));
        this.myBuilder.setInheritVersion(GradleModuleWizardStep.getSavedValue(INHERIT_VERSION_KEY, true));
    }

    private void saveSettings() {
        GradleModuleWizardStep.saveValue(INHERIT_GROUP_ID_KEY, this.myInheritGroupIdCheckBox.isSelected());
        GradleModuleWizardStep.saveValue(INHERIT_VERSION_KEY, this.myInheritVersionCheckBox.isSelected());
    }

    private static boolean getSavedValue(String key, boolean defaultValue) {
        return GradleModuleWizardStep.getSavedValue(key, String.valueOf(defaultValue)).equals(String.valueOf(true));
    }

    private static String getSavedValue(String key, String defaultValue) {
        String value = PropertiesComponent.getInstance().getValue(key);
        return value == null ? defaultValue : value;
    }

    private static void saveValue(String key, boolean value) {
        GradleModuleWizardStep.saveValue(key, String.valueOf(value));
    }

    private static void saveValue(String key, String value) {
        PropertiesComponent props = PropertiesComponent.getInstance();
        props.setValue(key, value);
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public boolean validate() throws ConfigurationException {
        if (StringUtil.isEmptyOrSpaces((String)this.myArtifactIdField.getText())) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeFocusManager.getInstance((Project)GradleModuleWizardStep.this.myProjectOrNull).requestFocus((Component)GradleModuleWizardStep.this.myArtifactIdField, true);
                }
            });
            throw new ConfigurationException("Please, specify artifactId");
        }
        return true;
    }

    @Nullable
    public ProjectData findPotentialParentProject(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        ExternalProjectInfo projectInfo = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, this.myContext.getProjectFileDirectory());
        return projectInfo != null && projectInfo.getExternalProjectStructure() != null ? (ProjectData)projectInfo.getExternalProjectStructure().getData() : null;
    }

    public void updateStep() {
        this.myParent = this.findPotentialParentProject(this.myProjectOrNull);
        ProjectId projectId = this.myBuilder.getProjectId();
        if (projectId == null) {
            GradleModuleWizardStep.setTestIfEmpty(this.myArtifactIdField, this.myBuilder.getName());
            GradleModuleWizardStep.setTestIfEmpty(this.myGroupIdField, this.myParent == null ? this.myBuilder.getName() : this.myParent.getGroup());
            GradleModuleWizardStep.setTestIfEmpty(this.myVersionField, this.myParent == null ? DEFAULT_VERSION : this.myParent.getVersion());
        } else {
            GradleModuleWizardStep.setTestIfEmpty(this.myArtifactIdField, projectId.getArtifactId());
            GradleModuleWizardStep.setTestIfEmpty(this.myGroupIdField, projectId.getGroupId());
            GradleModuleWizardStep.setTestIfEmpty(this.myVersionField, projectId.getVersion());
        }
        this.myInheritGroupIdCheckBox.setSelected(this.myBuilder.isInheritGroupId());
        this.myInheritVersionCheckBox.setSelected(this.myBuilder.isInheritVersion());
        this.updateComponents();
    }

    private void updateComponents() {
        boolean isAddToVisible = !this.myContext.isCreatingNewProject() && this.myProjectOrNull != null && this.isGradleModuleExist();
        this.myAddToPanel.setVisible(isAddToVisible);
        this.myInheritGroupIdCheckBox.setVisible(isAddToVisible);
        this.myInheritVersionCheckBox.setVisible(isAddToVisible);
        this.myParentPathField.setText(this.myParent == null ? EMPTY_PARENT : this.myParent.getLinkedExternalProjectPath());
        GradleModuleWizardStep.collapseIfPossible(this.myParentPathField, GradleConstants.SYSTEM_ID, this.getProject());
        if (this.myParent == null) {
            this.myContext.putUserData(ExternalModuleSettingsStep.SKIP_STEP_KEY, (Object)Boolean.FALSE);
            this.myGroupIdField.setEnabled(true);
            this.myVersionField.setEnabled(true);
            this.myInheritGroupIdCheckBox.setEnabled(false);
            this.myInheritVersionCheckBox.setEnabled(false);
            GradleModuleWizardStep.setTestIfEmpty(this.myArtifactIdField, this.myBuilder.getName());
            GradleModuleWizardStep.setTestIfEmpty(this.myGroupIdField, "");
            GradleModuleWizardStep.setTestIfEmpty(this.myVersionField, DEFAULT_VERSION);
        } else {
            this.myContext.putUserData(ExternalModuleSettingsStep.SKIP_STEP_KEY, (Object)Boolean.TRUE);
            this.myGroupIdField.setEnabled(!this.myInheritGroupIdCheckBox.isSelected());
            this.myVersionField.setEnabled(!this.myInheritVersionCheckBox.isSelected());
            if (this.myInheritGroupIdCheckBox.isSelected() || this.myGroupIdField.getText().equals(this.myInheritedGroupId)) {
                this.myGroupIdField.setText(this.myParent.getGroup());
            }
            if (this.myInheritVersionCheckBox.isSelected() || this.myVersionField.getText().equals(this.myInheritedVersion)) {
                this.myVersionField.setText(this.myParent.getVersion());
            }
            this.myInheritedGroupId = this.myGroupIdField.getText();
            this.myInheritedVersion = this.myVersionField.getText();
            this.myInheritGroupIdCheckBox.setEnabled(true);
            this.myInheritVersionCheckBox.setEnabled(true);
        }
    }

    private boolean isGradleModuleExist() {
        for (Module module : this.myContext.getModulesProvider().getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) continue;
            return true;
        }
        return false;
    }

    public void updateDataModel() {
        this.myContext.setProjectBuilder((ProjectBuilder)this.myBuilder);
        this.myBuilder.setParentProject(this.myParent);
        this.myBuilder.setProjectId(new ProjectId(this.myGroupIdField.getText(), this.myArtifactIdField.getText(), this.myVersionField.getText()));
        this.myBuilder.setInheritGroupId(this.myInheritGroupIdCheckBox.isSelected());
        this.myBuilder.setInheritVersion(this.myInheritVersionCheckBox.isSelected());
        if (StringUtil.isNotEmpty((String)this.myBuilder.getProjectId().getArtifactId())) {
            this.myContext.setProjectName(this.myBuilder.getProjectId().getArtifactId());
        }
        if (this.myParent != null) {
            this.myContext.setProjectFileDirectory(this.myParent.getLinkedExternalProjectPath() + '/' + this.myContext.getProjectName());
        } else if (this.myProjectOrNull != null) {
            this.myContext.setProjectFileDirectory(this.myProjectOrNull.getBaseDir().getPath() + '/' + this.myContext.getProjectName());
        }
    }

    public Icon getIcon() {
        return WIZARD_ICON;
    }

    private void createUIComponents() {
        Project project = this.getProject();
        this.myParentPathField = new TextViewer("", project);
    }

    @NotNull
    private Project getProject() {
        Project project = this.myProjectOrNull != null ? this.myProjectOrNull : (Project)ArrayUtil.getFirstElement((Object[])ProjectManager.getInstance().getOpenProjects());
        Project project2 = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep", "getProject"));
        }
        return project2;
    }

    private static void collapseIfPossible(@NotNull EditorTextField editorTextField, @NotNull ProjectSystemId systemId, @NotNull Project project) {
        if (editorTextField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorTextField", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep", "collapseIfPossible"));
        }
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep", "collapseIfPossible"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep", "collapseIfPossible"));
        }
        Editor editor = editorTextField.getEditor();
        if (editor != null) {
            String rawText = editor.getDocument().getText();
            if (StringUtil.isEmpty((String)rawText)) {
                return;
            }
            if (EMPTY_PARENT.equals(rawText)) {
                editorTextField.setEnabled(false);
                return;
            }
            Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(project, systemId);
            for (ExternalProjectInfo projectInfo : projectsData) {
                if (projectInfo.getExternalProjectStructure() == null || !projectInfo.getExternalProjectPath().equals(rawText)) continue;
                editorTextField.setEnabled(true);
                ExternalProjectPathField.collapse((Editor)editorTextField.getEditor(), (String)((ProjectData)projectInfo.getExternalProjectStructure().getData()).getExternalName());
                return;
            }
        }
    }

    private static void setTestIfEmpty(@NotNull JTextField field, @Nullable String text) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep", "setTestIfEmpty"));
        }
        if (StringUtil.isEmpty((String)field.getText())) {
            field.setText(StringUtil.notNullize((String)text));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("GroupId");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("ArtifactId");
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Version");
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGroupIdField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myArtifactIdField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myVersionField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myInheritGroupIdCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Inherit");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInheritVersionCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Inherit");
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAddToPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Add as module to");
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySelectParent = jButton = new JButton();
        jButton.setText("");
        jButton.setHorizontalAlignment(2);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myParentPathField;
        editorTextField.setText("");
        editorTextField.setEnabled(true);
        jPanel.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setEnabled(true);
        jPanel2.add((Component)jPanel3, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class TextViewer
    extends EditorTextField {
        private final boolean myEmbeddedIntoDialogWrapper;
        private final boolean myUseSoftWraps;

        public TextViewer(@NotNull String initialText, @NotNull Project project) {
            if (initialText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialText", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep$TextViewer", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep$TextViewer", "<init>"));
            }
            this(TextViewer.createDocument(initialText), project, true, true);
        }

        public TextViewer(@NotNull Document document, @NotNull Project project, boolean embeddedIntoDialogWrapper, boolean useSoftWraps) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep$TextViewer", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep$TextViewer", "<init>"));
            }
            super(document, project, (FileType)FileTypes.PLAIN_TEXT, true, false);
            this.myEmbeddedIntoDialogWrapper = embeddedIntoDialogWrapper;
            this.myUseSoftWraps = useSoftWraps;
            this.setFontInheritedFromLAF(false);
        }

        private static Document createDocument(@NotNull String initialText) {
            if (initialText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialText", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleWizardStep$TextViewer", "createDocument"));
            }
            return EditorFactory.getInstance().createDocument((CharSequence)initialText);
        }

        public void setText(@Nullable String text) {
            super.setText(text != null ? StringUtil.convertLineSeparators((String)text) : null);
        }

        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            editor.setHorizontalScrollbarVisible(true);
            editor.setCaretEnabled(this.isEnabled());
            editor.getScrollPane().setVerticalScrollBarPolicy(20);
            editor.setEmbeddedIntoDialogWrapper(this.myEmbeddedIntoDialogWrapper);
            editor.setBorder(UIUtil.getTextFieldBorder());
            editor.setOneLineMode(true);
            editor.getComponent().setPreferredSize(null);
            editor.getSettings().setUseSoftWraps(this.myUseSoftWraps);
            return editor;
        }

        protected void setViewerEnabled(boolean enabled) {
        }
    }
}

