/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.FilterUtil;
import org.jetbrains.annotations.NotNull;

public class KeywordLookupItem
extends LookupItem<PsiKeyword>
implements TypedLookupItem {
    private final PsiElement myPosition;

    public KeywordLookupItem(PsiKeyword keyword, @NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/lookup/KeywordLookupItem", "<init>"));
        }
        super(keyword, keyword.getText());
        this.myPosition = position;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof KeywordLookupItem && this.getLookupString().equals(((KeywordLookupItem)o).getLookupString());
    }

    @Override
    public int hashCode() {
        return this.getLookupString().hashCode();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        presentation.setItemText(this.getLookupString());
        presentation.setItemTextBold(true);
    }

    @Override
    public PsiType getType() {
        return FilterUtil.getKeywordItemType(this.myPosition, this.getLookupString());
    }
}

