/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveInitializerFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class RemoveAssignmentFix
extends RemoveInitializerFix {
    @Override
    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.unused.assignment.remove.assignment.quickfix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RemoveAssignmentFix", "getName"));
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/RemoveAssignmentFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/RemoveAssignmentFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element instanceof PsiReferenceExpression ? element.getParent() : element;
        if (!(parent instanceof PsiAssignmentExpression)) {
            return;
        }
        PsiExpression rExpression = ((PsiAssignmentExpression)parent).getRExpression();
        PsiElement gParent = parent.getParent();
        if ((gParent instanceof PsiExpression || gParent instanceof PsiExpressionList || gParent instanceof PsiReturnStatement) && rExpression != null) {
            if (!FileModificationService.getInstance().prepareFileForWrite(gParent.getContainingFile())) {
                return;
            }
            if (gParent instanceof PsiParenthesizedExpression) {
                gParent.replace((PsiElement)rExpression);
            } else {
                parent.replace((PsiElement)rExpression);
            }
            return;
        }
        PsiElement resolve = null;
        if (element instanceof PsiReferenceExpression) {
            resolve = ((PsiReferenceExpression)element).resolve();
        } else {
            PsiExpression lExpr = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiAssignmentExpression)parent).getLExpression());
            if (lExpr instanceof PsiReferenceExpression) {
                resolve = ((PsiReferenceExpression)lExpr).resolve();
            }
        }
        if (!(resolve instanceof PsiVariable)) {
            return;
        }
        RemoveAssignmentFix.sideEffectAwareRemove(project, rExpression, parent, (PsiVariable)resolve);
    }
}

