/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GlobalJavaInspectionContextImpl
extends GlobalJavaInspectionContext {
    private static final Logger LOG = Logger.getInstance((String)("#" + GlobalJavaInspectionContextImpl.class.getName()));
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.DerivedMethodsProcessor>> myDerivedMethodsRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.DerivedClassesProcessor>> myDerivedClassesRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.UsagesProcessor>> myMethodUsagesRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.UsagesProcessor>> myFieldUsagesRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.UsagesProcessor>> myClassUsagesRequests;

    public void enqueueClassUsagesProcessor(RefClass refClass, GlobalJavaInspectionContext.UsagesProcessor p) {
        if (this.myClassUsagesRequests == null) {
            this.myClassUsagesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refClass, this.myClassUsagesRequests, p);
    }

    public void enqueueDerivedClassesProcessor(RefClass refClass, GlobalJavaInspectionContext.DerivedClassesProcessor p) {
        if (this.myDerivedClassesRequests == null) {
            this.myDerivedClassesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refClass, this.myDerivedClassesRequests, p);
    }

    public void enqueueDerivedMethodsProcessor(RefMethod refMethod, GlobalJavaInspectionContext.DerivedMethodsProcessor p) {
        if (refMethod.isConstructor() || refMethod.isStatic()) {
            return;
        }
        if (this.myDerivedMethodsRequests == null) {
            this.myDerivedMethodsRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refMethod, this.myDerivedMethodsRequests, p);
    }

    public void enqueueFieldUsagesProcessor(RefField refField, GlobalJavaInspectionContext.UsagesProcessor p) {
        if (this.myFieldUsagesRequests == null) {
            this.myFieldUsagesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refField, this.myFieldUsagesRequests, p);
    }

    public void enqueueMethodUsagesProcessor(RefMethod refMethod, GlobalJavaInspectionContext.UsagesProcessor p) {
        if (this.myMethodUsagesRequests == null) {
            this.myMethodUsagesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refMethod, this.myMethodUsagesRequests, p);
    }

    public EntryPointsManager getEntryPointsManager(RefManager manager) {
        return ((RefJavaManager)manager.getExtension(RefJavaManager.MANAGER)).getEntryPointsManager();
    }

    public static boolean isInspectionsEnabled(boolean online, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl", "isInspectionsEnabled"));
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (online) {
            if (modules.length == 0) {
                Messages.showMessageDialog((Project)project, (String)InspectionsBundle.message((String)"inspection.no.modules.error.message", (Object[])new Object[0]), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return false;
            }
            while (GlobalJavaInspectionContextImpl.isBadSdk(project, modules)) {
                Messages.showMessageDialog((Project)project, (String)InspectionsBundle.message((String)"inspection.no.jdk.error.message", (Object[])new Object[0]), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                Sdk projectJdk = ProjectSettingsService.getInstance(project).chooseAndSetSdk();
                if (projectJdk != null) continue;
                return false;
            }
        } else {
            if (modules.length == 0) {
                System.err.println(InspectionsBundle.message((String)"inspection.no.modules.error.message", (Object[])new Object[0]));
                return false;
            }
            if (GlobalJavaInspectionContextImpl.isBadSdk(project, modules)) {
                System.err.println(InspectionsBundle.message((String)"inspection.no.jdk.error.message", (Object[])new Object[0]));
                System.err.println(InspectionsBundle.message((String)"offline.inspections.jdk.not.found", (Object[])new Object[]{ProjectRootManager.getInstance((Project)project).getProjectSdkName()}));
                return false;
            }
            for (Module module : modules) {
                OrderEntry[] entries;
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                for (OrderEntry entry : entries = rootManager.getOrderEntries()) {
                    LibraryOrderEntry libraryOrderEntry;
                    Library library;
                    if (entry instanceof JdkOrderEntry) {
                        if (ModuleType.get((Module)module).isValidSdk(module, null)) continue;
                        System.err.println(InspectionsBundle.message((String)"offline.inspections.module.jdk.not.found", (Object[])new Object[]{((JdkOrderEntry)entry).getJdkName(), module.getName()}));
                        return false;
                    }
                    if (!(entry instanceof LibraryOrderEntry) || (library = (libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary()) != null && library.getFiles(OrderRootType.CLASSES).length >= library.getUrls(OrderRootType.CLASSES).length) continue;
                    System.err.println(InspectionsBundle.message((String)"offline.inspections.library.was.not.resolved", (Object[])new Object[]{libraryOrderEntry.getPresentableName(), module.getName()}));
                }
            }
        }
        return true;
    }

    private static boolean isBadSdk(Project project, Module[] modules) {
        boolean anyModuleAcceptsSdk = false;
        boolean anyModuleUsesProjectSdk = false;
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        for (Module module : modules) {
            if (!ModuleRootManager.getInstance((Module)module).isSdkInherited()) continue;
            anyModuleUsesProjectSdk = true;
            if (!ModuleType.get((Module)module).isValidSdk(module, projectSdk)) continue;
            anyModuleAcceptsSdk = true;
        }
        return anyModuleUsesProjectSdk && !anyModuleAcceptsSdk;
    }

    private static <T extends Processor> void enqueueRequestImpl(RefElement refElement, Map<SmartPsiElementPointer, List<T>> requestMap, T processor) {
        List<T> requests = requestMap.get(refElement.getPointer());
        if (requests == null) {
            requests = new ArrayList<T>();
            requestMap.put(refElement.getPointer(), requests);
        }
        requests.add(processor);
    }

    public void cleanup() {
        this.myDerivedMethodsRequests = null;
        this.myDerivedClassesRequests = null;
        this.myMethodUsagesRequests = null;
        this.myFieldUsagesRequests = null;
        this.myClassUsagesRequests = null;
    }

    private void processSearchRequests(GlobalInspectionContext context) {
        PsiMethod psiMethod;
        List<GlobalJavaInspectionContext.UsagesProcessor> processors;
        PsiClass psiClass;
        List<SmartPsiElementPointer> sortedIDs;
        RefManager refManager = context.getRefManager();
        final AnalysisScope scope = refManager.getScope();
        GlobalSearchScope searchScope = new GlobalSearchScope(refManager.getProject()){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl$1", "contains"));
                }
                return scope != null && !scope.contains(file) || file.getFileType() != StdFileTypes.JAVA;
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl$1", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl$1", "compare"));
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl$1", "isSearchInModuleContent"));
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }
        };
        if (this.myDerivedClassesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myDerivedClassesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                psiClass = (PsiClass)GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID);
                if (psiClass == null) continue;
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return psiClass.getQualifiedName();
                    }
                }));
                processors = this.myDerivedClassesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)psiClass.getClass().getName());
                ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)searchScope, (boolean)false).forEach(GlobalJavaInspectionContextImpl.createMembersProcessor(processors, scope));
            }
            this.myDerivedClassesRequests = null;
        }
        if (this.myDerivedMethodsRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myDerivedMethodsRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                psiMethod = (PsiMethod)GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID);
                if (psiMethod == null) continue;
                RefMethod refMethod = (RefMethod)refManager.getReference((PsiElement)psiMethod);
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, refManager.getQualifiedName((RefEntity)refMethod));
                List<GlobalJavaInspectionContext.DerivedMethodsProcessor> processors2 = this.myDerivedMethodsRequests.get(sortedID);
                LOG.assertTrue(processors2 != null, (Object)psiMethod.getClass().getName());
                OverridingMethodsSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope, (boolean)true).forEach(GlobalJavaInspectionContextImpl.createMembersProcessor(processors2, scope));
            }
            this.myDerivedMethodsRequests = null;
        }
        if (this.myFieldUsagesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myFieldUsagesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                PsiField psiField = (PsiField)GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID);
                if (psiField == null) continue;
                processors = this.myFieldUsagesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)psiField.getClass().getName());
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, refManager.getQualifiedName((RefEntity)refManager.getReference((PsiElement)psiField)));
                ReferencesSearch.search((PsiElement)psiField, (SearchScope)searchScope, (boolean)false).forEach((Processor)new PsiReferenceProcessorAdapter(GlobalJavaInspectionContextImpl.createReferenceProcessor(processors, context)));
            }
            this.myFieldUsagesRequests = null;
        }
        if (this.myClassUsagesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myClassUsagesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                psiClass = (PsiClass)GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID);
                if (psiClass == null) continue;
                processors = this.myClassUsagesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)psiClass.getClass().getName());
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return psiClass.getQualifiedName();
                    }
                }));
                ReferencesSearch.search((PsiElement)psiClass, (SearchScope)searchScope, (boolean)false).forEach((Processor)new PsiReferenceProcessorAdapter(GlobalJavaInspectionContextImpl.createReferenceProcessor(processors, context)));
            }
            this.myClassUsagesRequests = null;
        }
        if (this.myMethodUsagesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myMethodUsagesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                psiMethod = (PsiMethod)GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID);
                if (psiMethod == null) continue;
                processors = this.myMethodUsagesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)psiMethod.getClass().getName());
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, refManager.getQualifiedName((RefEntity)refManager.getReference((PsiElement)psiMethod)));
                MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope, (boolean)true).forEach((Processor)new PsiReferenceProcessorAdapter(GlobalJavaInspectionContextImpl.createReferenceProcessor(processors, context)));
            }
            this.myMethodUsagesRequests = null;
        }
    }

    private static PsiElement dereferenceInReadAction(final SmartPsiElementPointer sortedID) {
        return (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

            public PsiElement compute() {
                return sortedID.getElement();
            }
        });
    }

    private static <Member extends PsiMember, P extends Processor<Member>> PsiElementProcessorAdapter<Member> createMembersProcessor(final List<P> processors, final AnalysisScope scope) {
        return new PsiElementProcessorAdapter(new PsiElementProcessor<Member>(){

            public boolean execute(@NotNull Member member) {
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl$5", "execute"));
                }
                if (scope.contains(member)) {
                    return true;
                }
                ArrayList processorsArrayed = new ArrayList(processors);
                for (Processor processor : processorsArrayed) {
                    if (processor.process(member)) continue;
                    processors.remove(processor);
                }
                return !processors.isEmpty();
            }
        });
    }

    private int getRequestCount() {
        int sum = 0;
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myClassUsagesRequests);
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myDerivedClassesRequests);
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myDerivedMethodsRequests);
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myFieldUsagesRequests);
        return sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myMethodUsagesRequests);
    }

    private static int getRequestListSize(Map<?, ?> list) {
        return list == null ? 0 : list.size();
    }

    private static List<SmartPsiElementPointer> getSortedIDs(final Map<SmartPsiElementPointer, ?> requests) {
        final ArrayList<SmartPsiElementPointer> result = new ArrayList<SmartPsiElementPointer>();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (SmartPsiElementPointer id : requests.keySet()) {
                    PsiElement psi;
                    if (id == null || (psi = id.getElement()) == null) continue;
                    result.add(id);
                }
                Collections.sort(result, new Comparator<SmartPsiElementPointer>(){

                    @Override
                    public int compare(SmartPsiElementPointer o1, SmartPsiElementPointer o2) {
                        PsiElement p1 = o1.getElement();
                        PsiElement p2 = o2.getElement();
                        PsiFile psiFile1 = p1 != null ? p1.getContainingFile() : null;
                        LOG.assertTrue(psiFile1 != null);
                        PsiFile psiFile2 = p2 != null ? p2.getContainingFile() : null;
                        LOG.assertTrue(psiFile2 != null);
                        return psiFile1.getName().compareTo(psiFile2.getName());
                    }
                });
            }
        });
        return result;
    }

    private static PsiReferenceProcessor createReferenceProcessor(final @NotNull List<GlobalJavaInspectionContext.UsagesProcessor> processors, final GlobalInspectionContext context) {
        if (processors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processors", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl", "createReferenceProcessor"));
        }
        return new PsiReferenceProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(PsiReference reference) {
                AnalysisScope scope = context.getRefManager().getScope();
                if (scope != null && scope.contains(reference.getElement()) && reference.getElement().getLanguage() == StdLanguages.JAVA || PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiDocComment.class) != null) {
                    return true;
                }
                List list = processors;
                synchronized (list) {
                    GlobalJavaInspectionContext.UsagesProcessor[] processorsArrayed;
                    for (GlobalJavaInspectionContext.UsagesProcessor processor : processorsArrayed = processors.toArray(new GlobalJavaInspectionContext.UsagesProcessor[processors.size()])) {
                        if (processor.process((Object)reference)) continue;
                        processors.remove(processor);
                    }
                }
                return !processors.isEmpty();
            }
        };
    }

    public void performPreRunActivities(@NotNull List<Tools> globalTools, @NotNull List<Tools> localTools, @NotNull GlobalInspectionContext context) {
        if (globalTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalTools", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl", "performPreRunActivities"));
        }
        if (localTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localTools", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl", "performPreRunActivities"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl", "performPreRunActivities"));
        }
        this.getEntryPointsManager(context.getRefManager()).resolveEntryPoints(context.getRefManager());
        for (int i = 0; i < globalTools.size(); ++i) {
            InspectionToolWrapper toolWrapper = globalTools.get(i).getTool();
            if (!"unused".equals(toolWrapper.getShortName())) continue;
            Collections.swap(globalTools, i, 0);
            break;
        }
    }

    public void performPostRunActivities(@NotNull List<InspectionToolWrapper> needRepeatSearchRequest, @NotNull GlobalInspectionContext context) {
        if (needRepeatSearchRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "needRepeatSearchRequest", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl", "performPostRunActivities"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl", "performPostRunActivities"));
        }
        JobDescriptor progress = context.getStdJobDescriptors().FIND_EXTERNAL_USAGES;
        progress.setTotalAmount(this.getRequestCount());
        do {
            this.processSearchRequests(context);
            InspectionToolWrapper[] requestors = needRepeatSearchRequest.toArray(new InspectionToolWrapper[needRepeatSearchRequest.size()]);
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)context.getProject());
            for (InspectionToolWrapper toolWrapper : requestors) {
                boolean result = false;
                if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                    InspectionToolPresentation presentation = ((GlobalInspectionContextImpl)context).getPresentation(toolWrapper);
                    result = ((GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool()).queryExternalUsagesRequests(inspectionManager, context, (ProblemDescriptionsProcessor)presentation);
                }
                if (result) continue;
                needRepeatSearchRequest.remove(toolWrapper);
            }
            int oldSearchRequestCount = progress.getTotalAmount();
            int oldDoneAmount = progress.getDoneAmount();
            int totalAmount = oldSearchRequestCount + this.getRequestCount();
            progress.setTotalAmount(totalAmount);
            progress.setDoneAmount(oldDoneAmount);
        } while (!needRepeatSearchRequest.isEmpty());
    }
}

