/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;

public class CompileProjectAction
extends CompileActionBase {
    @Override
    protected void doAction(DataContext dataContext, final Project project) {
        CompilerManager.getInstance((Project)project).rebuild(new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (aborted || project.isDisposed()) {
                    return;
                }
                String text = CompileProjectAction.this.getTemplatePresentation().getText();
                LocalHistory.getInstance().putSystemLabel(project, errors == 0 ? CompilerBundle.message((String)"rebuild.lvcs.label.no.errors", (Object[])new Object[]{text}) : CompilerBundle.message((String)"rebuild.lvcs.label.with.errors", (Object[])new Object[]{text}));
            }
        });
    }

    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        Presentation presentation = event.getPresentation();
        if (!presentation.isEnabled()) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(event.getDataContext());
        presentation.setEnabled(project != null);
    }
}

