/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import org.jetbrains.annotations.NotNull;

public class ShowLibraryFramesAction
extends ToggleAction {
    private volatile boolean myShouldShow;
    private static final String ourTextWhenShowIsOn = "Hide Frames from Libraries";
    private static final String ourTextWhenShowIsOff = "Show All Frames";

    public ShowLibraryFramesAction() {
        super("", "", AllIcons.Debugger.Class_filter);
        this.myShouldShow = DebuggerSettings.getInstance().SHOW_LIBRARY_STACKFRAMES;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/actions/ShowLibraryFramesAction", "update"));
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        boolean shouldShow = !Boolean.TRUE.equals(presentation.getClientProperty("selected"));
        presentation.setText(shouldShow ? ourTextWhenShowIsOn : ourTextWhenShowIsOff);
    }

    public boolean isSelected(AnActionEvent e) {
        return !this.myShouldShow;
    }

    public void setSelected(AnActionEvent e, boolean enabled) {
        DebuggerSettings.getInstance().SHOW_LIBRARY_STACKFRAMES = this.myShouldShow = !enabled;
        XDebuggerUtilImpl.rebuildAllSessionsViews(e.getProject());
    }
}

