/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.intellij.xdebugger.ui.DebuggerColors;
import com.sun.jdi.Method;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.border.MatteBorder;

class FramesListRenderer
extends ColoredListCellRenderer {
    private final EditorColorsScheme myColorScheme = EditorColorsManager.getInstance().getGlobalScheme();

    protected void customizeCellRenderer(JList list, Object item, int index, boolean selected, boolean hasFocus) {
        if (!(item instanceof StackFrameDescriptorImpl)) {
            this.append(item.toString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else {
            StackFrameDescriptorImpl descriptor = (StackFrameDescriptorImpl)item;
            this.setIcon(descriptor.getIcon());
            Object selectedValue = list.getSelectedValue();
            boolean shouldHighlightAsRecursive = selectedValue instanceof StackFrameDescriptorImpl && FramesListRenderer.isOccurrenceOfSelectedFrame((StackFrameDescriptorImpl)selectedValue, descriptor);
            ValueMarkup markup = descriptor.getValueMarkup();
            if (markup != null) {
                this.append("[" + markup.getText() + "] ", new SimpleTextAttributes(1, markup.getColor()));
            }
            boolean needSeparator = false;
            if (index > 0) {
                int currentFrameIndex = descriptor.getUiIndex();
                Object elementAt = list.getModel().getElementAt(index - 1);
                if (elementAt instanceof StackFrameDescriptorImpl) {
                    StackFrameDescriptorImpl previousDescriptor = (StackFrameDescriptorImpl)elementAt;
                    int previousFrameIndex = previousDescriptor.getUiIndex();
                    boolean bl = needSeparator = currentFrameIndex - previousFrameIndex != 1;
                }
            }
            if (selected) {
                this.setBackground(UIUtil.getListSelectionBackground());
            } else {
                Color bg = descriptor.getBackgroundColor();
                if (bg == null) {
                    bg = UIUtil.getListBackground();
                }
                if (shouldHighlightAsRecursive) {
                    bg = this.myColorScheme.getColor(DebuggerColors.RECURSIVE_CALL_ATTRIBUTES);
                }
                this.setBackground(bg);
            }
            if (needSeparator) {
                MatteBorder border = BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)JBColor.GRAY);
                this.setBorder(border);
            } else {
                this.setBorder(null);
            }
            String label = descriptor.getLabel();
            int openingBrace = label.indexOf("{");
            int closingBrace = openingBrace < 0 ? -1 : label.indexOf("}");
            SimpleTextAttributes attributes = FramesListRenderer.getAttributes(descriptor);
            if (openingBrace < 0 || closingBrace < 0) {
                this.append(label, attributes);
            } else {
                this.append(label.substring(0, openingBrace - 1), attributes);
                this.append(" (" + label.substring(openingBrace + 1, closingBrace) + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                this.append(label.substring(closingBrace + 1, label.length()), attributes);
                if (shouldHighlightAsRecursive && descriptor.isRecursiveCall()) {
                    this.append(" [" + descriptor.getOccurrenceIndex() + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }
        }
    }

    private static boolean isOccurrenceOfSelectedFrame(StackFrameDescriptorImpl selectedDescriptor, StackFrameDescriptorImpl descriptor) {
        Method selectedMethod;
        Method currentMethod = descriptor.getMethod();
        return currentMethod != null && selectedDescriptor != null && (selectedMethod = selectedDescriptor.getMethod()) != null && Comparing.equal((Object)selectedMethod, (Object)currentMethod);
    }

    private static SimpleTextAttributes getAttributes(StackFrameDescriptorImpl descriptor) {
        if (descriptor.isSynthetic() || descriptor.isInLibraryContent()) {
            return SimpleTextAttributes.GRAYED_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }
}

