/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryCreator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRepositoryManager
extends AbstractProjectComponent
implements Disposable,
VcsListener {
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ReentrantReadWriteLock REPO_LOCK;
    @NotNull
    private final ReentrantReadWriteLock.WriteLock MODIFY_LOCK;
    @NotNull
    private final Map<VirtualFile, Repository> myRepositories;
    @NotNull
    private final Map<VirtualFile, Repository> myExternalRepositories;
    @NotNull
    private final List<VcsRepositoryCreator> myRepositoryCreators;
    private volatile boolean myDisposed;

    public VcsRepositoryManager(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/repo/VcsRepositoryManager", "<init>"));
        }
        if (vcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsManager", "com/intellij/dvcs/repo/VcsRepositoryManager", "<init>"));
        }
        super(project);
        this.REPO_LOCK = new ReentrantReadWriteLock();
        this.MODIFY_LOCK = new ReentrantReadWriteLock().writeLock();
        this.myRepositories = ContainerUtil.newHashMap();
        this.myExternalRepositories = ContainerUtil.newHashMap();
        this.myVcsManager = vcsManager;
        this.myRepositoryCreators = Arrays.asList(Extensions.getExtensions(VcsRepositoryCreator.EXTENSION_POINT_NAME, (AreaInstance)project));
    }

    public void initComponent() {
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myDisposed = true;
        try {
            this.REPO_LOCK.writeLock().lock();
            this.myRepositories.clear();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public void directoryMappingChanged() {
        this.checkAndUpdateRepositoriesCollection(null);
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/repo/VcsRepositoryManager", "getRepositoryForFile"));
        }
        VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(file);
        return vcsRoot != null ? this.getRepositoryForRoot(vcsRoot.getPath()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Repository getRepositoryForRoot(@Nullable VirtualFile root) {
        Repository result;
        if (root == null) {
            return null;
        }
        try {
            this.REPO_LOCK.readLock().lock();
            if (this.myDisposed) {
                throw new ProcessCanceledException();
            }
            Repository repo = this.myRepositories.get(root);
            result = repo != null ? repo : this.myExternalRepositories.get(root);
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
        if (result == null && ArrayUtil.contains((Object)root, (Object[])this.myVcsManager.getAllVersionedRoots())) {
            this.checkAndUpdateRepositoriesCollection(root);
            try {
                this.REPO_LOCK.readLock().lock();
                Repository repository = this.myRepositories.get(root);
                return repository;
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternalRepository(@NotNull VirtualFile root, @NotNull Repository repository) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dvcs/repo/VcsRepositoryManager", "addExternalRepository"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/repo/VcsRepositoryManager", "addExternalRepository"));
        }
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.put(root, repository);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExternalRepository(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dvcs/repo/VcsRepositoryManager", "removeExternalRepository"));
        }
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.remove(root);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExternal(@NotNull Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/repo/VcsRepositoryManager", "isExternal"));
        }
        try {
            this.REPO_LOCK.readLock().lock();
            boolean bl = !this.myRepositories.containsValue(repository) && this.myExternalRepositories.containsValue(repository);
            return bl;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<Repository> getRepositories() {
        this.REPO_LOCK.readLock().lock();
        Collection<Repository> collection = Collections.unmodifiableCollection(this.myRepositories.values());
        Collection<Repository> collection2 = collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/VcsRepositoryManager", "getRepositories"));
        }
        return collection2;
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateRepositoriesCollection(@Nullable VirtualFile checkedRoot) {
        try {
            HashMap repositories;
            this.MODIFY_LOCK.lock();
            try {
                this.REPO_LOCK.readLock().lock();
                if (this.myRepositories.containsKey(checkedRoot)) {
                    return;
                }
                repositories = ContainerUtil.newHashMap(this.myRepositories);
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
            Collection<VirtualFile> invalidRoots = this.findInvalidRoots(repositories.keySet());
            repositories.keySet().removeAll(invalidRoots);
            Map<VirtualFile, Repository> newRoots = this.findNewRoots(repositories.keySet());
            repositories.putAll(newRoots);
            this.REPO_LOCK.writeLock().lock();
            try {
                if (!this.myDisposed) {
                    this.myRepositories.clear();
                    this.myRepositories.putAll(repositories);
                }
            }
            finally {
                this.REPO_LOCK.writeLock().unlock();
            }
        }
        finally {
            this.MODIFY_LOCK.unlock();
        }
    }

    @NotNull
    private Map<VirtualFile, Repository> findNewRoots(@NotNull Set<VirtualFile> knownRoots) {
        if (knownRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "knownRoots", "com/intellij/dvcs/repo/VcsRepositoryManager", "findNewRoots"));
        }
        HashMap newRootsMap = ContainerUtil.newHashMap();
        for (VcsRoot root : this.myVcsManager.getAllVcsRoots()) {
            Repository repository;
            AbstractVcs vcs;
            VcsRepositoryCreator repositoryCreator;
            VirtualFile rootPath = root.getPath();
            if (rootPath == null || knownRoots.contains(rootPath) || (repositoryCreator = this.getRepositoryCreator(vcs = root.getVcs())) == null || (repository = repositoryCreator.createRepositoryIfValid(rootPath)) == null) continue;
            newRootsMap.put(rootPath, repository);
        }
        HashMap hashMap = newRootsMap;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/VcsRepositoryManager", "findNewRoots"));
        }
        return hashMap;
    }

    @NotNull
    private Collection<VirtualFile> findInvalidRoots(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/dvcs/repo/VcsRepositoryManager", "findInvalidRoots"));
        }
        final VirtualFile[] validRoots = this.myVcsManager.getAllVersionedRoots();
        List list = ContainerUtil.filter(roots, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return !ArrayUtil.contains((Object)file, (Object[])validRoots);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/VcsRepositoryManager", "findInvalidRoots"));
        }
        return list;
    }

    @Nullable
    private VcsRepositoryCreator getRepositoryCreator(final @Nullable AbstractVcs vcs) {
        if (vcs == null) {
            return null;
        }
        return (VcsRepositoryCreator)ContainerUtil.find(this.myRepositoryCreators, (Condition)new Condition<VcsRepositoryCreator>(){

            public boolean value(VcsRepositoryCreator creator) {
                return creator.getVcsKey().equals((Object)vcs.getKeyInstanceMethod());
            }
        });
    }

    @NotNull
    public String toString() {
        String string = "RepositoryManager{myRepositories: " + this.myRepositories + '}';
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/VcsRepositoryManager", "toString"));
        }
        return string;
    }
}

