/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.BulkChangesMerger;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.editor.impl.TextChangesStorage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceBackedByArray;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CharArray
implements CharSequenceBackedByArray,
Dumpable {
    private static final boolean CHECK_DOCUMENT_CONSISTENCY = ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isUnitTestMode();
    private static final Logger LOG = Logger.getInstance((String)("#" + CharArray.class.getName()));
    private static final boolean DISABLE_DEFERRED_PROCESSING = Boolean.getBoolean("idea.document.deny.deferred.changes");
    private static final boolean DEBUG_DEFERRED_PROCESSING = LOG.isDebugEnabled() || Boolean.getBoolean("idea.document.debug.bulk.processing");
    private static final int MAX_DEFERRED_CHANGES_NUMBER = 10000;
    private final TextChangesStorage myDeferredChangesStorage;
    private volatile int myStart;
    private volatile int myCount;
    private volatile CharSequence myOriginalSequence;
    private volatile char[] myArray;
    private volatile Reference<String> myStringRef;
    private volatile int myBufferSize;
    private volatile int myDeferredShift;
    private volatile boolean myDeferredChangeMode;
    private volatile boolean myHasDeferredChanges;
    private final Object lock;
    private final boolean myDebug;
    private CharArray myDebugArray;
    private List<TextChangeImpl> myDebugDeferredChanges;
    private String myDebugTextOnBatchUpdateStart;

    boolean isDebug() {
        return DEBUG_DEFERRED_PROCESSING || CHECK_DOCUMENT_CONSISTENCY && !ApplicationInfoImpl.isInPerformanceTest();
    }

    CharArray(int bufferSize, @NotNull char[] data, int length) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/editor/impl/CharArray", "<init>"));
        }
        this.lock = new String("myOriginalSequence");
        this.myDebug = this.isDebug();
        this.myBufferSize = bufferSize;
        this.myDeferredChangesStorage = new TextChangesStorage();
        this.myArray = Arrays.copyOf(data, length);
        this.myCount = length;
        if (this.myDebug) {
            this.myDebugArray = new CharArray(bufferSize, data, length){

                @Override
                @NotNull
                protected DocumentEvent beforeChangedUpdate(int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
                    DocumentEvent documentEvent = CharArray.this.beforeChangedUpdate(offset, oldString, newString, wholeTextReplaced);
                    if (documentEvent == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CharArray$1", "beforeChangedUpdate"));
                    }
                    return documentEvent;
                }

                @Override
                protected void afterChangedUpdate(@NotNull DocumentEvent event, long newModificationStamp) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/CharArray$1", "afterChangedUpdate"));
                    }
                }

                @Override
                protected void assertWriteAccess() {
                }

                @Override
                protected void assertReadAccess() {
                }

                @Override
                boolean isDebug() {
                    return false;
                }
            };
            this.myDebugDeferredChanges = new ArrayList<TextChangeImpl>();
        }
        this.assertConsistency();
    }

    public void setBufferSize(int bufferSize) {
        assert (bufferSize >= 0) : bufferSize;
        this.myBufferSize = bufferSize;
        this.assertConsistency();
    }

    private DocumentEvent startChange(int offset, @Nullable CharSequence oldString, @Nullable CharSequence newString, boolean wholeTextReplaced) {
        assert (this.myStart == 0);
        this.assertWriteAccess();
        this.assertConsistency();
        return this.beforeChangedUpdate(offset, oldString, newString, wholeTextReplaced);
    }

    @NotNull
    protected abstract DocumentEvent beforeChangedUpdate(int var1, @Nullable CharSequence var2, @Nullable CharSequence var3, boolean var4);

    protected abstract void afterChangedUpdate(@NotNull DocumentEvent var1, long var2);

    protected abstract void assertWriteAccess();

    protected abstract void assertReadAccess();

    private void setText(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/CharArray", "setText"));
        }
        this.assertConsistency();
        this.myOriginalSequence = ((Object)chars).toString();
        this.myArray = null;
        this.myStringRef = null;
        this.myCount = chars.length();
        assert (this.myStart == 0);
        this.myDeferredChangesStorage.clear();
        this.myHasDeferredChanges = false;
        this.trimToSize();
        if (this.myDebug) {
            this.myDebugArray.setText(chars);
            this.myDebugDeferredChanges.clear();
        }
        this.assertConsistency();
    }

    private void assertConsistency() {
        CharArrayCharSequence seqFromCharArray;
        int stringLen;
        if (this.isDeferredChangeMode()) assert (this.myOriginalSequence == null);
        CharSequence originalSequence = this.myOriginalSequence;
        int origLen = originalSequence == null ? -1 : originalSequence.length();
        String string = (String)SoftReference.dereference(this.myStringRef);
        int n = stringLen = string == null ? -1 : string.length();
        assert (origLen == stringLen || origLen == -1 || stringLen == -1);
        int count = this.myCount + this.myDeferredShift;
        assert (count == origLen || origLen == -1);
        assert (count == stringLen || stringLen == -1);
        if (!this.myDebug) {
            return;
        }
        if (this.myArray != null) {
            assert (this.myCount <= this.myArray.length);
            seqFromCharArray = new CharArrayCharSequence(this.myArray, this.myStart, this.myCount);
        } else {
            seqFromCharArray = null;
        }
        if (seqFromCharArray != null && originalSequence != null) assert (StringUtil.equals(seqFromCharArray, (CharSequence)originalSequence));
        if (!this.isDeferredChangeMode() && seqFromCharArray != null && string != null) assert (StringUtil.equals((CharSequence)seqFromCharArray, (CharSequence)string));
        if (originalSequence != null && string != null) assert (string.equals(((Object)originalSequence).toString()));
        this.myDebugArray.assertConsistency();
        CharSequence str = (CharSequence)SoftReference.dereference(this.myStringRef);
        if (str == null) {
            str = this.myHasDeferredChanges ? ((Object)this.doSubString(0, this.myCount + this.myDeferredShift)).toString() : (this.myOriginalSequence != null ? ((Object)this.myOriginalSequence).toString() : seqFromCharArray);
        }
        assert (count == str.length());
        if (this.isDeferredChangeMode()) {
            String expected = this.myDebugArray.toString();
            this.checkStrings("toString()", expected, str);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void replace(int startOffset, int endOffset, @NotNull CharSequence toDelete, @NotNull CharSequence newString, long newModificationStamp, boolean bl) {
        void wholeTextReplaced;
        if (toDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDelete", "com/intellij/openapi/editor/impl/CharArray", "replace"));
        }
        if (newString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newString", "com/intellij/openapi/editor/impl/CharArray", "replace"));
        }
        DocumentEvent event = this.startChange(startOffset, toDelete, newString, (boolean)wholeTextReplaced);
        this.doReplace(startOffset += this.myStart, endOffset += this.myStart, newString);
        this.afterChangedUpdate(event, newModificationStamp);
        this.assertConsistency();
    }

    private void doReplace(int startOffset, int endOffset, @NotNull CharSequence newString) {
        if (newString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newString", "com/intellij/openapi/editor/impl/CharArray", "doReplace"));
        }
        this.prepareForModification();
        if (this.isDeferredChangeMode()) {
            this.storeChange(new TextChangeImpl(newString, startOffset, endOffset));
            if (this.myDebug) {
                this.myDebugArray.doReplace(startOffset, endOffset, newString);
            }
        } else {
            int newLength = newString.length();
            int oldLength = endOffset - startOffset;
            CharArrayUtil.getChars((CharSequence)newString, (char[])this.myArray, (int)startOffset, (int)Math.min(newLength, oldLength));
            this.myStringRef = null;
            if (newLength > oldLength) {
                this.doInsert(newString.subSequence(oldLength, newLength), endOffset);
            } else if (newLength < oldLength) {
                this.doRemove(startOffset + newLength, startOffset + oldLength);
            }
        }
    }

    public void remove(int startIndex, int endIndex, @NotNull CharSequence toDelete) {
        if (toDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDelete", "com/intellij/openapi/editor/impl/CharArray", "remove"));
        }
        DocumentEvent event = this.startChange(startIndex, toDelete, null, false);
        this.doRemove(startIndex += this.myStart, endIndex += this.myStart);
        this.afterChangedUpdate(event, LocalTimeCounter.currentTime());
        this.assertConsistency();
    }

    private void doRemove(int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return;
        }
        this.prepareForModification();
        if (this.isDeferredChangeMode()) {
            this.storeChange(new TextChangeImpl("", startIndex, endIndex));
            if (this.myDebug) {
                this.myDebugArray.doRemove(startIndex, endIndex);
            }
        } else {
            if (endIndex < this.myCount) {
                System.arraycopy(this.myArray, endIndex, this.myArray, startIndex, this.myCount - endIndex);
                this.myStringRef = null;
            }
            this.myCount -= endIndex - startIndex;
        }
    }

    public void insert(@NotNull CharSequence s, int startIndex) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/CharArray", "insert"));
        }
        DocumentEvent event = this.startChange(startIndex, null, s, false);
        this.doInsert(s, startIndex += this.myStart);
        this.afterChangedUpdate(event, LocalTimeCounter.currentTime());
        this.trimToSize();
        this.assertConsistency();
    }

    private void doInsert(@NotNull CharSequence s, int startIndex) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/CharArray", "doInsert"));
        }
        this.prepareForModification();
        if (this.isDeferredChangeMode()) {
            this.storeChange(new TextChangeImpl(s, startIndex));
            if (this.myDebug) {
                this.myDebugArray.doInsert(s, startIndex);
            }
        } else {
            int insertLength = s.length();
            this.myArray = CharArray.resizeArray(this.myArray, this.myCount + insertLength);
            if (startIndex < this.myCount) {
                System.arraycopy(this.myArray, startIndex, this.myArray, startIndex + insertLength, this.myCount - startIndex);
            }
            CharArrayUtil.getChars((CharSequence)s, (char[])this.myArray, (int)startIndex);
            this.myCount += insertLength;
            this.myStringRef = null;
        }
    }

    private void storeChange(@NotNull TextChangeImpl change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/editor/impl/CharArray", "storeChange"));
        }
        if (!change.isWithinBounds(this.length())) {
            LOG.error("Invalid change attempt detected - given change bounds are not within the current char array. Change: " + change.getText().length() + ":" + change.getStart() + "-" + change.getEnd(), new String[]{this.dumpState()});
            return;
        }
        if (this.myDeferredChangesStorage.size() >= 10000) {
            this.flushDeferredChanged();
        }
        this.myDeferredChangesStorage.store(change);
        this.myHasDeferredChanges = true;
        this.myDeferredShift += change.getDiff();
        if (this.myDebug) {
            this.myDebugDeferredChanges.add(change);
        }
    }

    private void prepareForModification() {
        if (this.myOriginalSequence != null) {
            this.myArray = new char[this.myOriginalSequence.length()];
            CharArrayUtil.getChars((CharSequence)this.myOriginalSequence, (char[])this.myArray, (int)0);
            this.myCount = this.myArray.length;
            this.myOriginalSequence = null;
            this.myStart = 0;
        }
        this.myStringRef = null;
        this.assertConsistency();
    }

    @NotNull
    public CharSequence getCharArray() {
        this.assertConsistency();
        CharSequence originalSequence = this.myOriginalSequence;
        Object object = originalSequence == null ? this : originalSequence;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CharArray", "getCharArray"));
        }
        return object;
    }

    @NotNull
    public String toString() {
        this.assertConsistency();
        String str = (String)SoftReference.dereference(this.myStringRef);
        if (str == null) {
            str = this.myHasDeferredChanges ? ((Object)this.substring(0, this.length())).toString() : (this.myOriginalSequence == null ? new String(this.myArray, this.myStart, this.myCount) : ((Object)this.myOriginalSequence).toString());
            this.myStringRef = new java.lang.ref.SoftReference<String>(str);
        }
        String string = str;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CharArray", "toString"));
        }
        return string;
    }

    public final int length() {
        int expected;
        int result = this.myCount + this.myDeferredShift;
        if (this.myDebug && this.isDeferredChangeMode() && (expected = this.myDebugArray.length()) != result) {
            this.dumpDebugInfo("Incorrect length() processing. Expected: '" + expected + "', actual: '" + result + "'");
        }
        return result;
    }

    public final char charAt(int i) {
        char expected;
        if (i < 0 || i >= this.length()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + i + "; count:" + this.length());
        }
        char result = !this.myHasDeferredChanges ? (this.myOriginalSequence != null ? this.myOriginalSequence.charAt(i) : this.myArray[i]) : this.myDeferredChangesStorage.charAt(this.myArray, i += this.myStart);
        if (this.myDebug && this.isDeferredChangeMode() && (expected = this.myDebugArray.charAt(i)) != result) {
            this.dumpDebugInfo("Incorrect charAt() processing for index " + i + ". Expected: '" + expected + "', actual: '" + result + "'");
        }
        return result;
    }

    @NotNull
    public CharSequence subSequence(int start, int end) {
        this.assertReadAccess();
        this.assertConsistency();
        if (start == 0 && end == this.length()) {
            CharArray charArray = this;
            if (charArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CharArray", "subSequence"));
            }
            return charArray;
        }
        if (this.myOriginalSequence != null) {
            CharSequence charSequence = this.myOriginalSequence.subSequence(start, end);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CharArray", "subSequence"));
            }
            return charSequence;
        }
        this.flushDeferredChanged();
        CharArrayCharSequence charArrayCharSequence = new CharArrayCharSequence(this.myArray, start, end);
        if (charArrayCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CharArray", "subSequence"));
        }
        return charArrayCharSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public char[] getChars() {
        this.assertReadAccess();
        this.assertConsistency();
        char[] array = this.myArray;
        CharSequence originalSequence = this.myOriginalSequence;
        if (this.myHasDeferredChanges || originalSequence != null && array == null) {
            Object object = this.lock;
            synchronized (object) {
                this.flushDeferredChanged();
                array = this.myArray;
                originalSequence = this.myOriginalSequence;
                if (originalSequence != null && array == null) {
                    this.myArray = array = CharArrayUtil.fromSequence((CharSequence)originalSequence);
                    this.myStringRef = null;
                }
            }
            this.assertConsistency();
        }
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CharArray", "getChars"));
        }
        return array;
    }

    public void getChars(@NotNull char[] dst, int dstOffset) {
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dst", "com/intellij/openapi/editor/impl/CharArray", "getChars"));
        }
        this.assertReadAccess();
        this.assertConsistency();
        this.flushDeferredChanged();
        if (this.myOriginalSequence == null) {
            System.arraycopy(this.myArray, this.myStart, dst, dstOffset, this.length());
        } else {
            CharArrayUtil.getChars((CharSequence)this.myOriginalSequence, (char[])dst, (int)dstOffset);
        }
        if (this.myDebug && this.isDeferredChangeMode()) {
            char[] expected = new char[dst.length];
            this.myDebugArray.getChars(expected, dstOffset);
            int i = dstOffset;
            for (int j = this.myStart; i < dst.length && j < this.myArray.length; ++i, ++j) {
                if (expected[i] == this.myArray[j]) continue;
                this.dumpDebugInfo("getChars(char[], int). Given array of length " + dst.length + ", offset " + dstOffset + ". Found char '" + this.myArray[j] + "' at index " + i + ", expected to find '" + expected[i] + "'");
                break;
            }
        }
    }

    @NotNull
    public CharSequence substring(int start, int end) {
        this.assertReadAccess();
        CharSequence result = this.doSubString(start, end);
        this.assertConsistency();
        CharSequence charSequence = result;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CharArray", "substring"));
        }
        return charSequence;
    }

    private CharSequence doSubString(int start, int end) {
        if (start == end) {
            return "";
        }
        CharSequence result = this.myOriginalSequence == null ? this.myDeferredChangesStorage.substring(this.myArray, start + this.myStart, end + this.myStart) : this.myOriginalSequence.subSequence(start, end);
        return result;
    }

    @NotNull
    private static char[] resizeArray(@NotNull char[] array, int newSize) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/openapi/editor/impl/CharArray", "resizeArray"));
        }
        if (newSize < array.length) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CharArray", "resizeArray"));
            }
            return array;
        }
        int newArraySize = array.length;
        if (newArraySize == 0) {
            newArraySize = 16;
        }
        while (newArraySize <= newSize) {
            newArraySize = newArraySize * 12 / 10 + 1;
        }
        char[] newArray = new char[newArraySize];
        System.arraycopy(array, 0, newArray, 0, array.length);
        if (newArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CharArray", "resizeArray"));
        }
        return newArray;
    }

    private void trimToSize() {
        if (this.myBufferSize != 0 && this.length() > this.myBufferSize) {
            this.flushDeferredChanged();
            int endIndex = this.myCount - this.myBufferSize;
            String toDelete = ((Object)this.getCharArray().subSequence(0, endIndex)).toString();
            this.remove(0, endIndex, toDelete);
        }
    }

    public boolean isDeferredChangeMode() {
        return this.myDeferredChangeMode;
    }

    public boolean hasDeferredChanges() {
        return this.myHasDeferredChanges;
    }

    public void setDeferredChangeMode(boolean deferredChangeMode) {
        if (!DISABLE_DEFERRED_PROCESSING) {
            if (deferredChangeMode) {
                if (this.myDebug) {
                    this.myDebugTextOnBatchUpdateStart = this.toString();
                    this.myDebugArray.setText(this.myDebugTextOnBatchUpdateStart);
                    this.myDebugDeferredChanges.clear();
                }
                this.prepareForModification();
            } else {
                this.flushDeferredChanged();
            }
            this.myDeferredChangeMode = deferredChangeMode;
        }
        this.assertConsistency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDeferredChanged() {
        List<TextChangeImpl> changes = this.myDeferredChangesStorage.getChanges();
        if (changes.isEmpty()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean inPlace;
            char[] beforeMerge = null;
            if (this.myDebug) {
                beforeMerge = new char[this.myArray.length];
                System.arraycopy(this.myArray, 0, beforeMerge, 0, this.myArray.length);
            }
            BulkChangesMerger changesMerger = BulkChangesMerger.INSTANCE;
            if (this.myArray.length < this.length()) {
                this.myArray = changesMerger.mergeToCharArray(this.myArray, this.myCount, changes);
                inPlace = false;
            } else {
                changesMerger.mergeInPlace(this.myArray, this.myCount, changes);
                inPlace = true;
            }
            this.myCount += this.myDeferredShift;
            this.myDeferredShift = 0;
            this.myDeferredChangesStorage.clear();
            this.myHasDeferredChanges = false;
            this.myDeferredChangeMode = false;
            this.myStringRef = null;
            if (this.myDebug) {
                int max = this.length();
                for (int i = 0; i < max; ++i) {
                    if (this.myArray[i] == this.myDebugArray.myArray[i]) continue;
                    this.dumpDebugInfo("flushDeferredChanged(). Index " + i + ", expected: '" + this.myDebugArray.myArray[i] + "', actual '" + this.myArray[i] + "'. Text before merge: '" + Arrays.toString(beforeMerge) + "', merge inplace: " + inPlace);
                    break;
                }
            }
        }
        this.assertConsistency();
    }

    @NonNls
    @NotNull
    public String dumpState() {
        String string = "deferred changes mode: " + this.isDeferredChangeMode() + ", length: " + this.length() + " (data array length: " + this.myCount + ", deferred shift: " + this.myDeferredShift + "); view offsets: [" + this.myStart + "; " + this.myCount + "]; deferred changes: " + this.myDeferredChangesStorage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CharArray", "dumpState"));
        }
        return string;
    }

    private void checkStrings(@NonNls @NotNull String operation, @NotNull String expected, @NotNull CharSequence actual) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/editor/impl/CharArray", "checkStrings"));
        }
        if (expected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expected", "com/intellij/openapi/editor/impl/CharArray", "checkStrings"));
        }
        if (actual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actual", "com/intellij/openapi/editor/impl/CharArray", "checkStrings"));
        }
        if (StringUtil.equals((CharSequence)expected, (CharSequence)actual)) {
            return;
        }
        int max = Math.min(expected.length(), actual.length());
        for (int i = 0; i < max; ++i) {
            if (actual.charAt(i) == expected.charAt(i)) continue;
            this.dumpDebugInfo("Incorrect " + operation + " processing. Expected length: " + expected.length() + ", actual length: " + actual.length() + ". Unmatched symbol at " + i + " - expected: '" + expected.charAt(i) + "', " + "actual: '" + actual.charAt(i) + "', expected document: '" + expected + "', actual document: '" + actual + "'");
            return;
        }
        this.dumpDebugInfo("Incorrect " + operation + " processing. Expected length: " + expected.length() + ", actual length: " + actual.length() + ", expected: '" + expected + "', actual: '" + actual + "'");
    }

    private void dumpDebugInfo(@NonNls @NotNull String problem) {
        if (problem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problem", "com/intellij/openapi/editor/impl/CharArray", "dumpDebugInfo"));
        }
        LOG.error("Incorrect CharArray processing detected: " + problem + ". Start: " + this.myStart + ", count: " + this.myCount + ", text on batch update start: " + this.myDebugTextOnBatchUpdateStart + ", deferred changes history: " + this.myDebugDeferredChanges + ", current deferred changes: " + this.myDeferredChangesStorage);
    }
}

