/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformFacadeImpl
implements PlatformFacade {
    @NotNull
    public LibraryTable getProjectLibraryTable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getProjectLibraryTable"));
        }
        LibraryTable libraryTable = ProjectLibraryTable.getInstance(project);
        if (libraryTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getProjectLibraryTable"));
        }
        return libraryTable;
    }

    @NotNull
    public Collection<Module> getModules(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getModules"));
        }
        List<Module> list = Arrays.asList(ModuleManager.getInstance((Project)project).getModules());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getModules"));
        }
        return list;
    }

    @NotNull
    public Collection<OrderEntry> getOrderEntries(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getOrderEntries"));
        }
        List<OrderEntry> list = Arrays.asList(ModuleRootManager.getInstance((Module)module).getOrderEntries());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getOrderEntries"));
        }
        return list;
    }

    @NotNull
    public String getLocalFileSystemPath(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getLocalFileSystemPath"));
        }
        String string = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getLocalFileSystemPath"));
        }
        return string;
    }

    public Module newModule(Project project, @NotNull @NonNls String filePath, String moduleTypeId) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "newModule"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.newModule(filePath, moduleTypeId);
    }

    public ModifiableRootModel getModuleModifiableModel(Module module) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        return moduleRootManager.getModifiableModel();
    }

    @Nullable
    public Module findIdeModule(@NotNull ModuleData module, @NotNull Project ideProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "findIdeModule"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "findIdeModule"));
        }
        return this.findIdeModule(module.getInternalName(), ideProject);
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName, @NotNull Project ideProject) {
        if (ideModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModuleName", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "findIdeModule"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "findIdeModule"));
        }
        for (Module module : this.getModules(ideProject)) {
            if (!ideModuleName.equals(module.getName())) continue;
            return module;
        }
        return null;
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData, @NotNull Project ideProject) {
        if (libraryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryData", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "findIdeLibrary"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "findIdeLibrary"));
        }
        LibraryTable libraryTable = this.getProjectLibraryTable(ideProject);
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    public boolean isOrphanProjectLibrary(final @NotNull Library library, @NotNull Iterable<Module> ideModules) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "isOrphanProjectLibrary"));
        }
        if (ideModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModules", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "isOrphanProjectLibrary"));
        }
        RootPolicy<Boolean> visitor = new RootPolicy<Boolean>(){

            public Boolean visitLibraryOrderEntry(LibraryOrderEntry ideDependency, Boolean value) {
                return !ideDependency.isModuleLevel() && library == ideDependency.getLibrary();
            }
        };
        for (Module module : ideModules) {
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!((Boolean)entry.accept((RootPolicy)visitor, (Object)false)).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData dependency, @NotNull ModifiableRootModel model) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "findIdeModuleDependency"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "findIdeModuleDependency"));
        }
        for (OrderEntry entry : model.getOrderEntries()) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry candidate = (ModuleOrderEntry)entry;
            if (!dependency.getInternalName().equals(candidate.getModuleName()) || !dependency.getScope().equals((Object)candidate.getScope())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public OrderEntry findIdeModuleOrderEntry(LibraryDependencyData data, Project project) {
        Module ownerIdeModule = this.findIdeModule(data.getOwnerModule(), project);
        if (ownerIdeModule == null) {
            return null;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)ownerIdeModule);
        for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
            if (entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).isModuleLevel() && data.getLevel() != LibraryLevel.MODULE || !data.getInternalName().equals(entry.getPresentableName())) continue;
            return entry;
        }
        return null;
    }
}

