/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Producer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAwareTextEditorProvider
extends TextEditorProvider
implements AsyncFileEditorProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider");
    @NonNls
    private static final String FOLDING_ELEMENT = "folding";

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditor"));
        }
        FileEditor fileEditor = this.createEditorAsync(project, file).build();
        if (fileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditor"));
        }
        return fileEditor;
    }

    @NotNull
    public AsyncFileEditorProvider.Builder createEditorAsync(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditorAsync"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditorAsync"));
        }
        if (!this.accept(project, file)) {
            LOG.error("Cannot open text editor for " + file);
        }
        CodeFoldingState state = null;
        if (!project.isDefault()) {
            try {
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null) {
                    state = CodeFoldingManager.getInstance(project).buildInitialFoldings(document);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Error building initial foldings", (Throwable)e);
            }
        }
        final CodeFoldingState finalState = state;
        AsyncFileEditorProvider.Builder builder = new AsyncFileEditorProvider.Builder(){

            public FileEditor build() {
                PsiAwareTextEditorImpl editor = new PsiAwareTextEditorImpl(project, file, PsiAwareTextEditorProvider.this);
                if (finalState != null) {
                    finalState.setToEditor(editor.getEditor());
                }
                return editor;
            }
        };
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditorAsync"));
        }
        return builder;
    }

    @Override
    @NotNull
    public FileEditorState readState(@NotNull Element element, final @NotNull Project project, final @NotNull VirtualFile file) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        TextEditorState state = (TextEditorState)super.readState(element, project, file);
        Element child = element.getChild(FOLDING_ELEMENT);
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (child != null) {
            if (document == null) {
                final Element detachedStateCopy = child.clone();
                state.setDelayedFoldState(new Producer<CodeFoldingState>(){

                    public CodeFoldingState produce() {
                        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
                        return document == null ? null : CodeFoldingManager.getInstance(project).readFoldingState(detachedStateCopy, document);
                    }
                });
            } else {
                state.setFoldingState(CodeFoldingManager.getInstance(project).readFoldingState(child, document));
            }
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        return textEditorState;
    }

    @Override
    public void writeState(@NotNull FileEditorState _state, @NotNull Project project, @NotNull Element element) {
        if (_state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_state", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "writeState"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "writeState"));
        }
        super.writeState(_state, project, element);
        TextEditorState state = (TextEditorState)_state;
        CodeFoldingState foldingState = state.getFoldingState();
        if (foldingState != null) {
            Element e = new Element(FOLDING_ELEMENT);
            try {
                CodeFoldingManager.getInstance(project).writeFoldingState(foldingState, e);
            }
            catch (WriteExternalException e1) {
                // empty catch block
            }
            element.addContent(e);
        }
    }

    @Override
    protected TextEditorState getStateImpl(Project project, @NotNull Editor editor, @NotNull FileEditorStateLevel level) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "getStateImpl"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "getStateImpl"));
        }
        TextEditorState state = super.getStateImpl(project, editor, level);
        if (FileEditorStateLevel.FULL == level) {
            if (project != null && !project.isDisposed() && !editor.isDisposed() && project.isInitialized()) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                state.setFoldingState(CodeFoldingManager.getInstance(project).saveFoldingState(editor));
            } else {
                state.setFoldingState(null);
            }
        }
        return state;
    }

    @Override
    protected void setStateImpl(final Project project, final Editor editor, TextEditorState state) {
        super.setStateImpl(project, editor, state);
        final CodeFoldingState foldState = state.getFoldingState();
        if (project != null && foldState != null) {
            new WriteAction(){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider$3", "run"));
                    }
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                        @Override
                        public void run() {
                            CodeFoldingManager.getInstance(project).restoreFoldingState(editor, foldState);
                        }
                    });
                }
            }.execute();
        }
    }

    @Override
    @NotNull
    protected TextEditorProvider.EditorWrapper createWrapperForEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createWrapperForEditor"));
        }
        PsiAwareEditorWrapper psiAwareEditorWrapper = new PsiAwareEditorWrapper(editor);
        if (psiAwareEditorWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createWrapperForEditor"));
        }
        return psiAwareEditorWrapper;
    }

    private final class PsiAwareEditorWrapper
    extends TextEditorProvider.EditorWrapper {
        private final TextEditorBackgroundHighlighter myBackgroundHighlighter;

        private PsiAwareEditorWrapper(Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider$PsiAwareEditorWrapper", "<init>"));
            }
            super(PsiAwareTextEditorProvider.this, editor);
            Project project = editor.getProject();
            this.myBackgroundHighlighter = project == null ? null : new TextEditorBackgroundHighlighter(project, editor);
        }

        @Override
        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return this.myBackgroundHighlighter;
        }
    }
}

