/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultVcsRootPolicy {
    public static DefaultVcsRootPolicy getInstance(Project project) {
        return (DefaultVcsRootPolicy)PeriodicalTasksCloser.getInstance().safeGetService(project, DefaultVcsRootPolicy.class);
    }

    public abstract void addDefaultVcsRoots(NewMappings var1, @NotNull String var2, List<VirtualFile> var3);

    public abstract boolean matchesDefaultMapping(VirtualFile var1, Object var2);

    @Nullable
    public abstract Object getMatchContext(VirtualFile var1);

    @Nullable
    public abstract VirtualFile getVcsRootFor(VirtualFile var1);

    public abstract void markDefaultRootsDirty(DirtBuilder var1, VcsGuess var2);

    public String getProjectConfigurationMessage(Project project) {
        StorageScheme storageScheme = ((ProjectEx)project).getStateStore().getStorageScheme();
        boolean isDirectoryBased = StorageScheme.DIRECTORY_BASED.equals((Object)storageScheme);
        String[] parts = new String[]{"Content roots of all modules", "all immediate descendants of project base directory", ".idea directory contents"};
        StringBuilder sb = new StringBuilder(parts[0]);
        if (isDirectoryBased) {
            sb.append(", ");
        } else {
            sb.append(", and ");
        }
        sb.append(parts[1]);
        if (isDirectoryBased) {
            sb.append(", and ");
            sb.append(parts[2]);
        }
        return sb.toString();
    }
}

