/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.BaseToolsPanel;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolsBundle;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.Nullable;

class ToolSelectDialog
extends DialogWrapper {
    private final BaseToolsPanel myToolsPanel;

    protected ToolSelectDialog(@Nullable Project project, @Nullable String actionIdToSelect, BaseToolsPanel toolsPanel) {
        super(project);
        this.myToolsPanel = toolsPanel;
        this.myToolsPanel.reset();
        this.setOKActionEnabled(this.myToolsPanel.getSingleSelectedTool() != null);
        this.myToolsPanel.addSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ToolSelectDialog.this.setOKActionEnabled(ToolSelectDialog.this.myToolsPanel.getSingleSelectedTool() != null);
            }
        });
        this.init();
        this.pack();
        if (actionIdToSelect != null) {
            this.myToolsPanel.selectTool(actionIdToSelect);
        }
        this.setTitle(ToolsBundle.message("tools.dialog.title", new Object[0]));
    }

    protected void doOKAction() {
        try {
            this.myToolsPanel.apply();
        }
        catch (IOException e) {
            String message = ToolsBundle.message("tools.failed.to.save.changes.0", StringUtil.decapitalize((String)e.getMessage()));
            JLayeredPane pane = this.myToolsPanel.getRootPane().getLayeredPane();
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setShowCallout(false).setFadeoutTime(3000L).setHideOnAction(true).setHideOnClickOutside(true).setHideOnKeyOutside(true).createBalloon().show(new RelativePoint((Component)pane, new Point(pane.getWidth(), 0)), Balloon.Position.above);
            return;
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        return this.myToolsPanel;
    }

    @Nullable
    Tool getSelectedTool() {
        return this.myToolsPanel.getSingleSelectedTool();
    }

    boolean isModified() {
        return this.myToolsPanel.isModified();
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.tools.ToolSelectDialog.dimensionServiceKey";
    }
}

