/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class GCUtil {
    public static void tryForceGC() {
        GCUtil.tryGcSoftlyReachableObjects();
        WeakReference<Object> weakReference = new WeakReference<Object>(new Object());
        do {
            System.gc();
        } while (weakReference.get() != null);
    }

    public static void tryGcSoftlyReachableObjects() {
        ReferenceQueue q = new ReferenceQueue();
        SoftReference<Object> ref = new SoftReference<Object>(new Object(), q);
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)(100 + GCUtil.useReference(ref)));
        for (int i = 0; i < 100; ++i) {
            System.gc();
            if (q.poll() != null) break;
            TimeoutUtil.sleep((long)10L);
            long bytes = Math.min(Runtime.getRuntime().freeMemory() / 2L, 0x3FFFFFFFL);
            list.add(new SoftReference<byte[]>(new byte[(int)bytes]));
        }
    }

    private static int useReference(SoftReference<Object> ref) {
        Object o = ref.get();
        return o == null ? 0 : Math.abs(o.hashCode()) % 10;
    }
}

