/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.completion;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.file.FileLookupInfoProvider;
import com.intellij.util.indexing.FileBasedIndex;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.index.ImageInfoIndex;
import org.jetbrains.annotations.NotNull;

public class ImageLookupInfoProvider
extends FileLookupInfoProvider {
    public Couple<String> getLookupInfo(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/completion/ImageLookupInfoProvider", "getLookupInfo"));
        }
        final String[] s = new String[]{null};
        ImageInfoIndex.processValues(file, new FileBasedIndex.ValueProcessor<ImageInfoIndex.ImageInfo>(){

            public boolean process(VirtualFile file, ImageInfoIndex.ImageInfo value) {
                s[0] = String.format("%sx%s", value.width, value.height);
                return true;
            }
        }, project);
        return s[0] == null ? null : Couple.of((Object)file.getName(), (Object)s[0]);
    }

    @NotNull
    public FileType[] getFileTypes() {
        FileType[] fileTypeArray = new FileType[]{ImageFileTypeManager.getInstance().getImageFileType()};
        if (fileTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/completion/ImageLookupInfoProvider", "getFileTypes"));
        }
        return fileTypeArray;
    }
}

