/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentAsyncFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.ValueBase;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;

public abstract class ObjectValueBase<VALUE_LOADER extends ValueManager>
extends ValueBase
implements ObjectValue {
    protected VariablesHost<VALUE_LOADER> childrenManager;

    public ObjectValueBase(@NotNull ValueType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/debugger/values/ObjectValueBase", "<init>"));
        }
        super(type);
    }

    @Override
    @NotNull
    public final Promise<List<Variable>> getProperties() {
        Promise<List<Variable>> promise = this.childrenManager.get();
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "getProperties"));
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<List<Variable>> getProperties(final @NotNull List<String> names, final @NotNull EvaluateContext evaluateContext, @NotNull Obsolescent obsolescent) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/debugger/values/ObjectValueBase", "getProperties"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "org/jetbrains/debugger/values/ObjectValueBase", "getProperties"));
        }
        if (obsolescent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obsolescent", "org/jetbrains/debugger/values/ObjectValueBase", "getProperties"));
        }
        Promise promise = this.getProperties().then((AsyncFunction)new MyObsolescentAsyncFunction<List<Variable>, List<Variable>>(obsolescent){

            @NotNull
            public Promise<List<Variable>> fun(List<Variable> variables) {
                Promise<List<Variable>> promise = ObjectValueBase.getSpecifiedProperties(variables, names, evaluateContext);
                if (promise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase$1", "fun"));
                }
                return promise;
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "getProperties"));
        }
        return promise;
    }

    @NotNull
    protected static Promise<List<Variable>> getSpecifiedProperties(@NotNull List<Variable> variables, final @NotNull List<String> names, @NotNull EvaluateContext evaluateContext) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/values/ObjectValueBase", "getSpecifiedProperties"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/debugger/values/ObjectValueBase", "getSpecifiedProperties"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "org/jetbrains/debugger/values/ObjectValueBase", "getSpecifiedProperties"));
        }
        SmartList properties = new SmartList();
        int getterCount = 0;
        for (Variable property : variables) {
            if (!property.isReadable() || !names.contains(property.getName())) continue;
            if (!properties.isEmpty()) {
                Collections.sort(properties, new Comparator<Variable>(){

                    @Override
                    public int compare(@NotNull Variable o1, @NotNull Variable o2) {
                        if (o1 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/debugger/values/ObjectValueBase$2", "compare"));
                        }
                        if (o2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/debugger/values/ObjectValueBase$2", "compare"));
                        }
                        return names.indexOf(o1.getName()) - names.indexOf(o2.getName());
                    }
                });
            }
            properties.add(property);
            if (property.getValue() != null) continue;
            ++getterCount;
        }
        if (getterCount == 0) {
            Promise promise = Promise.resolve((Object)properties);
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "getSpecifiedProperties"));
            }
            return promise;
        }
        SmartList promises = new SmartList();
        for (Variable variable : properties) {
            if (variable.getValue() != null) continue;
            ValueModifier valueModifier = variable.getValueModifier();
            assert (valueModifier != null);
            promises.add(valueModifier.evaluateGet(variable, evaluateContext));
        }
        Promise promise = Promise.all((Collection)promises, (Object)properties);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "getSpecifiedProperties"));
        }
        return promise;
    }

    @Override
    @Nullable
    public String getValueString() {
        return null;
    }

    @Override
    @NotNull
    public ThreeState hasProperties() {
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "hasProperties"));
        }
        return threeState;
    }

    @Override
    @NotNull
    public ThreeState hasIndexedProperties() {
        ThreeState threeState = ThreeState.NO;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "hasIndexedProperties"));
        }
        return threeState;
    }

    @Override
    @NotNull
    public Promise<Void> getIndexedProperties(int from, int to, int bucketThreshold, @NotNull IndexedVariablesConsumer consumer, @Nullable ValueType componentType) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/debugger/values/ObjectValueBase", "getIndexedProperties"));
        }
        Promise promise = Promise.REJECTED;
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "getIndexedProperties"));
        }
        return promise;
    }

    @Override
    @NotNull
    public VariablesHost getVariablesHost() {
        VariablesHost<VALUE_LOADER> variablesHost = this.childrenManager;
        if (variablesHost == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "getVariablesHost"));
        }
        return variablesHost;
    }

    abstract class MyObsolescentAsyncFunction<PARAM, RESULT>
    implements ObsolescentAsyncFunction<PARAM, RESULT> {
        private final Obsolescent obsolescent;

        MyObsolescentAsyncFunction(Obsolescent obsolescent) {
            if (obsolescent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obsolescent", "org/jetbrains/debugger/values/ObjectValueBase$MyObsolescentAsyncFunction", "<init>"));
            }
            this.obsolescent = obsolescent;
        }

        public boolean isObsolete() {
            return this.obsolescent.isObsolete() || ((ValueManager)ObjectValueBase.this.childrenManager.valueManager).isObsolete();
        }
    }
}

