/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.UIUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.Icon;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.DelegatingHttpRequestHandlerBase;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;

@ChannelHandler.Sharable
final class DelegatingHttpRequestHandler
extends DelegatingHttpRequestHandlerBase {
    private static final AttributeKey<HttpRequestHandler> PREV_HANDLER = AttributeKey.valueOf((String)"DelegatingHttpRequestHandler.handler");

    DelegatingHttpRequestHandler() {
    }

    static boolean checkAndProcess(@NotNull HttpRequestHandler handler, @NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/io/DelegatingHttpRequestHandler", "checkAndProcess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/DelegatingHttpRequestHandler", "checkAndProcess"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/io/DelegatingHttpRequestHandler", "checkAndProcess"));
        }
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/io/DelegatingHttpRequestHandler", "checkAndProcess"));
        }
        return handler.isSupported(request) && !NettyUtil.isWriteFromBrowserWithoutOrigin((HttpRequest)request) && handler.isAccessible((HttpRequest)request) && handler.process(urlDecoder, request, context);
    }

    @Override
    protected boolean process(@NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) throws IOException, ImageWriteException {
        Icon icon;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/DelegatingHttpRequestHandler", "process"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/io/DelegatingHttpRequestHandler", "process"));
        }
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/io/DelegatingHttpRequestHandler", "process"));
        }
        Attribute prevHandlerAttribute = context.attr(PREV_HANDLER);
        HttpRequestHandler connectedHandler = (HttpRequestHandler)prevHandlerAttribute.get();
        if (connectedHandler != null) {
            if (DelegatingHttpRequestHandler.checkAndProcess(connectedHandler, context, request, urlDecoder)) {
                return true;
            }
            prevHandlerAttribute.set(null);
        }
        for (HttpRequestHandler handler : (HttpRequestHandler[])HttpRequestHandler.EP_NAME.getExtensions()) {
            try {
                if (!DelegatingHttpRequestHandler.checkAndProcess(handler, context, request, urlDecoder)) continue;
                prevHandlerAttribute.set((Object)handler);
                return true;
            }
            catch (Throwable e) {
                BuiltInServer.LOG.error(e);
            }
        }
        if (urlDecoder.path().equals("/favicon.ico") && (icon = IconLoader.findIcon((String)ApplicationInfoEx.getInstanceEx().getSmallIconUrl())) != null) {
            BufferedImage image = UIUtil.createImage((int)icon.getIconWidth(), (int)icon.getIconHeight(), (int)2);
            icon.paintIcon(null, image.getGraphics(), 0, 0);
            byte[] icoBytes = Sanselan.writeImageToBytes((BufferedImage)image, (ImageFormat)ImageFormat.IMAGE_FORMAT_ICO, null);
            FullHttpResponse response = Responses.response(FileResponses.getContentType(urlDecoder.path()), Unpooled.wrappedBuffer((byte[])icoBytes));
            Responses.addNoCache((HttpResponse)response);
            Responses.send((HttpResponse)response, context.channel(), (HttpRequest)request);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/DelegatingHttpRequestHandler", "exceptionCaught"));
        }
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "org/jetbrains/io/DelegatingHttpRequestHandler", "exceptionCaught"));
        }
        try {
            context.attr(PREV_HANDLER).remove();
        }
        finally {
            super.exceptionCaught(context, cause);
        }
    }
}

