/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.info.TestInfo;
import com.intellij.execution.junit2.states.TestState;
import com.intellij.execution.junit2.ui.ActualStatistics;
import com.intellij.execution.junit2.ui.TestStatistics;
import java.text.NumberFormat;

public class Formatters {
    public static String printTest(TestProxy test) {
        if (test == null || test.getInfo() == null) {
            return "";
        }
        TestInfo info = test.getInfo();
        return info.getName() + Formatters.sensibleCommentFor(test);
    }

    public static String printTime(long milliseconds) {
        if (milliseconds == 0L) {
            return ExecutionBundle.message((String)"junit.runing.info.time.sec.message", (Object[])new Object[]{"0.0"});
        }
        long seconds = milliseconds / 1000L;
        if (seconds == 0L) {
            return ExecutionBundle.message((String)"junit.runing.info.time.sec.message", (Object[])new Object[]{NumberFormat.getInstance().format((double)milliseconds / 1000.0)});
        }
        StringBuilder sb = new StringBuilder();
        if (seconds >= 3600L) {
            sb.append(seconds / 3600L).append("h ");
            seconds %= 3600L;
        }
        if (seconds >= 60L) {
            sb.append(seconds / 60L).append("m ");
            seconds %= 60L;
        }
        if (seconds > 0L || sb.length() > 0) {
            sb.append(seconds).append("s");
        }
        return sb.toString();
    }

    public static String printMemory(long memory) {
        String string = Formatters.printMemoryUnsigned(memory);
        return memory > 0L ? "+" + string : string;
    }

    public static String printMemoryUnsigned(long memory) {
        return ExecutionBundle.message((String)"junit.runing.info.memory.available.kb.message", (Object[])new Object[]{NumberFormat.getInstance().format((double)memory / 1024.0)});
    }

    public static TestStatistics statisticsFor(TestProxy test) {
        if (test == null) {
            return TestStatistics.ABCENT;
        }
        TestState state = test.getState();
        int magnitude = state.getMagnitude();
        if (magnitude == 2) {
            return TestStatistics.NOT_RUN;
        }
        if (test.isLeaf()) {
            return state.isFinal() ? Formatters.actualInfo(test) : TestStatistics.RUNNING;
        }
        ActualStatistics actualStatistics = Formatters.actualInfo(test);
        if (state.isInProgress()) {
            actualStatistics.setRunning();
        }
        return actualStatistics;
    }

    private static ActualStatistics actualInfo(TestProxy test) {
        return new ActualStatistics(test.getStatistics());
    }

    private static boolean isCommentSensible(TestProxy testProxy) {
        TestInfo info = testProxy.getInfo();
        if (info.getComment().length() == 0) {
            return false;
        }
        TestProxy parent = testProxy.getParent();
        return parent == null || !Formatters.fullLabelOf(parent.getInfo()).equals(info.getComment());
    }

    private static String fullLabelOf(TestInfo info) {
        return info.getComment() + "." + info.getName();
    }

    public static String sensibleCommentFor(TestProxy testProxy) {
        String sensibleComment = Formatters.isCommentSensible(testProxy) ? " (" + testProxy.getInfo().getComment() + ")" : "";
        return sensibleComment;
    }

    public static String printMemoryMega(long memory) {
        double unit = 1048576.0;
        return ExecutionBundle.message((String)"junit.runing.info.memory.available.mb.message", (Object[])new Object[]{NumberFormat.getInstance().format((double)memory / 1048576.0)});
    }

    public static String printFullKBMemory(long memory) {
        return ExecutionBundle.message((String)"memory.available.message", (Object[])new Object[]{NumberFormat.getInstance().format(memory / 1024L)});
    }

    public static String printMinSec(long millis) {
        long seconds = millis / 1000L;
        if (seconds == 0L) {
            return "";
        }
        long min = seconds / 60L;
        long sec = seconds % 60L;
        return min + ":" + Formatters.formatInt(sec, 2);
    }

    public static String formatInt(long value, int minDigits) {
        String strValue = Long.toString(value);
        for (int i = strValue.length(); i < minDigits; ++i) {
            strValue = "0" + strValue;
        }
        return strValue;
    }
}

