/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.run;

import com.intellij.util.Alarm;
import java.io.IOException;
import java.io.Reader;

abstract class ReadProcessThread
extends Thread {
    private static final int NOTIFY_TEXT_DELAY = 300;
    private final Reader myReader;
    private final StringBuffer myBuffer = new StringBuffer();
    private final Alarm myAlarm;
    private boolean myIsClosed = false;

    public ReadProcessThread(Reader reader) {
        super("ReadProcessThread " + reader.getClass().getName());
        this.setPriority(10);
        this.myReader = reader;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!ReadProcessThread.this.isClosed()) {
                    ReadProcessThread.this.myAlarm.addRequest((Runnable)this, 300);
                    ReadProcessThread.this.checkTextAvailable();
                }
            }
        }, 300);
        try {
            int c;
            while (!this.isClosed() && (c = this.readNextByte()) != -1) {
                StringBuffer stringBuffer = this.myBuffer;
                synchronized (stringBuffer) {
                    this.myBuffer.append((char)c);
                }
                if (c != 10) continue;
                this.checkTextAvailable();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.close();
    }

    private int readNextByte() {
        try {
            return this.myReader.read();
        }
        catch (IOException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTextAvailable() {
        StringBuffer stringBuffer = this.myBuffer;
        synchronized (stringBuffer) {
            if (this.myBuffer.length() == 0) {
                return;
            }
            String s = this.myBuffer.substring(0, this.myBuffer.length());
            this.myBuffer.setLength(0);
            this.textAvailable(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ReadProcessThread readProcessThread = this;
        synchronized (readProcessThread) {
            if (this.isClosed()) {
                return;
            }
            this.myIsClosed = true;
        }
        try {
            if (Thread.currentThread() != this) {
                this.join(0L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.myReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.checkTextAvailable();
    }

    protected abstract void textAvailable(String var1);

    private synchronized boolean isClosed() {
        return this.myIsClosed;
    }
}

