/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.execution.filters.UrlFilter;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class ArbitraryPlaceUrlReferenceProvider
extends PsiReferenceProvider {
    public static final ArbitraryPlaceUrlReferenceProvider INSTANCE = new ArbitraryPlaceUrlReferenceProvider();
    private static final UserDataCache<CachedValue<PsiReference[]>, PsiElement, Object> ourRefsCache = new UserDataCache<CachedValue<PsiReference[]>, PsiElement, Object>("psielement.url.refs"){
        private final AtomicReference<GlobalPathReferenceProvider> myReferenceProvider = new AtomicReference();

        protected CachedValue<PsiReference[]> compute(final PsiElement element, Object p) {
            return CachedValuesManager.getManager((Project)element.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PsiReference[]>(){

                public CachedValueProvider.Result<PsiReference[]> compute() {
                    Matcher matcher = UrlFilter.URL_PATTERN.matcher(element.getText());
                    List refs = null;
                    GlobalPathReferenceProvider provider = (GlobalPathReferenceProvider)myReferenceProvider.get();
                    while (matcher.find()) {
                        int start = matcher.start();
                        int end = matcher.end();
                        if (refs == null) {
                            refs = new SmartList();
                        }
                        if (provider == null) {
                            provider = (GlobalPathReferenceProvider)PathReferenceManager.getInstance().getGlobalWebPathReferenceProvider();
                            myReferenceProvider.lazySet(provider);
                        }
                        provider.createUrlReference(element, matcher.group(0), new TextRange(start, end), refs);
                    }
                    return new CachedValueProvider.Result((Object)(refs != null ? refs.toArray(new PsiReference[refs.size()]) : PsiReference.EMPTY_ARRAY), new Object[]{element});
                }
            }, false);
        }
    };

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/ArbitraryPlaceUrlReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/documentation/ArbitraryPlaceUrlReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = (PsiReference[])((CachedValue)ourRefsCache.get((UserDataHolder)element, null)).getValue();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/ArbitraryPlaceUrlReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

