/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.generation.actions.PresentableLanguageCodeInsightActionHandler;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PresentableActionHandlerBasedAction
extends BaseCodeInsightAction {
    private String myCurrentActionName = null;

    protected String getCommandName() {
        String actionName = this.myCurrentActionName;
        return actionName != null ? this.myCurrentActionName : super.getCommandName();
    }

    @Override
    public void update(AnActionEvent event) {
        event.getPresentation().copyFrom(this.getTemplatePresentation());
        super.update(event);
        this.myCurrentActionName = event.getPresentation().getText();
    }

    protected void update(@NotNull Presentation presentation, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "update"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "update"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "update"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "update"));
        }
        LanguageCodeInsightActionHandler handler = this.getValidHandler(editor, file);
        presentation.setEnabled(handler != null);
        if (handler instanceof PresentableLanguageCodeInsightActionHandler) {
            ((PresentableLanguageCodeInsightActionHandler)handler).update(editor, file, presentation);
        }
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "isValidForFile"));
        }
        return this.getValidHandler(editor, file) != null;
    }

    @Nullable
    private LanguageCodeInsightActionHandler getValidHandler(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "getValidHandler"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "getValidHandler"));
        }
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset());
        LanguageCodeInsightActionHandler codeInsightActionHandler = (LanguageCodeInsightActionHandler)this.getLanguageExtension().forLanguage(language);
        if (codeInsightActionHandler != null && codeInsightActionHandler.isValidFor(editor, file)) {
            return codeInsightActionHandler;
        }
        return null;
    }

    @NotNull
    protected abstract LanguageExtension<LanguageCodeInsightActionHandler> getLanguageExtension();
}

