/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.jdi.Bytecodes;
import org.jetbrains.annotations.Nullable;

public class InstructionParser {
    private final byte[] myCode;
    private final long myCurrentInstructionIndex;

    public InstructionParser(byte[] code, long instructionIndex) {
        this.myCode = code;
        this.myCurrentInstructionIndex = instructionIndex;
    }

    public void parse() {
        int codeEnd = this.myCode.length;
        int v = 0;
        int instructionIndex = 0;
        block18: while (v < codeEnd && (long)instructionIndex++ < this.myCurrentInstructionIndex) {
            int opcode = this.myCode[v] & 0xFF;
            int opcodeType = opcode == 254 || opcode == 255 ? 0 : Bytecodes.TYPE[opcode];
            switch (opcodeType) {
                case 0: {
                    ++v;
                    continue block18;
                }
                case 4: {
                    int varOpcode = opcode > 54 ? 54 + ((opcode -= 59) >> 2) : 21 + ((opcode -= 26) >> 2);
                    String signature = InstructionParser.getVarInstructionTypeSignature(varOpcode);
                    if (signature != null) {
                        this.localVariableInstructionFound(varOpcode, opcode & 3, signature);
                    }
                    ++v;
                    continue block18;
                }
                case 9: {
                    v += 3;
                    continue block18;
                }
                case 10: {
                    v += 5;
                    continue block18;
                }
                case 17: {
                    opcode = this.myCode[v + 1] & 0xFF;
                    String signature = InstructionParser.getVarInstructionTypeSignature(opcode);
                    if (signature != null) {
                        this.localVariableInstructionFound(opcode, this.readUnsignedShort(v + 2), signature);
                    }
                    if (opcode == 132) {
                        v += 6;
                        continue block18;
                    }
                    v += 4;
                    continue block18;
                }
                case 14: {
                    v = v + 4 - (v & 3);
                    int min = this.readInt(v + 4);
                    int max = this.readInt(v + 8);
                    v += 12;
                    int length = max - min + 1;
                    v += 4 * length;
                    continue block18;
                }
                case 15: {
                    v = v + 4 - (v & 3);
                    int len = this.readInt(v + 4);
                    v += 8 * (len + 1);
                    continue block18;
                }
                case 3: {
                    String signature = InstructionParser.getVarInstructionTypeSignature(opcode);
                    if (signature != null) {
                        this.localVariableInstructionFound(opcode, this.myCode[v + 1] & 0xFF, signature);
                    }
                    v += 2;
                    continue block18;
                }
                case 1: {
                    v += 2;
                    continue block18;
                }
                case 2: {
                    v += 3;
                    continue block18;
                }
                case 11: {
                    v += 2;
                    continue block18;
                }
                case 12: {
                    v += 3;
                    continue block18;
                }
                case 6: 
                case 7: {
                    if (opcode == 185) {
                        v += 5;
                        continue block18;
                    }
                    v += 3;
                    continue block18;
                }
                case 8: {
                    v += 5;
                    continue block18;
                }
                case 5: {
                    v += 3;
                    continue block18;
                }
                case 13: {
                    String signature = InstructionParser.getVarInstructionTypeSignature(opcode);
                    if (signature != null) {
                        this.localVariableInstructionFound(opcode, this.myCode[v + 1] & 0xFF, signature);
                    }
                    v += 3;
                    continue block18;
                }
            }
            v += 4;
        }
    }

    private int readUnsignedShort(int index) {
        byte[] b = this.myCode;
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    public int readInt(int index) {
        byte[] b = this.myCode;
        return (b[index] & 0xFF) << 24 | (b[index + 1] & 0xFF) << 16 | (b[index + 2] & 0xFF) << 8 | b[index + 3] & 0xFF;
    }

    protected void localVariableInstructionFound(int opcode, int slot, String typeSignature) {
    }

    @Nullable
    private static String getVarInstructionTypeSignature(int opcode) {
        switch (opcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 132: {
                return "I";
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                return "J";
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return "F";
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return "D";
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return "L";
            }
        }
        return null;
    }
}

