/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class StatusPanel
extends JPanel {
    private final JLabel myTextLabel = new JLabel("");
    private final AnimatedIcon myBusySpinner = new AsyncProcessIcon("StatusPanelSpinner");

    public StatusPanel() {
        super(new BorderLayout());
        this.myBusySpinner.setVisible(false);
        this.add((Component)this.myTextLabel, "Center");
        this.add((Component)this.myBusySpinner, "West");
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)4, (int)0, (int)4));
    }

    public void update() {
        int count = this.getChangesCount();
        this.myTextLabel.setText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{count}));
    }

    public void setBusy(boolean busy) {
        if (busy) {
            this.myBusySpinner.setVisible(true);
            this.myBusySpinner.resume();
        } else {
            this.myBusySpinner.setVisible(false);
            this.myBusySpinner.suspend();
        }
    }

    protected abstract int getChangesCount();
}

