/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerMediator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.RunnerMediator");
    private static final char IAC = '\u0005';
    private static final char BRK = '\u0003';
    private static final char C = '\u0005';
    private static final String STANDARD_RUNNERW = "runnerw.exe";
    private static final String IDEA_RUNNERW = "IDEA_RUNNERW";

    public static RunnerMediator getInstance() {
        return new RunnerMediator();
    }

    private static void sendCtrlEventThroughStream(@NotNull Process process, char event) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/RunnerMediator", "sendCtrlEventThroughStream"));
        }
        OutputStream os = process.getOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.print('\u0005');
        pw.print(event);
        pw.flush();
    }

    public ProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/RunnerMediator", "createProcess"));
        }
        return this.createProcess(commandLine, false);
    }

    public ProcessHandler createProcess(@NotNull GeneralCommandLine commandLine, boolean useSoftKill) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/RunnerMediator", "createProcess"));
        }
        if (SystemInfo.isWindows) {
            RunnerMediator.injectRunnerCommand(commandLine);
        }
        return new CustomDestroyProcessHandler(commandLine, useSoftKill);
    }

    @Nullable
    private static String getRunnerPath() {
        File runnerw;
        if (!SystemInfo.isWindows) {
            throw new IllegalStateException("There is no need of runner under unix based OS");
        }
        String path = System.getenv(IDEA_RUNNERW);
        if (path != null) {
            if (new File(path).exists()) {
                return path;
            }
            LOG.warn("Cannot locate runnerw.exe by IDEA_RUNNERW environment variable (" + path + ")");
        }
        if ((runnerw = new File(PathManager.getBinPath(), STANDARD_RUNNERW)).exists()) {
            return runnerw.getPath();
        }
        LOG.warn("Cannot locate runnerw.exe by default path (" + runnerw.getAbsolutePath() + ")");
        return null;
    }

    static boolean injectRunnerCommand(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/RunnerMediator", "injectRunnerCommand"));
        }
        String path = RunnerMediator.getRunnerPath();
        if (path != null) {
            commandLine.getParametersList().addAt(0, commandLine.getExePath());
            commandLine.setExePath(path);
            return true;
        }
        return false;
    }

    public static boolean destroyProcess(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/RunnerMediator", "destroyProcess"));
        }
        return RunnerMediator.destroyProcess(process, false);
    }

    static boolean destroyProcess(@NotNull Process process, boolean softKill) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/RunnerMediator", "destroyProcess"));
        }
        try {
            if (SystemInfo.isWindows) {
                RunnerMediator.sendCtrlEventThroughStream(process, softKill ? (char)'\u0005' : '\u0003');
                return true;
            }
            if (SystemInfo.isUnix) {
                if (softKill) {
                    return UnixProcessManager.sendSigIntToProcessTree((Process)process);
                }
                return UnixProcessManager.sendSigKillToProcessTree((Process)process);
            }
            return false;
        }
        catch (Exception e) {
            LOG.error("Couldn't terminate the process", (Throwable)e);
            return false;
        }
    }

    public static class CustomDestroyProcessHandler
    extends ColoredProcessHandler {
        private final boolean mySoftKill;

        public CustomDestroyProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine) {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/RunnerMediator$CustomDestroyProcessHandler", "<init>"));
            }
            if (commandLine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/RunnerMediator$CustomDestroyProcessHandler", "<init>"));
            }
            this(process, commandLine, false);
        }

        public CustomDestroyProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, boolean softKill) {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/RunnerMediator$CustomDestroyProcessHandler", "<init>"));
            }
            if (commandLine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/RunnerMediator$CustomDestroyProcessHandler", "<init>"));
            }
            super(process, commandLine.getCommandLineString());
            this.mySoftKill = softKill;
        }

        public CustomDestroyProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/RunnerMediator$CustomDestroyProcessHandler", "<init>"));
            }
            this(commandLine, false);
        }

        public CustomDestroyProcessHandler(@NotNull GeneralCommandLine commandLine, boolean softKill) throws ExecutionException {
            if (commandLine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/RunnerMediator$CustomDestroyProcessHandler", "<init>"));
            }
            super(commandLine);
            this.mySoftKill = softKill;
        }

        protected boolean shouldDestroyProcessRecursively() {
            return true;
        }

        protected void destroyProcessImpl() {
            if (!RunnerMediator.destroyProcess(this.getProcess(), this.mySoftKill)) {
                super.destroyProcessImpl();
            }
        }
    }
}

