/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class UnmarkRootAction
extends MarkRootActionBase {
    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @Nullable Module module, @NotNull MarkRootActionBase.RootsSelection selection) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/projectView/actions/UnmarkRootAction", "doUpdate"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/UnmarkRootAction", "doUpdate"));
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && !selection.mySelectedExcludeRoots.isEmpty() && selection.mySelectedDirectories.isEmpty() && selection.mySelectedRoots.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText("Cancel Exclusion");
            return;
        }
        super.doUpdate(e, module, selection);
        HashSet selectedRootTypes = new HashSet();
        for (SourceFolder root : selection.mySelectedRoots) {
            selectedRootTypes.add(root.getRootType());
        }
        if (!selectedRootTypes.isEmpty()) {
            String text;
            if (selectedRootTypes.size() == 1) {
                JpsModuleSourceRootType type = (JpsModuleSourceRootType)selectedRootTypes.iterator().next();
                ModuleSourceRootEditHandler handler = ModuleSourceRootEditHandler.getEditHandler(type);
                text = "Unmark as " + handler.getRootTypeName() + " " + StringUtil.pluralize((String)"Root", (int)selection.mySelectedRoots.size());
            } else {
                text = "Unmark Roots";
            }
            e.getPresentation().setText(text);
        }
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/UnmarkRootAction", "isEnabled"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/projectView/actions/UnmarkRootAction", "isEnabled"));
        }
        return selection.mySelectedDirectories.isEmpty() && !selection.mySelectedRoots.isEmpty();
    }

    @Override
    protected void modifyRoots(VirtualFile file, ContentEntry entry) {
        for (ExcludeFolder excludeFolder : entry.getExcludeFolders()) {
            if (!file.equals(excludeFolder.getFile())) continue;
            entry.removeExcludeFolder(excludeFolder);
            break;
        }
    }
}

