/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.impl.external.ContentExternalizer;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.external.ExternalToolContentExternalizer;
import com.intellij.openapi.diff.impl.external.LocalFileExternalizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.StringProperty;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseExternalTool
implements DiffTool {
    private final BooleanProperty myEnableProperty;
    private final StringProperty myToolProperty;

    protected BaseExternalTool(BooleanProperty enableProperty, StringProperty toolProperty) {
        this.myEnableProperty = enableProperty;
        this.myToolProperty = toolProperty;
    }

    public final boolean canShow(@NotNull DiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/diff/impl/external/BaseExternalTool", "canShow"));
        }
        if (!this.isEnabled() || StringUtil.isEmpty((String)this.getToolPath())) {
            return false;
        }
        return this.isAvailable(request);
    }

    public DiffViewer createComponent(String title, DiffRequest request, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/BaseExternalTool", "createComponent"));
        }
        return null;
    }

    public abstract boolean isAvailable(@NotNull DiffRequest var1);

    @Nullable
    protected ContentExternalizer externalize(@NotNull DiffRequest request, int index) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/diff/impl/external/BaseExternalTool", "externalize"));
        }
        VirtualFile file = BaseExternalTool.getLocalFile(request.getContents()[index].getFile());
        if (LocalFileExternalizer.canExternalizeAsFile(file)) {
            return LocalFileExternalizer.tryCreate(file);
        }
        return new ExternalToolContentExternalizer(request, index);
    }

    public static AbstractProperty.AbstractPropertyContainer getProperties() {
        return DiffManagerImpl.getInstanceEx().getProperties();
    }

    protected String getToolPath() {
        return (String)this.myToolProperty.get(BaseExternalTool.getProperties());
    }

    protected boolean isEnabled() {
        return this.myEnableProperty.value(BaseExternalTool.getProperties());
    }

    @NotNull
    protected List<String> getParameters(@NotNull DiffRequest request) throws Exception {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/diff/impl/external/BaseExternalTool", "getParameters"));
        }
        String p1 = this.convertToPath(request, 0);
        String p2 = this.convertToPath(request, 1);
        ArrayList<String> params = new ArrayList<String>();
        if (p1 != null) {
            params.add(p1);
        }
        if (p2 != null) {
            params.add(p2);
        }
        ArrayList<String> arrayList = params;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/external/BaseExternalTool", "getParameters"));
        }
        return arrayList;
    }

    public void show(DiffRequest request) {
        this.saveContents(request);
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(this.getToolPath());
        try {
            commandLine.addParameters(this.getParameters(request));
            commandLine.createProcess();
        }
        catch (Exception e) {
            ExecutionErrorDialog.show((ExecutionException)new ExecutionException(e.getMessage()), (String)DiffBundle.message((String)"cant.launch.diff.tool.error.message", (Object[])new Object[0]), (Project)request.getProject());
        }
    }

    protected void saveContents(DiffRequest request) {
        for (DiffContent diffContent : request.getContents()) {
            Document document = diffContent.getDocument();
            if (document == null) continue;
            FileDocumentManager.getInstance().saveDocument(document);
        }
    }

    @Nullable
    protected String convertToPath(DiffRequest request, int index) throws Exception {
        ContentExternalizer externalize = this.externalize(request, index);
        return externalize == null ? null : externalize.getContentFile().getAbsolutePath();
    }

    @Nullable
    protected static VirtualFile getLocalFile(VirtualFile file) {
        if (file != null && file.isInLocalFileSystem()) {
            return file;
        }
        return null;
    }
}

