/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContentChooser<Data>
extends DialogWrapper {
    private List<Data> myAllContents;
    private Editor myViewer;
    private final boolean myUseIdeaEditor;
    private final JList myList;
    private final JBSplitter mySplitter;
    private final Project myProject;
    private final boolean myAllowMultipleSelections;
    private final Alarm myUpdateAlarm;
    private Icon myListEntryIcon = AllIcons.FileTypes.Text;

    public ContentChooser(Project project, String title, boolean useIdeaEditor) {
        this(project, title, useIdeaEditor, false);
    }

    public ContentChooser(Project project, String title, boolean useIdeaEditor, boolean allowMultipleSelections) {
        super(project, true);
        this.myProject = project;
        this.myUseIdeaEditor = useIdeaEditor;
        this.myAllowMultipleSelections = allowMultipleSelections;
        this.myUpdateAlarm = new Alarm(this.getDisposable());
        this.mySplitter = new JBSplitter(true, 0.3f);
        this.mySplitter.setSplitterProportionKey(this.getDimensionServiceKey() + ".splitter");
        this.myList = new JBList((ListModel)new CollectionListModel((Object[])new Item[0]));
        this.setOKButtonText(CommonBundle.getOkButtonText());
        this.setTitle(title);
        this.init();
    }

    public void setContentIcon(@Nullable Icon icon) {
        this.myListEntryIcon = icon;
    }

    public void setSplitterOrientation(boolean vertical) {
        this.mySplitter.setOrientation(vertical);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    protected JComponent createCenterPanel() {
        int selectionMode = this.myAllowMultipleSelections ? 2 : 0;
        this.myList.setSelectionMode(selectionMode);
        if (this.myUseIdeaEditor) {
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.myList.setFont(scheme.getFont(EditorFontType.PLAIN));
            Color fg = (Color)ObjectUtils.chooseNotNull((Object)scheme.getDefaultForeground(), (Object)UIUtil.getListForeground());
            Color bg = (Color)ObjectUtils.chooseNotNull((Object)scheme.getDefaultBackground(), (Object)UIUtil.getListBackground());
            this.myList.setForeground(fg);
            this.myList.setBackground(bg);
        }
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                ContentChooser.this.close(0);
                return true;
            }
        }.installOn((Component)this.myList);
        this.myList.setCellRenderer(new MyListCellRenderer());
        this.myList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int newSelectionIndex = -1;
                    for (Object o : ContentChooser.this.myList.getSelectedValues()) {
                        int i = ((Item)o).index;
                        ContentChooser.this.removeContentAt(ContentChooser.this.myAllContents.get(i));
                        if (newSelectionIndex >= 0) continue;
                        newSelectionIndex = i;
                    }
                    ContentChooser.this.rebuildListContent();
                    if (ContentChooser.this.myAllContents.isEmpty()) {
                        ContentChooser.this.close(1);
                        return;
                    }
                    newSelectionIndex = Math.min(newSelectionIndex, ContentChooser.this.myAllContents.size() - 1);
                    ContentChooser.this.myList.setSelectedIndex(newSelectionIndex);
                } else if (e.getKeyCode() == 10) {
                    ContentChooser.this.doOKAction();
                } else {
                    char aChar = e.getKeyChar();
                    if (aChar >= '0' && aChar <= '9') {
                        int idx;
                        int n = idx = aChar == '0' ? 9 : aChar - 49;
                        if (idx < ContentChooser.this.myAllContents.size()) {
                            ContentChooser.this.myList.setSelectedIndex(idx);
                            e.consume();
                            ContentChooser.this.doOKAction();
                        }
                    }
                }
            }
        });
        this.mySplitter.setFirstComponent(ListWithFilter.wrap((JList)this.myList, (JScrollPane)ScrollPaneFactory.createScrollPane((Component)this.myList), (Function)new Function<Object, String>(){

            public String fun(Object o) {
                return ((Item)o).longText;
            }
        }));
        this.mySplitter.setSecondComponent((JComponent)new JPanel());
        this.rebuildListContent();
        ListScrollingUtil.installActions((JList)this.myList);
        ListScrollingUtil.ensureSelectionExists((JList)this.myList);
        this.updateViewerForSelection();
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ContentChooser.this.myUpdateAlarm.cancelAllRequests();
                ContentChooser.this.myUpdateAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        ContentChooser.this.updateViewerForSelection();
                    }
                }, 100);
            }
        });
        this.mySplitter.setPreferredSize((Dimension)JBUI.size((int)500, (int)500));
        SplitterProportionsDataImpl d = new SplitterProportionsDataImpl();
        d.externalizeToDimensionService(((Object)((Object)this)).getClass().getName());
        d.restoreSplitterProportions((Component)this.mySplitter);
        return this.mySplitter;
    }

    protected abstract void removeContentAt(Data var1);

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void doOKAction() {
        if (this.getSelectedIndex() < 0) {
            return;
        }
        super.doOKAction();
    }

    private void updateViewerForSelection() {
        if (this.myAllContents.isEmpty()) {
            return;
        }
        String fullString = this.getSelectedText();
        if (this.myViewer != null) {
            EditorFactory.getInstance().releaseEditor(this.myViewer);
        }
        if (this.myUseIdeaEditor) {
            this.myViewer = this.createIdeaEditor(fullString);
            JComponent component = this.myViewer.getComponent();
            component.setPreferredSize((Dimension)JBUI.size((int)300, (int)500));
            this.mySplitter.setSecondComponent(component);
        } else {
            JTextArea textArea = new JTextArea(fullString);
            textArea.setRows(3);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setSelectionStart(0);
            textArea.setSelectionEnd(textArea.getText().length());
            textArea.setEditable(false);
            this.mySplitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)textArea));
        }
        this.mySplitter.revalidate();
    }

    protected Editor createIdeaEditor(String text) {
        Document doc = EditorFactory.getInstance().createDocument((CharSequence)text);
        Editor editor = EditorFactory.getInstance().createViewer(doc, this.myProject);
        editor.getSettings().setFoldingOutlineShown(false);
        editor.getSettings().setLineNumbersShown(false);
        editor.getSettings().setLineMarkerAreaShown(false);
        editor.getSettings().setIndentGuidesShown(false);
        return editor;
    }

    public void dispose() {
        super.dispose();
        SplitterProportionsDataImpl d = new SplitterProportionsDataImpl();
        d.externalizeToDimensionService(((Object)((Object)this)).getClass().getName());
        d.saveSplitterProportions((Component)this.mySplitter);
        if (this.myViewer != null) {
            EditorFactory.getInstance().releaseEditor(this.myViewer);
            this.myViewer = null;
        }
    }

    private void rebuildListContent() {
        ArrayList<Item> items = new ArrayList<Item>();
        int i = 0;
        ArrayList<Data> contents = new ArrayList<Data>(this.getContents());
        for (Object content : contents) {
            String shortString;
            String fullString = this.getStringRepresentationFor(content);
            if (fullString == null) continue;
            int newLineIdx = (fullString = StringUtil.convertLineSeparators((String)fullString)).indexOf(10);
            if (newLineIdx == -1) {
                shortString = fullString.trim();
            } else {
                int lastLooked = 0;
                while (true) {
                    int nextLineIdx;
                    if ((nextLineIdx = fullString.indexOf("\n", lastLooked)) > lastLooked) {
                        shortString = fullString.substring(lastLooked, nextLineIdx).trim() + " ...";
                        break;
                    }
                    if (nextLineIdx == -1) {
                        shortString = " ...";
                        break;
                    }
                    lastLooked = nextLineIdx + 1;
                }
            }
            items.add(new Item(i++, shortString, fullString));
        }
        this.myAllContents = contents;
        FilteringListModel listModel = (FilteringListModel)this.myList.getModel();
        ((CollectionListModel)listModel.getOriginalModel()).removeAll();
        listModel.addAll(items);
        ListWithFilter listWithFilter = (ListWithFilter)UIUtil.getParentOfType(ListWithFilter.class, (Component)this.myList);
        if (listWithFilter != null) {
            listWithFilter.getSpeedSearch().update();
            if (listModel.getSize() == 0) {
                listWithFilter.resetFilter();
            }
        }
    }

    protected abstract String getStringRepresentationFor(Data var1);

    protected abstract List<Data> getContents();

    public int getSelectedIndex() {
        Object o = this.myList.getSelectedValue();
        return o == null ? -1 : ((Item)o).index;
    }

    public void setSelectedIndex(int index) {
        this.myList.setSelectedIndex(index);
        ListScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)index, (int)0);
        this.updateViewerForSelection();
    }

    @NotNull
    public int[] getSelectedIndices() {
        Object[] values = this.myList.getSelectedValues();
        int[] result = new int[values.length];
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            result[i] = ((Item)values[i]).index;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/actions/ContentChooser", "getSelectedIndices"));
        }
        return result;
    }

    public List<Data> getAllContents() {
        return this.myAllContents;
    }

    @NotNull
    public String getSelectedText() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : this.myList.getSelectedValues()) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            String s = ((Item)o).longText;
            sb.append(StringUtil.convertLineSeparators((String)s));
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/actions/ContentChooser", "getSelectedText"));
        }
        return string;
    }

    private static class Item {
        final int index;
        final String shortText;
        final String longText;

        private Item(int index, String shortText, String longText) {
            this.index = index;
            this.shortText = shortText;
            this.longText = longText;
        }
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer {
        private MyListCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            this.setIcon(ContentChooser.this.myListEntryIcon);
            if (ContentChooser.this.myUseIdeaEditor) {
                int max = list.getModel().getSize();
                String indexString = String.valueOf(index + 1);
                int count = String.valueOf(max).length() - indexString.length();
                char[] spaces = new char[count];
                Arrays.fill(spaces, ' ');
                String prefix = indexString + new String(spaces) + "  ";
                this.append(prefix, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else if (UIUtil.isUnderGTKLookAndFeel()) {
                Color background = selected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
                UIUtil.changeBackGround((Component)((Object)this), (Color)background);
            }
            String text = ((Item)value).shortText;
            FontMetrics metrics = list.getFontMetrics(list.getFont());
            int charWidth = metrics.charWidth('m');
            int maxLength = list.getParent().getParent().getWidth() * 3 / charWidth / 2;
            text = StringUtil.first((String)text, (int)maxLength, (boolean)true);
            this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

