/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectPathLookupElement
extends LookupElement {
    @NotNull
    private final String myProjectName;
    @NotNull
    private final String myProjectPath;

    public ExternalProjectPathLookupElement(@NotNull String projectName, @NotNull String projectPath) {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathLookupElement", "<init>"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathLookupElement", "<init>"));
        }
        this.myProjectName = projectName;
        this.myProjectPath = projectPath;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myProjectName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathLookupElement", "getLookupString"));
        }
        return string;
    }

    public void handleInsert(InsertionContext context) {
        Editor editor = context.getEditor();
        final FoldingModel foldingModel = editor.getFoldingModel();
        foldingModel.runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                FoldRegion[] regions;
                for (FoldRegion region : regions = foldingModel.getAllFoldRegions()) {
                    foldingModel.removeFoldRegion(region);
                }
            }
        });
        Document document = editor.getDocument();
        final int startOffset = context.getStartOffset();
        document.replaceString(startOffset, document.getTextLength(), (CharSequence)this.myProjectPath);
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        foldingModel.runBatchFoldingOperationDoNotCollapseCaret(new Runnable(){

            @Override
            public void run() {
                FoldRegion region = foldingModel.addFoldRegion(startOffset, startOffset + ExternalProjectPathLookupElement.this.myProjectPath.length(), ExternalProjectPathLookupElement.this.myProjectName);
                if (region != null) {
                    region.setExpanded(false);
                }
            }
        });
    }
}

