/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.filter;

import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionsFilter {
    private final Set<HighlightSeverity> mySuitableSeverities = new HashSet();
    private final Set<String> mySuitableLanguageIds = new HashSet();
    private Boolean mySuitableInspectionsStates;
    private boolean myAvailableOnlyForAnalyze;
    private boolean myShowOnlyCleanupInspections;

    public boolean isAvailableOnlyForAnalyze() {
        return this.myAvailableOnlyForAnalyze;
    }

    public boolean isShowOnlyCleanupInspections() {
        return this.myShowOnlyCleanupInspections;
    }

    public Boolean getSuitableInspectionsStates() {
        return this.mySuitableInspectionsStates;
    }

    public boolean containsSeverity(HighlightSeverity severity) {
        return this.mySuitableSeverities.contains(severity);
    }

    public boolean containsLanguageId(String languageId) {
        return this.mySuitableLanguageIds.contains(languageId);
    }

    public void setShowOnlyCleanupInspections(boolean showOnlyCleanupInspections) {
        this.myShowOnlyCleanupInspections = showOnlyCleanupInspections;
        this.filterChanged();
    }

    public void setAvailableOnlyForAnalyze(boolean availableOnlyForAnalyze) {
        this.myAvailableOnlyForAnalyze = availableOnlyForAnalyze;
        this.filterChanged();
    }

    public void setSuitableInspectionsStates(@Nullable Boolean suitableInspectionsStates) {
        this.mySuitableInspectionsStates = suitableInspectionsStates;
        this.filterChanged();
    }

    public void addSeverity(HighlightSeverity severity) {
        this.mySuitableSeverities.add(severity);
        this.filterChanged();
    }

    public void removeSeverity(HighlightSeverity severity) {
        this.mySuitableSeverities.remove(severity);
        this.filterChanged();
    }

    public void addLanguageId(String languageId) {
        this.mySuitableLanguageIds.add(languageId);
        this.filterChanged();
    }

    public void removeLanguageId(String languageId) {
        this.mySuitableLanguageIds.remove(languageId);
        this.filterChanged();
    }

    public void reset() {
        this.mySuitableInspectionsStates = null;
        this.myAvailableOnlyForAnalyze = false;
        this.myShowOnlyCleanupInspections = false;
        this.mySuitableSeverities.clear();
        this.mySuitableLanguageIds.clear();
        this.filterChanged();
    }

    public boolean isEmptyFilter() {
        return this.mySuitableInspectionsStates == null && !this.myAvailableOnlyForAnalyze && !this.myShowOnlyCleanupInspections && this.mySuitableSeverities.isEmpty() && this.mySuitableLanguageIds.isEmpty();
    }

    public boolean matches(Tools tools) {
        if (this.myShowOnlyCleanupInspections && !tools.getTool().isCleanupTool()) {
            return false;
        }
        if (this.mySuitableInspectionsStates != null && this.mySuitableInspectionsStates.booleanValue() != tools.isEnabled()) {
            return false;
        }
        if (this.myAvailableOnlyForAnalyze != InspectionsFilter.isAvailableOnlyForAnalyze(tools)) {
            return false;
        }
        if (!this.mySuitableSeverities.isEmpty()) {
            boolean suitable = false;
            for (ScopeToolState state : tools.getTools()) {
                if (this.mySuitableInspectionsStates != null && this.mySuitableInspectionsStates.booleanValue() != state.isEnabled() || !this.mySuitableSeverities.contains(tools.getDefaultState().getLevel().getSeverity())) continue;
                suitable = true;
                break;
            }
            if (!suitable) {
                return false;
            }
        }
        String languageId = tools.getDefaultState().getTool().getLanguage();
        return this.mySuitableLanguageIds.isEmpty() || this.mySuitableLanguageIds.contains(languageId);
    }

    protected abstract void filterChanged();

    private static boolean isAvailableOnlyForAnalyze(Tools tools) {
        InspectionToolWrapper tool = tools.getTool();
        return tool instanceof GlobalInspectionToolWrapper && ((GlobalInspectionToolWrapper)tool).worksInBatchModeOnly();
    }
}

