/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableInplaceRenameHandler
implements RenameHandler {
    private static final ThreadLocal<String> ourPreventInlineRenameFlag = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler");

    public final boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiElement element = PsiElementRenameHandler.getElement(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (editor == null || file == null) {
            return false;
        }
        if (ourPreventInlineRenameFlag.get() != null) {
            return false;
        }
        return this.isAvailable(element, editor, file);
    }

    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file) {
        PsiElement nameSuggestionContext = file.findElementAt(editor.getCaretModel().getOffset());
        RefactoringSupportProvider supportProvider = element == null ? null : (RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(element.getLanguage());
        return supportProvider != null && editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider.isInplaceRenameAvailable(element, nameSuggestionContext);
    }

    public final boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler", "invoke"));
        }
        PsiElement element = PsiElementRenameHandler.getElement(dataContext);
        if (element == null) {
            if (LookupManager.getActiveLookup(editor) != null) {
                PsiElement elementUnderCaret = file.findElementAt(editor.getCaretModel().getOffset());
                if (elementUnderCaret != null) {
                    PsiElement parent = elementUnderCaret.getParent();
                    element = parent instanceof PsiReference ? ((PsiReference)parent).resolve() : PsiTreeUtil.getParentOfType((PsiElement)elementUnderCaret, PsiNamedElement.class);
                }
                if (element == null) {
                    return;
                }
            } else {
                return;
            }
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (this.checkAvailable(element, editor, dataContext)) {
            this.doRename(element, editor, dataContext);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler", "invoke"));
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PsiElementRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (this.checkAvailable(element, editor, dataContext)) {
            this.doRename(element, editor, dataContext);
        }
    }

    protected boolean checkAvailable(PsiElement elementToRename, Editor editor, DataContext dataContext) {
        if (!this.isAvailableOnDataContext(dataContext)) {
            LOG.error("Recursive invocation");
            RenameHandlerRegistry.getInstance().getRenameHandler(dataContext).invoke(elementToRename.getProject(), editor, elementToRename.getContainingFile(), dataContext);
            return false;
        }
        return true;
    }

    @Nullable
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, Editor editor, DataContext dataContext) {
        boolean startedRename;
        if (elementToRename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToRename", "com/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler", "doRename"));
        }
        VariableInplaceRenamer renamer = this.createRenamer(elementToRename, editor);
        boolean bl = startedRename = renamer == null ? false : renamer.performInplaceRename();
        if (!startedRename) {
            VariableInplaceRenameHandler.performDialogRename(elementToRename, editor, dataContext, renamer != null ? renamer.myInitialName : null);
        }
        return renamer;
    }

    protected static void performDialogRename(PsiElement elementToRename, Editor editor, DataContext dataContext) {
        VariableInplaceRenameHandler.performDialogRename(elementToRename, editor, dataContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void performDialogRename(PsiElement elementToRename, Editor editor, DataContext dataContext, String initialName) {
        try {
            ourPreventInlineRenameFlag.set(initialName == null ? "" : initialName);
            RenameHandler handler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
            assert (handler != null) : elementToRename;
            handler.invoke(elementToRename.getProject(), editor, elementToRename.getContainingFile(), dataContext);
        }
        finally {
            ourPreventInlineRenameFlag.set(null);
        }
    }

    @Nullable
    public static String getInitialName() {
        String str = ourPreventInlineRenameFlag.get();
        return StringUtil.isEmpty((String)str) ? null : str;
    }

    @Nullable
    protected VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor) {
        if (elementToRename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToRename", "com/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler", "createRenamer"));
        }
        return new VariableInplaceRenamer((PsiNamedElement)elementToRename, editor);
    }
}

