/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDictionary
implements EditableDictionary {
    @NonNls
    private static final String DEFAULT_CURRENT_USER_NAME = "default.user";
    private static final String DEFAULT_PROJECT_DICTIONARY_NAME = "project";
    private String activeName;
    private Set<EditableDictionary> dictionaries;

    public ProjectDictionary() {
    }

    public ProjectDictionary(@NotNull Set<EditableDictionary> dictionaries) {
        if (dictionaries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dictionaries", "com/intellij/spellchecker/dictionary/ProjectDictionary", "<init>"));
        }
        this.dictionaries = dictionaries;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        if (DEFAULT_PROJECT_DICTIONARY_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/dictionary/ProjectDictionary", "getName"));
        }
        return DEFAULT_PROJECT_DICTIONARY_NAME;
    }

    public void setActiveName(String name) {
        this.activeName = name;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/spellchecker/dictionary/ProjectDictionary", "contains"));
        }
        if (this.dictionaries == null) {
            return false;
        }
        int errors = 0;
        for (EditableDictionary dictionary : this.dictionaries) {
            Boolean contains = dictionary.contains(word);
            if (contains == null) {
                ++errors;
                continue;
            }
            if (!contains.booleanValue()) continue;
            return true;
        }
        if (errors == this.dictionaries.size()) {
            return null;
        }
        return false;
    }

    @Override
    public void addToDictionary(String word) {
        this.getActiveDictionary().addToDictionary(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        this.getActiveDictionary().removeFromDictionary(word);
    }

    @NotNull
    private EditableDictionary getActiveDictionary() {
        EditableDictionary editableDictionary = this.ensureCurrentUserDictionary();
        if (editableDictionary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/dictionary/ProjectDictionary", "getActiveDictionary"));
        }
        return editableDictionary;
    }

    @NotNull
    private EditableDictionary ensureCurrentUserDictionary() {
        EditableDictionary result;
        if (this.activeName == null) {
            this.activeName = DEFAULT_CURRENT_USER_NAME;
        }
        if ((result = this.getDictionaryByName(this.activeName)) == null) {
            result = new UserDictionary(this.activeName);
            if (this.dictionaries == null) {
                this.dictionaries = new THashSet();
            }
            this.dictionaries.add(result);
        }
        EditableDictionary editableDictionary = result;
        if (editableDictionary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/dictionary/ProjectDictionary", "ensureCurrentUserDictionary"));
        }
        return editableDictionary;
    }

    @Nullable
    private EditableDictionary getDictionaryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spellchecker/dictionary/ProjectDictionary", "getDictionaryByName"));
        }
        if (this.dictionaries == null) {
            return null;
        }
        EditableDictionary result = null;
        for (EditableDictionary dictionary : this.dictionaries) {
            if (!dictionary.getName().equals(name)) continue;
            result = dictionary;
            break;
        }
        return result;
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        this.getActiveDictionary().replaceAll(words);
    }

    @Override
    public void clear() {
        this.getActiveDictionary().clear();
    }

    @Override
    @Nullable
    public Set<String> getWords() {
        if (this.dictionaries == null) {
            return null;
        }
        HashSet<String> words = new HashSet<String>();
        for (EditableDictionary dictionary : this.dictionaries) {
            Set<String> otherWords = dictionary.getWords();
            if (otherWords == null) continue;
            words.addAll(otherWords);
        }
        return words;
    }

    @Override
    public int size() {
        int result = 0;
        for (EditableDictionary dictionary : this.dictionaries) {
            result += dictionary.size();
        }
        return result;
    }

    @Override
    public void traverse(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/dictionary/ProjectDictionary", "traverse"));
        }
        if (this.dictionaries == null) {
            return;
        }
        for (EditableDictionary dictionary : this.dictionaries) {
            dictionary.traverse(consumer);
        }
    }

    @Override
    @Nullable
    public Set<String> getEditableWords() {
        return this.getActiveDictionary().getWords();
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        this.getActiveDictionary().addToDictionary(words);
    }

    public Set<EditableDictionary> getDictionaries() {
        return this.dictionaries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDictionary that = (ProjectDictionary)o;
        if (this.activeName != null ? !this.activeName.equals(that.activeName) : that.activeName != null) {
            return false;
        }
        return !(this.dictionaries != null ? !((Object)this.dictionaries).equals(that.dictionaries) : that.dictionaries != null);
    }

    public int hashCode() {
        int result = this.activeName != null ? this.activeName.hashCode() : 0;
        result = 31 * result + (this.dictionaries != null ? ((Object)this.dictionaries).hashCode() : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return "ProjectDictionary{activeName='" + this.activeName + '\'' + ", dictionaries=" + this.dictionaries + '}';
    }
}

