/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.MergeIfOrPredicate;
import org.jetbrains.annotations.NotNull;

public class MergeIfOrIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        MergeIfOrPredicate mergeIfOrPredicate = new MergeIfOrPredicate();
        if (mergeIfOrPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/trivialif/MergeIfOrIntention", "getElementPredicate"));
        }
        return mergeIfOrPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiJavaToken token = (PsiJavaToken)element;
        if (MergeIfOrPredicate.isMergableExplicitIf((PsiElement)token)) {
            MergeIfOrIntention.replaceMergeableExplicitIf(token);
        } else {
            MergeIfOrIntention.replaceMergeableImplicitIf(token);
        }
    }

    private static void replaceMergeableExplicitIf(PsiJavaToken token) throws IncorrectOperationException {
        PsiIfStatement parentStatement = (PsiIfStatement)token.getParent();
        assert (parentStatement != null);
        PsiIfStatement childStatement = (PsiIfStatement)parentStatement.getElseBranch();
        if (childStatement == null) {
            return;
        }
        PsiExpression childCondition = childStatement.getCondition();
        if (childCondition == null) {
            return;
        }
        String childConditionText = ParenthesesUtils.getPrecedence(childCondition) > 14 ? '(' + childCondition.getText() + ')' : childCondition.getText();
        PsiExpression condition = parentStatement.getCondition();
        if (condition == null) {
            return;
        }
        String parentConditionText = ParenthesesUtils.getPrecedence(condition) > 14 ? '(' + condition.getText() + ')' : condition.getText();
        PsiStatement parentThenBranch = parentStatement.getThenBranch();
        if (parentThenBranch == null) {
            return;
        }
        String parentThenBranchText = parentThenBranch.getText();
        StringBuilder statement = new StringBuilder();
        statement.append("if(");
        statement.append(parentConditionText);
        statement.append("||");
        statement.append(childConditionText);
        statement.append(')');
        statement.append(parentThenBranchText);
        PsiStatement childElseBranch = childStatement.getElseBranch();
        if (childElseBranch != null) {
            String childElseBranchText = childElseBranch.getText();
            statement.append("else ");
            statement.append(childElseBranchText);
        }
        String newStatement = statement.toString();
        PsiReplacementUtil.replaceStatement((PsiStatement)parentStatement, newStatement);
    }

    private static void replaceMergeableImplicitIf(PsiJavaToken token) throws IncorrectOperationException {
        PsiIfStatement parentStatement = (PsiIfStatement)token.getParent();
        PsiIfStatement childStatement = (PsiIfStatement)PsiTreeUtil.skipSiblingsForward((PsiElement)parentStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        assert (childStatement != null);
        PsiExpression childCondition = childStatement.getCondition();
        if (childCondition == null) {
            return;
        }
        String childConditionText = ParenthesesUtils.getPrecedence(childCondition) > 14 ? '(' + childCondition.getText() + ')' : childCondition.getText();
        assert (parentStatement != null);
        PsiExpression condition = parentStatement.getCondition();
        if (condition == null) {
            return;
        }
        String parentConditionText = ParenthesesUtils.getPrecedence(condition) > 14 ? '(' + condition.getText() + ')' : condition.getText();
        PsiStatement parentThenBranch = parentStatement.getThenBranch();
        if (parentThenBranch == null) {
            return;
        }
        StringBuilder newStatement = new StringBuilder();
        newStatement.append("if(");
        newStatement.append(parentConditionText);
        newStatement.append("||");
        newStatement.append(childConditionText);
        newStatement.append(')');
        newStatement.append(parentThenBranch.getText());
        PsiStatement childElseBranch = childStatement.getElseBranch();
        if (childElseBranch != null) {
            newStatement.append("else ");
            newStatement.append(childElseBranch.getText());
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)parentStatement, newStatement.toString());
        childStatement.delete();
    }
}

