/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.IOException;

public class OpenVmTraceHandler
implements ClientData.IMethodProfilingHandler {
    private static final Logger LOG = Logger.getInstance(OpenVmTraceHandler.class);
    private final Project myProject;

    public OpenVmTraceHandler(Project project) {
        this.myProject = project;
    }

    public void onSuccess(String remoteFilePath, Client client) {
        this.showError("Method profiling: Older devices (API level < 10) are not supported yet. Please manually retrieve the file " + remoteFilePath + " from the device and open the file to view the results.");
    }

    public void onSuccess(byte[] data, Client client) {
        File f;
        try {
            f = FileUtil.createTempFile((String)"ddms", (String)".trace");
            FileUtil.writeToFile((File)f, (byte[])data);
            LOG.info("Method Profiling: Saved VM trace to file: " + f.getAbsolutePath());
        }
        catch (IOException e) {
            this.showError("Unexpected error while saving trace data to a temporary file: " + ExceptionUtil.getRootCause((Throwable)e).getLocalizedMessage());
            return;
        }
        final VirtualFile vf = VfsUtil.findFileByIoFile((File)f, (boolean)true);
        if (vf == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(OpenVmTraceHandler.this.myProject, vf);
                FileEditorManager.getInstance((Project)OpenVmTraceHandler.this.myProject).openEditor(descriptor, true);
            }
        });
    }

    public void onStartFailure(Client client, String message) {
        this.showError(message);
    }

    public void onEndFailure(Client client, String message) {
        this.showError(message);
    }

    private void showError(final String message) {
        LOG.error("Method Profiling: " + message);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)OpenVmTraceHandler.this.myProject, (String)message, (String)"Method Trace");
            }
        });
    }
}

