/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.IdeaJavaProject;
import com.android.tools.idea.gradle.JavaModel;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModuleCustomizer
extends AbstractDependenciesModuleCustomizer<IdeaJavaProject> {
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    private static final Logger LOG = Logger.getInstance(AbstractDependenciesModuleCustomizer.class);
    private static final DependencyScope DEFAULT_DEPENDENCY_SCOPE = DependencyScope.COMPILE;

    @Override
    protected void setUpDependencies(@NotNull ModifiableRootModel model, @NotNull IdeaJavaProject javaProject, @NotNull List<Message> errorsFound) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (javaProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaProject", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (errorsFound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorsFound", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        ArrayList unresolved = Lists.newArrayList();
        List<? extends IdeaDependency> dependencies = javaProject.getDependencies();
        for (IdeaDependency ideaDependency : dependencies) {
            if (ideaDependency instanceof IdeaModuleDependency) {
                DependenciesModuleCustomizer.updateDependency(model, (IdeaModuleDependency)ideaDependency, errorsFound);
                continue;
            }
            if (!(ideaDependency instanceof IdeaSingleEntryLibraryDependency)) continue;
            IdeaSingleEntryLibraryDependency libDependency = (IdeaSingleEntryLibraryDependency)ideaDependency;
            if (DependenciesModuleCustomizer.isResolved(libDependency)) {
                this.updateDependency(model, (IdeaSingleEntryLibraryDependency)ideaDependency, errorsFound);
                continue;
            }
            String name = DependenciesModuleCustomizer.getUnresolvedDependencyName(libDependency);
            if (name == null) continue;
            unresolved.add(name);
        }
        Module module = model.getModule();
        ProjectSyncMessages projectSyncMessages = ProjectSyncMessages.getInstance(model.getProject());
        projectSyncMessages.reportUnresolvedDependencies(unresolved, module);
        JavaGradleFacet facet = DependenciesModuleCustomizer.setAndGetJavaGradleFacet(module);
        File buildFolderPath = javaProject.getBuildFolderPath();
        if (Projects.isGradleProjectModule(module)) {
            ((JavaGradleFacetConfiguration)facet.getConfiguration()).BUILD_FOLDER_PATH = buildFolderPath != null ? FileUtil.toSystemIndependentName((String)buildFolderPath.getPath()) : "";
        } else {
            JavaModel javaModel = new JavaModel(unresolved, buildFolderPath);
            facet.setJavaModel(javaModel);
        }
    }

    private static boolean isResolved(@NotNull IdeaSingleEntryLibraryDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "isResolved"));
        }
        String libraryName = DependenciesModuleCustomizer.getFileName(dependency);
        return libraryName != null && !libraryName.startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
    }

    @Nullable
    private static String getUnresolvedDependencyName(@NotNull IdeaSingleEntryLibraryDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "getUnresolvedDependencyName"));
        }
        String libraryName = DependenciesModuleCustomizer.getFileName(dependency);
        if (libraryName == null) {
            return null;
        }
        return libraryName.substring(UNRESOLVED_DEPENDENCY_PREFIX.length()).replace(' ', ':');
    }

    @Nullable
    private static String getFileName(@NotNull IdeaSingleEntryLibraryDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "getFileName"));
        }
        File binaryPath = dependency.getFile();
        return binaryPath != null ? binaryPath.getName() : null;
    }

    private static void updateDependency(@NotNull ModifiableRootModel model, @NotNull IdeaModuleDependency dependency, @NotNull List<Message> errorsFound) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (errorsFound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorsFound", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        IdeaModule dependencyModule = dependency.getDependencyModule();
        if (dependencyModule == null || Strings.isNullOrEmpty((String)dependencyModule.getName())) {
            String msg = "Found a module dependency without name: " + dependency;
            LOG.info(msg);
            errorsFound.add(new Message("Failed to set up dependencies", Message.Type.ERROR, msg));
            return;
        }
        String moduleName = dependencyModule.getName();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)model.getProject());
        Module found = null;
        for (Module module : moduleManager.getModules()) {
            if (!moduleName.equals(module.getName())) continue;
            found = module;
        }
        if (found != null) {
            ModuleOrderEntry orderEntry = model.addModuleOrderEntry(found);
            orderEntry.setExported(true);
            return;
        }
        String msg = String.format("Unable fo find module '%1$s'.", moduleName);
        LOG.info(msg);
        errorsFound.add(new Message("Failed to set up dependencies", Message.Type.ERROR, msg));
    }

    private void updateDependency(@NotNull ModifiableRootModel model, @NotNull IdeaSingleEntryLibraryDependency dependency, @NotNull List<Message> errorsFound) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (errorsFound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorsFound", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        DependencyScope scope = DependenciesModuleCustomizer.parseScope(dependency.getScope());
        File binaryPath = dependency.getFile();
        if (binaryPath == null) {
            String msg = "Found a library dependency without a 'binary' path: " + dependency;
            LOG.info(msg);
            errorsFound.add(new Message("Failed to set up dependencies", Message.Type.ERROR, msg));
            return;
        }
        String path = binaryPath.getPath();
        String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)path);
        this.setUpLibraryDependency(model, name, scope, Collections.singletonList(path), DependenciesModuleCustomizer.getPath(dependency.getSource()), DependenciesModuleCustomizer.getPath(dependency.getJavadoc()));
    }

    @NotNull
    private static List<String> getPath(@Nullable File file) {
        List<String> list = file == null ? Collections.emptyList() : Collections.singletonList(file.getPath());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "getPath"));
        }
        return list;
    }

    @NotNull
    private static DependencyScope parseScope(@Nullable IdeaDependencyScope scope) {
        if (scope == null) {
            DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
            if (dependencyScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "parseScope"));
            }
            return dependencyScope;
        }
        String description = scope.getScope();
        if (description == null) {
            DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
            if (dependencyScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "parseScope"));
            }
            return dependencyScope;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!description.equalsIgnoreCase(dependencyScope.toString())) continue;
            DependencyScope dependencyScope2 = dependencyScope;
            if (dependencyScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "parseScope"));
            }
            return dependencyScope2;
        }
        DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "parseScope"));
        }
        return dependencyScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static JavaGradleFacet setAndGetJavaGradleFacet(Module module) {
        JavaGradleFacet facet = JavaGradleFacet.getInstance(module);
        if (facet != null) {
            JavaGradleFacet javaGradleFacet = facet;
            if (javaGradleFacet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setAndGetJavaGradleFacet"));
            }
            return javaGradleFacet;
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel model = facetManager.createModifiableModel();
        try {
            facet = (JavaGradleFacet)facetManager.createFacet((FacetType)JavaGradleFacet.getFacetType(), "Java-Gradle", null);
            model.addFacet((Facet)facet);
        }
        finally {
            model.commit();
        }
        JavaGradleFacet javaGradleFacet = facet;
        if (javaGradleFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setAndGetJavaGradleFacet"));
        }
        return javaGradleFacet;
    }
}

