/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.Model;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRuleExecutionException;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.AbstractAnnotationDrivenMethodRuleDefinitionHandler;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.model.internal.inspect.RuleSourceDependencies;
import org.gradle.model.internal.registry.ModelRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCreationRuleDefinitionHandler
extends AbstractAnnotationDrivenMethodRuleDefinitionHandler<Model> {
    @Override
    public <T> void register(MethodRuleDefinition<T> ruleDefinition, ModelRegistry modelRegistry, RuleSourceDependencies dependencies) {
        String modelName = this.determineModelName(ruleDefinition);
        try {
            ModelPath.validatePath(modelName);
        }
        catch (Exception e) {
            throw new InvalidModelRuleDeclarationException(String.format("Path of declared model element created by rule %s is invalid.", ruleDefinition.getDescriptor()), (Throwable)e);
        }
        ModelType<T> returnType = ruleDefinition.getReturnType();
        ModelPath path = ModelPath.path(modelName);
        List<ModelReference<?>> references = ruleDefinition.getReferences();
        ModelRuleDescriptor descriptor = ruleDefinition.getDescriptor();
        ModelRuleInvokerBackedTransformer transformer = new ModelRuleInvokerBackedTransformer(ruleDefinition.getRuleInvoker(), descriptor, references);
        modelRegistry.create(ModelCreators.of(ModelReference.of(path, returnType), transformer).descriptor(descriptor).inputs(references).build());
    }

    private String determineModelName(MethodRuleDefinition<?> ruleDefinition) {
        String annotationValue = ruleDefinition.getAnnotation(Model.class).value();
        if (annotationValue == null || annotationValue.isEmpty()) {
            return ruleDefinition.getMethodName();
        }
        return annotationValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelRuleInvokerBackedTransformer<T>
    implements Transformer<T, Inputs> {
        private final ModelRuleDescriptor descriptor;
        private final ModelRuleInvoker<T> ruleInvoker;
        private final List<ModelReference<?>> inputReferences;

        private ModelRuleInvokerBackedTransformer(ModelRuleInvoker<T> ruleInvoker, ModelRuleDescriptor descriptor, List<ModelReference<?>> inputReferences) {
            this.descriptor = descriptor;
            this.ruleInvoker = ruleInvoker;
            this.inputReferences = inputReferences;
        }

        public T transform(Inputs inputs) {
            T instance;
            if (inputs.size() == 0) {
                instance = this.ruleInvoker.invoke(new Object[0]);
            } else {
                Object[] args = new Object[inputs.size()];
                for (int i = 0; i < inputs.size(); ++i) {
                    args[i] = inputs.get(i, this.inputReferences.get(i).getType()).getInstance();
                }
                instance = this.ruleInvoker.invoke(args);
            }
            if (instance == null) {
                throw new ModelRuleExecutionException(this.descriptor, "rule returned null");
            }
            return instance;
        }
    }
}

