/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.vcs.log.Hash;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRemote;
import org.jetbrains.annotations.NotNull;

public class GitStandardRemoteBranch
extends GitRemoteBranch {
    @NotNull
    private final GitRemote myRemote;
    @NotNull
    private final String myNameAtRemote;

    public GitStandardRemoteBranch(@NotNull GitRemote remote, @NotNull String nameAtRemote, @NotNull Hash hash) {
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/GitStandardRemoteBranch", "<init>"));
        }
        if (nameAtRemote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameAtRemote", "git4idea/GitStandardRemoteBranch", "<init>"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/GitStandardRemoteBranch", "<init>"));
        }
        super(GitStandardRemoteBranch.formStandardName(remote, GitBranchUtil.stripRefsPrefix(nameAtRemote)), hash);
        this.myRemote = remote;
        this.myNameAtRemote = GitBranchUtil.stripRefsPrefix(nameAtRemote);
    }

    @NotNull
    private static String formStandardName(@NotNull GitRemote remote, @NotNull String nameAtRemote) {
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/GitStandardRemoteBranch", "formStandardName"));
        }
        if (nameAtRemote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameAtRemote", "git4idea/GitStandardRemoteBranch", "formStandardName"));
        }
        String string = remote.getName() + "/" + nameAtRemote;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitStandardRemoteBranch", "formStandardName"));
        }
        return string;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    @NotNull
    public GitRemote getRemote() {
        GitRemote gitRemote = this.myRemote;
        if (gitRemote == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitStandardRemoteBranch", "getRemote"));
        }
        return gitRemote;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitStandardRemoteBranch branch = (GitStandardRemoteBranch)o;
        if (!this.myNameAtRemote.equals(branch.myNameAtRemote)) {
            return false;
        }
        return this.myRemote.equals(branch.myRemote);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myRemote.hashCode();
        result = 31 * result + this.myNameAtRemote.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    @NotNull
    public String getNameForRemoteOperations() {
        String string = this.myNameAtRemote;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitStandardRemoteBranch", "getNameForRemoteOperations"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getNameForLocalOperations() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitStandardRemoteBranch", "getNameForLocalOperations"));
        }
        return string;
    }
}

