/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.core.JavaCoreBundle;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageLevel {
    JDK_1_3("Java 1.3", JavaCoreBundle.message("jdk.1.3.language.level.description", new Object[0])),
    JDK_1_4("Java 1.4", JavaCoreBundle.message("jdk.1.4.language.level.description", new Object[0])),
    JDK_1_5("Java 5.0", JavaCoreBundle.message("jdk.1.5.language.level.description", new Object[0])),
    JDK_1_6("Java 6", JavaCoreBundle.message("jdk.1.6.language.level.description", new Object[0])),
    JDK_1_7("Java 7", JavaCoreBundle.message("jdk.1.7.language.level.description", new Object[0])),
    JDK_1_8("Java 8", JavaCoreBundle.message("jdk.1.8.language.level.description", new Object[0])),
    JDK_1_9("Java 9", JavaCoreBundle.message("jdk.1.9.language.level.description", new Object[0])),
    JDK_X("Java X", JavaCoreBundle.message("jdk.X.language.level.description", new Object[0]));

    public static final LanguageLevel HIGHEST;
    public static final Key<LanguageLevel> KEY;
    private final String myName;
    private final String myPresentableText;

    private LanguageLevel(String name, String presentableText) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/pom/java/LanguageLevel", "<init>"));
        }
        if (presentableText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableText", "com/intellij/pom/java/LanguageLevel", "<init>"));
        }
        this.myName = name;
        this.myPresentableText = presentableText;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/java/LanguageLevel", "getName"));
        }
        return string;
    }

    @NotNull
    @Nls
    public String getPresentableText() {
        String string = this.myPresentableText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/java/LanguageLevel", "getPresentableText"));
        }
        return string;
    }

    public boolean isAtLeast(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/pom/java/LanguageLevel", "isAtLeast"));
        }
        return this.compareTo(level) >= 0;
    }

    @Nullable
    public static LanguageLevel parse(@Nullable String value) {
        if ("1.3".equals(value)) {
            return JDK_1_3;
        }
        if ("1.4".equals(value)) {
            return JDK_1_4;
        }
        if ("1.5".equals(value)) {
            return JDK_1_5;
        }
        if ("1.6".equals(value)) {
            return JDK_1_6;
        }
        if ("1.7".equals(value)) {
            return JDK_1_7;
        }
        if ("1.8".equals(value)) {
            return JDK_1_8;
        }
        if ("1.9".equals(value)) {
            return JDK_1_9;
        }
        return null;
    }

    static {
        HIGHEST = JDK_1_8;
        KEY = Key.create((String)"LANGUAGE_LEVEL");
    }
}

