/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.tools.idea.editors.navigation.macros.Instantiation;
import com.android.tools.idea.editors.navigation.macros.Unifier;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MultiMatch {
    public final PsiMethod macro;
    public final Map<String, PsiMethod> subMacros = new LinkedHashMap<String, PsiMethod>();

    public MultiMatch(PsiMethod macro) {
        this.macro = macro;
    }

    public void addSubMacro(String name, PsiMethod macro) {
        this.subMacros.put(name, macro);
    }

    @Nullable
    public Bindings<PsiElement> match(PsiElement element) {
        Map<String, PsiElement> bindings = Unifier.match(this.macro, element);
        if (bindings == null) {
            return null;
        }
        HashMap subBindings = new HashMap();
        for (Map.Entry<String, PsiMethod> entry : this.subMacros.entrySet()) {
            String name = entry.getKey();
            PsiMethod template = entry.getValue();
            Map<String, PsiElement> subBinding = Unifier.match(template, bindings.get(name));
            if (subBinding == null) {
                return null;
            }
            subBindings.put(name, subBinding);
        }
        return new Bindings<PsiElement>(bindings, subBindings);
    }

    public String instantiate(Bindings<String> bindings) {
        Map<String, String> bb = bindings.bindings;
        for (Map.Entry<String, PsiMethod> entry : this.subMacros.entrySet()) {
            String name = entry.getKey();
            PsiMethod template = entry.getValue();
            bb.put(name, Instantiation.instantiate2(template, bindings.subBindings.get(name)));
        }
        return Instantiation.instantiate2(this.macro, bb);
    }

    public static class Bindings<T> {
        public final Map<String, T> bindings;
        public final Map<String, Map<String, T>> subBindings;

        Bindings(Map<String, T> bindings, Map<String, Map<String, T>> subBindings) {
            this.bindings = bindings;
            this.subBindings = subBindings;
        }

        Bindings() {
            this(new HashMap(), new HashMap<String, Map<String, T>>());
        }

        public T get(String key) {
            return this.bindings.get(key);
        }

        public void put(String key, T value) {
            this.bindings.put(key, value);
        }

        public T get(String key1, String key2) {
            Map<String, T> subBinding = this.subBindings.get(key1);
            return subBinding == null ? null : (T)subBinding.get(key2);
        }

        public void put(String key1, String key2, T value) {
            Map<String, T> subBinding = this.subBindings.get(key1);
            if (subBinding == null) {
                subBinding = new HashMap<String, T>();
                this.subBindings.put(key1, subBinding);
            }
            subBinding.put(key2, value);
        }

        public String toString() {
            return "Bindings{bindings=" + this.bindings + ", subBindings=" + this.subBindings + '}';
        }
    }
}

